<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  25/04/11, 11:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class NewCustomers
  @brief extract db value
	For view new customers (by groupe) by mount
*/
class NewCustomers
  Implements ModGraphStatsData{
  /**
    @var nombre de status de order present
  */
  public $nbr_val;
  /**
    @var tableau de couleur de status
  */
  public $les_color;
  /**
    @var tableau de couleur de status
  */
  public $base_date;
  /**
    @var calcul taille repere y
  */
  public $base_y;
  /**
    @var title
  */
  public $title;
  /**
    @var $value array value;
  */
  public $value;

  /**
  */
  function __construct($year='',$month='',$day='',$year_end=''){

    $this->title= __('title graph new customers by groupe');


    $year= (isset($_REQUEST['year'])?$_REQUEST['year'] :(date('Y')));
    $year_end= (isset($_REQUEST['year_end'])?$_REQUEST['year_end'] :date('Y'));


    $this->base_year=$year=(!empty($year)? $year : date("Y") );
    $year_end=(!empty($year_end)? $year_end : date("Y") );

    $this->base_date =$year.'-'.(!empty($month)? $month : '00') . '-'.(!empty($day)? $day : '00');

    $this->les_status();

    /**
      Tableau mensuel base
    */
    $amplitude=($year_end-$year);
    for($ir=0; $ir<=$amplitude; $ir++ ) {
      for($i=0; $i<12; $i++ ) {
	$s[(($ir*12)+$i)][0]=str_pad(($i+1), 2, "0", STR_PAD_LEFT).'-'.substr(($this->base_year+$ir),2);
	for($is=1; $is<=$this->nbr_val; $is++ )
	  $s[(($ir*12)+$i)][$is]=0;
      }
    }
    $this->value=$s;

    $this->tab_for_order();
  }

/**
  @remarks Next method Use Graphs class , this table is load after call graph and depend of load class graph
*/

  /**
    @brief construct thead table
  */
  public  function tep_get_th(){
    $les_color_name[]=__('mois');
    return array_merge($les_color_name,$this->les_color_name);
  }

  /**
    @brief construct array value for datatable display
  */
  public  function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    return $this->value;
  }



/**
  @remarks Private medthod
*/

  /**
    @brief Mise en tableau et prepa des valeur
  */
  private function tab_for_order(){
    if( ($query=$this->les_orders()) ==false) return null;

    $max=0;
    while ($orders = tep_db_fetch_array($query)){
      $value_sommme=$orders['total'];
      $mit=($orders['mois']-1);
      $anne=($this->base_year==$orders['annee'])? 0  : (($orders['annee']-$this->base_year)*12);

      if(isset($this->value[($anne+$mit)])) {
	if($max<=$value_sommme) $max=$value_sommme;
	$this->value[($anne+$mit)][$orders['status']]=$value_sommme;
      }
    }

      if($max<=10)$this->base_y='5';
      elseif($max<=100)$this->base_y='25';
      elseif($max<=300)$this->base_y='50';
      elseif($max<=800)$this->base_y='10';
  }

  /**
    Recup orders
  */
  private function les_orders(){
    global $languages_id;
    $DB=Database::getInstance();
    $customers_account = $DB->query($sql="select EXTRACT(YEAR FROM customers_info_date_account_created) AS annee, EXTRACT(MONTH FROM customers_info_date_account_created) AS mois, customers_info_date_account_created as date, COUNT(*) as total, c.customers_group_ra as status  from ".TABLE_CUSTOMERS." c, ".TABLE_CUSTOMERS_INFO." ci WHERE c.customers_id= ci.customers_info_id and  customers_info_date_account_created  >= '".$this->base_date."' GROUP BY year(customers_info_date_account_created),month(customers_info_date_account_created)");

      if ($customers_account->__get('numRows')> 0) return $customers_account;
      else return false;
  }


  /**
    Recup status
  */
  private function les_status(){
    $DB=Database::getInstance();
    $status_color =  $DB->query("select customers_group_id, customers_group_name FROM ".TABLE_CUSTOMERS_GROUPS." ");
    while ($sales_products = $status_color->fetchAssoc())
      $this->les_color_name[]=utf8_decode($sales_products['customers_group_name']);

    $this->les_color[]=GraphUtility::html2rgb('#4086d1');
    $this->les_color[]=GraphUtility::html2rgb('#ffc652');

    $this->nbr_val=count($this->les_color_name);
  }

}
?>