<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  25/04/11, 11:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class Sales
  @brief extract db value
	  for build a table of monthly sales volume (by speparé order status)
*/
class Sales
  Implements ModGraphStatsData{
  /**
    @var nombre de status de order present
  */
  public $nbr_val;
  /**
    @var tableau de couleur de status
  */
  public $les_color;
  /**
    @var tableau de couleur de status
  */
  public $base_date;
  /**
    @var calcul taille repere y
  */
  public $base_y;
  /**
    @var title
  */
  public $title;
  /**
    @var $value array value;
  */
  public $value;

  /**
  */
  public function __construct($year='',$month='',$day='',$year_end=''){

    $this->title= __('title graph sales');


    $year= (isset($_REQUEST['year'])?$_REQUEST['year'] :(date('Y')));
    $year_end= (isset($_REQUEST['year_end'])?$_REQUEST['year_end'] :date('Y'));


    $this->base_year=$year=(!empty($year)? $year : date("Y") );
    $year_end=(!empty($year_end)? $year_end : date("Y") );

    $this->base_date =$year.'-'.(!empty($month)? $month : '00') . '-'.(!empty($day)? $day : '00');

    $this->les_status();

    /**
      Tableau mensuel base
    */
    $amplitude=($year_end-$year);
    for($ir=0; $ir<=$amplitude; $ir++ ) {
      for($i=0; $i<12; $i++ ) {
	$s[(($ir*12)+$i)][0]=str_pad(($i+1), 2, "0", STR_PAD_LEFT).'-'.substr(($this->base_year+$ir),2);
	for($is=1; $is<=$this->nbr_val; $is++ )
	  $s[(($ir*12)+$i)][$is]=0;
      }
    }
    $this->value=$s;

    $this->tab_for_order();
  }


/**
  @remarks Next method Use Graphs class , this table is load after call graph and depend of load class graph
*/

  /**
    @brief construct thead table
  */
  public  function tep_get_th(){
    $les_color_name[]=__('mois');
    return array_merge($les_color_name,$this->les_color_name);
  }

  /**
    @brief construct array value for datatable display
  */
  public  function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    return $this->value;
  }




/**
  @remarks Private medthod
*/

  /**
    @brief Mise en tableau et prepa des valeur
  */
  private function tab_for_order(){
    if( ($query=$this->les_orders()) ==false) return null;
    $max=0;
    while ($orders = tep_db_fetch_array($query)){
      preg_match('/([0-9.]*)/i',strip_tags($orders['order_total']),$match);
      $value_sommme=$match[1];
      $mit=($orders['mois']-1);
      $anne=($this->base_year==$orders['annee'])? 0  : (($orders['annee']-$this->base_year)*12);
	if($max<=$value_sommme) $max=$value_sommme;
      if(isset($this->value[($anne+$mit)])){
	if($this->value[($anne+$mit)][0]=='txt') $this->value[($anne+$mit)][0] =date("m-y",strtotime($orders['date_purchased']));

	if($this->value[($anne+$mit)][$orders['orders_status']]==0) $this->value[($anne+$mit)][$orders['orders_status']] =$value_sommme;
	else  $this->value[($anne+$mit)][$orders['orders_status']] +=$value_sommme;
      }
    }

      $max=(int)$max;
      if((int)$max<=100)$this->base_y='500';
       elseif($max<=200)$this->base_y='200';
      elseif($max<=500)$this->base_y='500';
      elseif($max<=1000)$this->base_y='5000';
      elseif($max<=5000)$this->base_y='25000';
  }

  /**
    @brief Recup orders
  */
  private function les_orders(){
    global $languages_id;
    $DB=Database::getInstance();
    $orders_query_raw = $DB->query($sql=" select EXTRACT(YEAR FROM o.date_purchased) AS annee, EXTRACT(MONTH FROM o.date_purchased) AS mois, o.date_purchased, o.last_modified, o.currency, o.currency_value, o.orders_status, s.status_name as orders_status_name, ot.text as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . TABLE_STATUS . " s where o.orders_status = s.status_id and status_type='orders' and s.language_id = '" . (int)$languages_id . "' and ot.class = 'ot_total' and o.date_purchased > '".$this->base_date."' GROUP by year(o.date_purchased), month(o.date_purchased),o.orders_status ORDER BY year(o.date_purchased) ASC, month(o.date_purchased) ASC ");

    if ($orders_query_raw->__get('numRows') > 0) return $orders_query_raw;
    else return false;
  }


  /**
    @brief Recup status
  */
  private function les_status(){
    global $languages_id;
    $DB=Database::getInstance();
    $status_color = $DB->query("select status_id as orders_status_id, status_name as orders_status_name, status_color as orders_status_color FROM ".TABLE_STATUS." where status_type='orders' and  language_id = '" . (int)$languages_id . "' ");

    while ($sales_products = $status_color->fetchAssoc()) {

	$this->les_color[]=GraphUtility::html2rgb($sales_products['orders_status_color']);
	$this->les_color_name[]=utf8_decode($sales_products['orders_status_name']);
      }
      $this->nbr_val=count($this->les_color);


  }

}
?>