<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  20/03/11, 20:48
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

class newsletter
  extends NewslettersChargeur
    implements InterfaceNewsletters {

  public $thismodule;
  public $title;
  public $content;


  public function __construct($newsletters_id, $title, $content) {

    $this->newsletters_id = $newsletters_id;
    $this->title = $title;
    $this->content = $content;

  }

  public function get_content(){
    return $this->content;
  }

  public function confirm() {
    global $_GET, $language;

      $myarray = array(
	      'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
	      'message'=> NewslettersUtility::ApplModele($this->content, parent::$CurrentMod->modele_id),
	      );

      $array_email=tep_post_prepare_email(__CLASS__.'.tpl',$language,$myarray);

      $confirm_string = '<table border="0" cellspacing="0" cellpadding="2">' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main"><font color="#ff0000"><b>' .   __('text titre info') . '</b></font></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main">' . __('text count customers').' '.parent::$count_sended.'/'. parent::$count . '</td>' . "\n" .
                        '  </tr>' . "\n" .
                         '  <tr>' . "\n" .
                        '    <td class="main">' . __('text bulletin numb') . "&nbsp;" . '<font color="#0000ff">' . $this->newsletters_id . '</font></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main">' . __('text module') . "&nbsp;" . '<font color="#0000ff">' . __CLASS__ . '</font></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main">' . __('text titre mail') . "&nbsp;" . '<font color="#0000ff">' . $this->title . '</font></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main"><font color="#ff0000"><b>'  . __('text titre view') . '</b></font></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '    <td class="main"><tt>' . stripslashes( $array_email['html']). '</tt></td>' . "\n" .
                        '  </tr>' . "\n" .
                        '  <tr>' . "\n" .
                        '</table>';

    return $confirm_string;
  }

  /**
    @brief Envoi par lots, pour les client qui ne l'on pas deja recu
    @param $max int $max nbre d'email envoyé dans le lot
    @param $test false, or string list email  separate virgule
  */
  public function send($max=20, $test=false) {
    global  $language;
    $DB=Database::getInstance();
    $messageStack=messageStack::getInstance();

    $newsletter_id=$this->newsletters_id;

    if($test!=false) {
      $formail='';

      $t=explode(',',$test);
      foreach($t as $mail){
	$formail .="'".$mail."',";
      }

      $formail=substr($formail,0,-1);

      $mail_query = $DB->query($sql="select s.customers_id as id, s.customers_firstname  as firstname, s.customers_lastname as lastname , s.customers_email_address as email , ci.customers_info_date_account_created as created, ci.customers_info_date_of_last_logon,  customers_shopping_points as points from " . TABLE_CUSTOMERS . " s ," . TABLE_CUSTOMERS_INFO. " ci  where s.customers_id=customers_info_id  and s.customers_newsletter = '1'  AND s.customers_id=customers_info_id  and  s.customers_email_address IN (".$formail.") ");

    }
    /// mode normal , send
    else
    $mail_query = $DB->query($sql="select s.customers_id as id, s.customers_firstname as firstname, s.customers_lastname as lastname, s.customers_email_address as email , s.customers_email_address  , ci.customers_info_date_account_created as created, ci.customers_info_date_of_last_logon,  customers_shopping_points as points  from " . TABLE_CUSTOMERS . " s ," . TABLE_CUSTOMERS_INFO. " ci where s.customers_newsletter = '1'   AND s.customers_id=customers_info_id  and NOT EXISTS(SELECT * FROM ".TABLE_NEWSLETTERS_SENT." ns WHERE  ns.customers_id=s.customers_id AND ns.newsletters_id='" . $newsletter_id ."' and module_type='".__CLASS__."') LIMIT ".$max);

    if($mail_query->__get('numRows')) {
      while ($mail = $mail_query->fetchAssoc()) {
	/// replace balise
	$this->content=str_replace(NewslettersUtility::$replace, $mail ,$this->content);
	/// force link by redirect shop
	$this->content = preg_replace('~href[\s]*=[\s]*"~', 'href="'.HTTP_SERVER.DIR_WS_HTTP_CATALOG.'news.php?i='.$newsletter_id.'&c='.$mail['id'].'&u=$1', $this->content);


	$myarray = array(
		'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
		'email_use_logo'=>NewslettersUtility::UseModele(parent::$CurrentMod->modele_id),
		'email_use_link_online'=> sprintf(__('text view online <a href="%s" >click here</a>') , tep_catalog_href_link('newsletters.php','newsID='.parent::$CurrentMod->modele_id.'&cID='.$mail['id'].'&hash='.md5($mail['id'].$mail['email'].parent::$CurrentMod->modele_id).'&mode=view')),
		'tpl_link_trace'=>'<img src="'.HTTP_SERVER.DIR_WS_CATALOG.'n-'.parent::$CurrentMod->modele_id.'-'.$mail['id'].'.jpg" width="1" height="1">',
		'message'=> NewslettersUtility::ApplModele($this->content, parent::$CurrentMod->modele_id),
		);

	$message_final=tep_post_prepare_email(__CLASS__.'.tpl',$language,$myarray);
	if(tep_mail($mail['firstname'] . ' ' . $mail['lastname'], $mail['email'], $this->title, $message_final, STORE_OWNER, EMAIL_FROM) !=false){

	  parent::PushUserSent($mail['id'], $newsletter_id, (string) __CLASS__);
	}

      }

      parent::UpSent();
    }
    else {
      /// alert
	$messageStack->add_session(__('aucun email dans la table client/members'), 'error');
    }

  }
}
?>