<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  10/04/11, 18:01
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class adminAccount
  @brief manage account current user
*/


require_once(dirname(__FILE__).'/adminUsers.php');

class adminAccount
  extends adminUsers
  implements ExtModPage, InterfaceModule {

  /**
    Configuration
  */
  const FILENAME = FILENAME_ADMIN_ACCOUNT;

  /**
    @param obj
  */
  public static  $mInfo;
  /**
    @param string
  */
  public static $code;
  /**
    @param string
  */
  public static $action;
  /**
    @param array
  */
  public static $list=array();
  /**
    @param obj
  */
  public static $myAccount;


  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;

    include_once(DIR_WS_FUNCTIONS.'password_funcs.php');

    global $language;
    $oscss=oscss_cstr::getInstance();
    $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/configuration/adminUser.txt');
  }

  public function check_action($actions){
    global $messageStack,$language;
    $DB=Database::getInstance();
    self::$action=$actions;

    switch(self::$action){
      case 'check_password':
	$check_pass_query = $DB->query("select admin_password as confirm_password from " . TABLE_ADMIN . " where admin_id = '" . $_POST['id_info'] . "'");
	$check_pass = $check_pass_query->fetchAssoc();

	// Check that password is good
	if (!tep_validate_password($_POST['password_confirmation'], $check_pass['confirm_password'])) {
	  tep_redirect(tep_href_link(self::FILENAME, 'action=check_account&error=password'));
	} else {
	  //$confirm = 'confirm_account';
	  tep_session_register('confirm_account');
	  tep_redirect(tep_href_link(self::FILENAME, 'action=edit_member'));
	}

      break;
      case 'edit_member':
	parent::$url_redirect=self::FILENAME;
      break;
      case 'member_edit':
	parent::$url_redirect=self::FILENAME;
	parent::check_action(self::$action);
      break;
      case 'update_password':
	$pass0= tep_db_prepare_input($_POST['password_']);
	$pass1= tep_db_prepare_input($_POST['password_confirmation']);

	if(strcmp($pass0,$pass1)==0){
	  $DB->query("update  " . TABLE_ADMIN . " set admin_password='".tep_encrypt_password($pass0)."' where admin_id = '" . $_POST['id_info'] . "'");

	  $_query = $DB->query("select * from " . TABLE_ADMIN . " where admin_id = '" . $_POST['id_info'] . "'");
	  $res = $_query->fetchAssoc();

          $myarray = array(
                          'email_use_html'=>(bool)_cst_bool('EMAIL_USE_HTML'),
                          'links'=>HTTP_SERVER . DIR_WS_ADMIN,
                          'admin_firstname'=>$res['admin_firstname'],
                          'admin_email_address'=>$res['admin_email_address'],
			  'url_openid'=>$res['url_openid'],
                          'hiddenPassword'=>$pass0,
                          'message'=>''
                          );
          $message_final=tep_post_prepare_email('admin_members.tpl',$language,$myarray);
          tep_mail($_POST['admin_firstname'] . ' ' . $res['admin_lastname'], $res['admin_email_address'],__('email text subject'), $message_final);

	  $messageStack->add_session(__('new password update'), 'success');
	  tep_redirect(tep_href_link(self::FILENAME));
	}
	else {
	  $messageStack->add_session(__('new password not equal'), 'error');
	  tep_redirect(tep_href_link(self::FILENAME, 'action=update_pass'));
	}
      break;
      case 'init_menu':
	$menu=menu::resetInstance();
	$menu->cstr_return(array('for_user'=>'1'));
	tep_redirect(tep_href_link(self::FILENAME));
      break;
      case 'cookie':
	if(isset($_COOKIE['oscss_admin']) &&  $_COOKIE['oscss_admin']=== $_SESSION['login_id'] )
	  setcookie('oscss_admin', '' ,-9999, DIR_WS_CATALOG);
	else
	  setcookie('oscss_admin', $_SESSION['login_id'] ,0, DIR_WS_CATALOG);

	tep_redirect(tep_href_link(self::FILENAME));
      break;

      default:
	self::$myAccount=parent::load_db_values($_SESSION['login_id']);
	self::$myAccount->cookieCorress =  ((isset($_COOKIE['oscss_admin']) &&  $_COOKIE['oscss_admin']=== $_SESSION['login_id'] )? true : false);
    }

  }

  public function get_header(){
    parent::get_header(self::$action);
  }


  public static function load_db_values($ID){
    $DB=Database::getInstance();
    $db_admin_query_raw = $DB->query($sql="select * from " . TABLE_ADMIN . " a LEFT JOIN " . TABLE_ADMIN_GROUPS . " g ON a.admin_groups_id=g.admin_groups_id where a.admin_id='".$ID."' ");
    return new objectInfo($db_admin_query_raw->fetchAssoc());
  }


  public function display_view(){
    switch(self::$action){
      default:
	return tep_get_include_contents(__CLASS__.'.page');
    }
  }


  public static function get_right_bar(){
    global $language;

    switch(self::$action){
      case 'check_account':
	$heading[] = array('text' => __('text info heading default') );
	$contents = array('form' => tep_draw_form('edit', self::FILENAME, 'action=check_password', 'post'));
	$contents[] = array('text' => '<label for="password_confirmation">' . __('text info intro confirm password') . '</label>' . tep_draw_password_field('password_confirmation') . tep_draw_hidden_field('id_info', '', self::$myAccount->admin_id) );
	$contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_delete.gif', __('image valider')) . ' <a  class="button"  href="' . tep_href_link(self::FILENAME) . '">' . IMAGE_CANCEL . '</a>');
      break;
      case 'update_pass':
	$heading[] = array('text' => __('text info heading default') );
	$contents = array('form' => tep_draw_form('edit', self::FILENAME, 'action=update_password', 'post'));
	$contents[] = array('text' => '<label for="password_confirmation">' . __('text info intro new password') . '</label>' .
				      tep_draw_password_field('password_') .
				      tep_draw_password_field('password_confirmation') .
				      tep_draw_hidden_field('id_info', '', self::$myAccount->admin_id)
			    );
	$contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_delete.gif', __('image valider')) . ' <a  class="button"  href="' . tep_href_link(self::FILENAME) . '">' . IMAGE_CANCEL . '</a>');
      break;
      default:
	parent::$action=self::$action;
	parent::$mInfo=parent::load_db_values($_SESSION['login_id']);

	$res='<div id="button_nav">';

	if(self::$action !='edit_member')
	  $res .= sprintf(CsrtAction::getLink('button_nav', IMAGE_EDIT ), '',  tep_href_link(self::FILENAME, 'action=check_account') ,'' );
	elseif(self::$action =='edit_member')
	  $res .=  sprintf(CsrtAction::getLink('button_nav', __('update password') ), '',  tep_href_link(self::FILENAME, 'action=update_pass') ,'' );

	$res .= '</div>';

	$res .= parent::get_right_bar();

	return $res;
    }

    if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
      $box = new box;
      return $box->infoBox($heading, $contents);
    }
  }



/** Interface module */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;  }
  function keys() { return false; }


}

?>