<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/02/11, 14:49
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class adminNotif
*/

class adminNotif
  implements ExtModPage,  InterfaceModule {

  const FILENAME =FILENAME_ADMINNOTIF;

  public static $code;

  public static $action;
  /**
    @var $listConfig array list for config current user
  */
  public static $listConfig=array();
  /**
    @var $list array list for alert and notification for current user
  */
  public static $list=array();
  /**
    @var $nInfo object detail one notification
  */
  public static $nInfo;
  /**
    @var $XmlBase object xml simple parser result
  */
  protected static $XmlBase;

  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;

    self::loadXml();
 }

  public function check_action($actions){
    global $messageStack, $oscss;

    self::$action=$actions;
    $DB=Database::getInstance();

    switch (self::$action) {
      case 'multi':
	if(isset($_POST['multi']) && is_array($_POST['multi']) )
	foreach($_POST['multi'] as $k=>$v) {

	  $nID=tep_db_prepare_input($k);

	  $DB->query($sql="DELETE FROM ".TABLE_ADMIN_NOTIFICATION." WHERE  notif_id='".(int)$nID."' AND ( ( notif_type='0' and user_id='".$_SESSION['login_id']."') OR (notif_type='1' and user_id='".$_SESSION['login_groups_id']."') ) LIMIT 1");

	}

	tep_redirect(tep_href_link(self::FILENAME));
      break;
      case 'config':
      break;
      case 'configadd':
	$chknotif_key=tep_db_prepare_input($_POST['chknotif_key']);
	$chknotif_method=tep_db_prepare_input($_POST['chknotif_method']);

	if(!$DB->query($sql="INSERT INTO ".TABLE_NOTIFICATION." (chknotif_id , chknotif_key , chknotif_uniq , chknotif_user, chknotif_status, chknotif_method ) VALUE  ( '', '".$chknotif_key."', 0, '".$_SESSION['login_id']."', 1, '".$chknotif_method."')  "))
	  $messageStack->add_session(__('error in insert notification'), 'error');
	else
	  $messageStack->add_session(__('success notification insert'), 'success');

	tep_redirect(tep_href_link(self::FILENAME, 'action=config'));
      break;
      case 'configupdate':
	$cID=tep_db_prepare_input($_GET['cID']);
	$chknotif_method=tep_db_prepare_input($_POST['chknotif_method']);

	if( !$DB->query($sql="UPDATE ".TABLE_NOTIFICATION." SET  chknotif_method ='".$chknotif_method."' WHERE  chknotif_id='".$cID."' ") )
	  $messageStack->add_session(__('error in update notification'), 'error');
	else
	  $messageStack->add_session(__('success notification update'), 'success');

	tep_redirect(tep_href_link(self::FILENAME, 'action=config'));
      break;
      case 'configdelete':
	$cID=tep_db_prepare_input($_GET['cID']);
	$DB->query($sql="DELETE FROM ".TABLE_NOTIFICATION." WHERE  chknotif_id='".(int)$cID."' AND ( ( chknotif_uniq='0' and chknotif_user='".$_SESSION['login_id']."') OR (chknotif_uniq='1' and chknotif_user='".$_SESSION['login_groups_id']."') ) ");

	$messageStack->add_session(__('success notification delete'), 'success');

	tep_redirect(tep_href_link(self::FILENAME, 'action=config'));
      break;

      case 'delete':
	$nID=tep_db_prepare_input($_GET['nID']);

	$DB->query($sql="DELETE FROM ".TABLE_ADMIN_NOTIFICATION." WHERE  notif_id='".(int)$nID."' AND ( ( notif_type='0' and user_id='".$_SESSION['login_id']."') OR (notif_type='1' and user_id='".$_SESSION['login_groups_id']."') ) LIMIT 1");

	$messageStack->add_session(__('success notif detail delete'), 'success');

	tep_redirect(tep_href_link(self::FILENAME));
      break;
      default:

    }

    return self::$action;
  }

  public function get_header(){ return false; }

  public static function load_db_values($ID){
    $DB=Database::getInstance();
    $res=$DB->query($sql="SELECT notif_id,notif_type,user_id,notif_key,notif_data,notif_text, notif_date FROM ".TABLE_ADMIN_NOTIFICATION." WHERE  notif_id='".(int)$ID."' AND ( ( notif_type='0' and user_id='".$_SESSION['login_id']."') OR (notif_type='1' and user_id='".$_SESSION['login_groups_id']."') )");
    self::$nInfo=new objectInfo($res->fetchAssoc());
  }

  public static function load_db_config($ID){
    $DB=Database::getInstance();
    $res=$DB->query($sql="SELECT * FROM ".TABLE_NOTIFICATION." WHERE  chknotif_id='".(int)$ID."' AND ( ( chknotif_uniq='0' and chknotif_user='".$_SESSION['login_id']."') OR (chknotif_uniq='1' and chknotif_user='".$_SESSION['login_groups_id']."') )");
    self::$nInfo=new objectInfo($res->fetchAssoc());
  }

  /**
  */
  public function display_view(){
    switch (self::$action) {
      case 'confignew':
      case 'configedit':
      case 'configdelete':
      case 'config':
	self::loadConfigUser();
	return tep_get_include_contents(self::$code.'.config');
      break;

      case 'view':
	return tep_get_include_contents(self::$code.'.view');
      break;
      default:
	self::loadNotifUser();
	return tep_get_include_contents(self::$code.'.listing');
    }
  }

  public static function get_right_bar(){
    $heading=$contents=array();

    switch(self::$action){
      case 'confignew':
	$heading[] = array('text' => __('heading config edit') );

	$contents = array('form' => tep_draw_form('newnotif', self::FILENAME, 'action=configadd', 'post'));
	$contents[] = array('text' => '<label>' . __('text info key notif') . '</label>' .  tep_draw_pull_down_menu('chknotif_key', self::XmlAction()));
	$contents[] = array('text' => '<label>' . __('text info key method') . '</label>' . tep_draw_pull_down_menu('chknotif_method', self::XmlMethod()));

	$contents[] = array('class'=>'button_nav','text' =>
				  sprintf(CsrtAction::getSubmit('button_nav', IMAGE_UPDATE), 'ActionYes',  IMAGE_UPDATE ,'' ).
				  tep_js_back(tep_href_link(self::FILENAME, 'action=config' ), IMAGE_BACK)
			    );
      break;
      case 'configedit':
	self::load_db_config((int)$_GET['cID']);

	$heading[] = array('text' => __('heading config edit') );

	$contents = array('form' => tep_draw_form('upnotif', self::FILENAME, 'action=configupdate&amp;cID=' . self::$nInfo->chknotif_id , 'post'));
	$contents[] = array('text' => '<label>' . __('text info key notif') . '</label>' . self::$nInfo->chknotif_key);
	$contents[] = array('text' => '<label>' . __('text info key method') . '</label>' . tep_draw_pull_down_menu('chknotif_method', self::XmlMethod(), self::$nInfo->chknotif_method));

	$contents[] = array('class'=>'button_nav','text' =>
				  sprintf(CsrtAction::getSubmit('button_nav', IMAGE_UPDATE), 'ActionYes',  IMAGE_UPDATE ,'' ).
				  tep_js_back(tep_href_link(self::FILENAME, 'action=config&amp;nID=' . self::$nInfo->chknotif_id ), IMAGE_BACK)
			    );
      break;
      case 'view':
	self::load_db_values((int)$_GET['nID']);

	$heading[] = array('text' => __('heading notification view') );
	$contents[] = array('text' => '<label>' . __('text info key notif') . '</label>' . self::$nInfo->notif_key);
	$contents[] = array('text' => '<label>' . __('text info date notif') . '</label>' . tep_datetime_short(self::$nInfo->notif_date) );
	$contents=array_merge($contents, self::detailSupll(self::$nInfo->notif_data));
	$contents[] = array('text' => '<label>' . __('text info content notif') . '</label>' . self::$nInfo->notif_text);

	$contents[] = array('class'=>'button_nav','text' =>
				  sprintf(CsrtAction::getLink('button_nav', IMAGE_DELETE), 'ActionYes',  tep_href_link(adminNotif::FILENAME,  'nID=' . self::$nInfo->notif_id  . '&amp;action=delete') ,'' ).
				  tep_js_back(tep_href_link(self::FILENAME, 'nID=' . self::$nInfo->notif_id ), IMAGE_BACK)
			    );
      break;
      default:
    }

      if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
	$box = new box;
	return $box->infoBox($heading, $contents);
      }
  }


/** Specific module */

  /**
    @fn detailSupll($data)
    @brief display content supp in data
    @param $data string GET
    @return array $contents
  */
  private static function detailSupll($data){
    if(empty($data)) return array();
    $array=tep_extrac_querystring($data);
    $contents=array();

    foreach($array as $k=>$item)
      if(tep_not_null($item)) {
	switch($k) {
	  case 'customers_id';
	    $contents[] = array('text' => tep_customers_row_action($item) );
	  break;
	  default:
	    $contents[] = array('text' => '<label>' . $k . ' : </label>' . $item );
	}
      }

    return $contents;
  }

  /**
    @fn loadNotifUser()
    @brief call user notification current user
  */
  private static function loadNotifUser(){
    if(is_array(self::$list) && count(self::$list)>0 )  return self::$list;
    $DB=Database::getInstance();
    $res=$DB->query($sql="SELECT notif_id,notif_type,user_id,notif_key,notif_data,notif_text,notif_date FROM ".TABLE_ADMIN_NOTIFICATION." WHERE  ( notif_type='0' and user_id='".$_SESSION['login_id']."') OR (notif_type='1' and user_id='".$_SESSION['login_groups_id']."') ORDER BY notif_date ASC");

    $list=$res->fetchAllAssoc();

    foreach($list as $notif){
      if(isset($notif['notif_data'])) self::$list[]=array_merge((array)$notif, (array)tep_extrac_querystring($notif['notif_data']));
      else self::$list[]=$notif;
    }
    return self::$list;
  }

  /**
    @fn loadConfigUser()
    @brief call user configuration notif current user
  */
  private static function loadConfigUser(){
    if(is_array(self::$listConfig)  && count(self::$listConfig)>0 )  return self::$listConfig;
    $DB=Database::getInstance();
    $res=$DB->query($sql="SELECT * FROM ".TABLE_NOTIFICATION." WHERE  ( chknotif_uniq='0' and chknotif_user='".$_SESSION['login_id']."') OR (chknotif_uniq='1' and chknotif_user='".$_SESSION['login_groups_id']."') ");

    self::$listConfig=$res->fetchAllAssoc();
    return self::$listConfig;
  }


  /**
    @fn loadXml()
    @brief load xml base method and action defaut
  */
  private static function loadXml(){
    $FeedUrl = DIR_WS_INCLUDES.'data/notification_src.xml';

    if(!$SimpleParser = @simplexml_load_file($FeedUrl)) echo __('Flux introuvable');

    self::$XmlBase = $SimpleParser;
//     print_r(self::XmlMethod());
  }

  /**
    @fn  XmlMethod()
    @brief call method possible for alert
    @return array for tep_pulldown
  */
  private static function XmlMethod(){
    if(!is_object(self::$XmlBase)) return array();
    $array=array();

    foreach(self::$XmlBase->method->mode as $item)
      $array[]=array('id'=>(string)$item,'text'=>(string)$item);

    return $array;
  }

  /**
    @fn  XmlAction()
    @brief call action possible for alert
    @return array for tep_pulldown
  */
  private static function XmlAction(){
    if(!is_object(self::$XmlBase)) return array();
    $array=array();

    foreach(self::$XmlBase->metier->action as $item)
      $array[]=array('id'=>(string)$item,'text'=>(string)$item);

    return $array;
  }

  /**
    @fn CountNotif()
    @brief call count notification for current user
  */
  public static function CountNotif(){
    self::loadNotifUser();
    return count(self::$list);
  }

/** Interface module */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;  }
  function keys() { return false; }
}

?>