<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  04/04/11, 08:13
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief manage category and module aca for cat
*/



/**
  @class categories
  @brief master class edit and manage cat
*/
class categories
    implements ExtModPage, InterfacedTJsonS{

  const FILENAME = FILENAME_CATEGORIES;
  /**
    @p string $code
  */
  public static $code;
  /**
    @p string $action
  */
  public static $action;
  /**
    @p array $modules
  */
  public static $list=array();
  /**
    @p array $modules
  */
  public static $modules;
  /**
    @p array $languages
  */
  public static $languages;
  /**
    @p objet $cInfo
  */
  public static $cInfo;
  /**
    @p array $cPath
  */
  public static $cPath;
  /**
    @p array $current_category_id
  */
  public static $current_category_id;
  /**
    @p array $DiversInfo transport var
  */
  public static $DiversInfo;
  /**
    @p array $actions
  */
  public static $actions;
  /**
    @p obj $box
  */
  public static $box;



  public function  __construct(){
    self::GetConf();
  }

  /**
    @brief Load , adjust and define var environement exe for module
	Is use in module and class abstract for init value config this module
  */
  public static function GetConf(){
    global $languages_id;

    self::$code=__CLASS__;

    self::$action=(isset($_REQUEST['action'])? $_REQUEST['action'] : 'listing' );


    /**
      @remarks not load if not first init
    */
    if(defined('JSONSTATMENT')) return;

    //! active datatable in ajax, precise les GET necessaire
    define('JSONSTATMENT', 'mod=page&type='.self::$code.(isset($_GET['cPath'])?'&cPath='.$_GET['cPath']:''));
    //! detail item in ajax
    define('AJAXSTATMENTDETAIL', 'mod=page&type='.self::$code);

    self::$modules=new categoriesACA();
    self::$modules->set_image_handler();

    self::$cPath=(isset($_GET['cPath'])? (int)$_GET['cPath'] : 0);

  // check if the catalog image directory exists
    global $messageStack;
    if (is_dir(DIR_FS_CATALOG_IMAGES)) {
      if (!is_writeable(DIR_FS_CATALOG_IMAGES)) $messageStack->add(__('error catalog image directory not writeable'), 'error');
    }
    else  $messageStack->add(__('error catalog image directory does not exist'), 'error');

    self::$languages = tep_get_languages();
  }

/** public static ExtModPage */

  public function check_action($actionss){
    global $languages_id, $oscss,$messageStack;

    self::$action=$actionss;
    $DB=Database::getInstance();

    self::$actions['action'] = self::$action;
    self::$actions['display_file']='';
    self::$actions['action_class']=(isset($_GET['action_class']))? $_GET['action_class'] : '';
    self::$actions['action_method']=(isset($_GET['action_method']))? $_GET['action_method'] : '';

  // Ask categories modules if want to change the action
    self::$actions = self::$modules->check_action(self::$actions);
    self::$action = self::$actions['action'];


    self::$DiversInfo['current_category_id']=((isset($_GET['cPath'])&& !empty($_GET['cPath']))  ? tep_db_prepare_input($_GET['cPath']) :  0);

    if ( empty(self::$actions['action_class']) ) {

    if ( preg_match("/(insert|update|setflag)/i", self::$action) ) tep_reset_cache_data_seo_urls('reset');
      switch (self::$action) {
	case 'setflag':
	  if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
	    if (isset($_GET['cID'])) {
		if ($_GET['flag'] == '1')   tep_db_query("update " . TABLE_CATEGORIES . " set categories_status = '1', last_modified = now() where categories_id = '" . (int)$_GET['cID'] . "'");
		elseif ($_GET['flag'] == '0')   tep_db_query("update " . TABLE_CATEGORIES . " set categories_status = '0', last_modified = now() where categories_id = '" . (int)$_GET['cID'] . "'");
	    }

	    osCSS_Cache::clear('categoriesBox');
	    osCSS_Cache::clear('category_tree');
	    osCSS_Cache::clear('also_purchased');

	  }

	  tep_redirect(tep_href_link(FILENAME_CATEGORIES, 'cPath=' . $_GET['cPath'] ));
	break;
	case 'viewflag':
	  if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
	    if (isset($_GET['cID'])) {
		if ($_GET['flag'] == '1')   tep_db_query("update " . TABLE_CATEGORIES . " set categories_hidden = '1', last_modified = now() where categories_id = '" . (int)$_GET['cID'] . "'");
		elseif ($_GET['flag'] == '0')   tep_db_query("update " . TABLE_CATEGORIES . " set categories_hidden = '0', last_modified = now() where categories_id = '" . (int)$_GET['cID'] . "'");
	    }

	    osCSS_Cache::clear('categoriesBox');
	    osCSS_Cache::clear('category_tree');
	    osCSS_Cache::clear('also_purchased');

	  }

	  tep_redirect(tep_href_link(FILENAME_CATEGORIES, 'cPath=' . $_GET['cPath'] ));
	break;
    /**
	  CATEGORIES
    */
	case 'insert':
	case 'update':

	  if (isset($_POST['categories_id'])) $categories_id = tep_db_prepare_input((int)$_POST['categories_id']);

	  if (isset($_POST['categories_image']) && tep_not_null($_POST['categories_image']) && ($_POST['categories_image'] != 'none')){
	    if( strpos($_POST['categories_image'],DIR_WS_CATALOG_IMAGES) >=0 )
	      $_POST['categories_image'] = tep_db_prepare_input(substr($_POST['categories_image'], strlen( DIR_WS_CATALOG_IMAGES)  ) );
	    else
	      $_POST['categories_image'] = tep_db_prepare_input($_POST['categories_image']);
	  }

	  $sort_order = (isset($_POST['sort_order'])) ? tep_db_prepare_input((int)$_POST['sort_order']) : 0 ;
	  self::$current_category_id = (isset($_POST['cPath'])) ? tep_db_prepare_input($_POST['cPath']) : 0 ;
	  $categories_status = (isset($_POST['categories_status'])) ? tep_db_prepare_input((int)$_POST['categories_status']) : 0 ;
	  $categories_hidden = (isset($_POST['categories_hidden'])) ? tep_db_prepare_input((int)$_POST['categories_hidden']) : 0 ;
	  $categories_image = (!isset($_POST['categories_image']) || (!isset($_POST['categories_image_no']) && $_POST['categories_image']=='on') ) ?  '' : tep_db_prepare_input($_POST['categories_image']) ;

	  $sql_data_array = array('sort_order' => $sort_order,
				  'parent_id' => self::$current_category_id,
				  'categories_status' => $categories_status,
				  'categories_hidden' => $categories_hidden,
				  'categories_image'=>$categories_image
				  );

	  if (self::$action == 'insert') {
	    $insert_sql_data = array('date_added' => 'now()');

	    $sql_data_array = array_merge($sql_data_array, $insert_sql_data);

	    self::$modules->load_post_values ($_POST);
	    self::$modules->get_insert_table_categories($sql_data_array,'');

	    $resobj=tep_db_perform(TABLE_CATEGORIES, $sql_data_array);

	    $categories_id = tep_db_insert_id($resobj);

	  } elseif (self::$action == 'update') {

	    $update_sql_data = array('last_modified' => 'now()');
	    $sql_data_array = array_merge($sql_data_array, $update_sql_data);

	    self::$modules->load_post_values ($_POST);
	    $sql_data_array=array_merge($sql_data_array, (array) self::$modules->get_update_table_categories($sql_data_array) );

	    tep_db_perform(TABLE_CATEGORIES, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "'");
	  }

	    $categories_name_array = $_POST['categories_name'];
	    $categories_desc_array = $_POST['categories_description'];


	  for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {

	    $language_id = self::$languages[$i]['id'];
	    $sql_data_array = array('categories_name' => tep_db_prepare_input($categories_name_array[$language_id]),
				    'categories_description'=>tep_db_prepare_input($categories_desc_array[$language_id]));

	    if (self::$action == 'insert') {
	      $insert_sql_data = array('categories_id' => $categories_id,
					'language_id' => self::$languages[$i]['id']);
	      $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
	      $sql_data_array = array_merge($sql_data_array,self::$modules->get_insert_table_categories_description (array(),self::$languages[$i]['id']));

	      tep_db_perform(TABLE_CATEGORIES_DESCRIPTION, $sql_data_array);

	    } elseif (self::$action == 'update') {
		$tabl=self::$modules->get_update_table_categories_description (self::$languages[$i]['id']);
		$sql_data_array = array_merge($sql_data_array, $tabl);

	      tep_db_perform(TABLE_CATEGORIES_DESCRIPTION, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "' and language_id = '" . (int)$language_id . "'");
	    }
	  }

// 	  if ( !empty($_FILES['categories_image']['tmp_name']) ) {
// 	    $categories_image = new upload('categories_image', DIR_FS_CATALOG_IMAGES);
// 	    tep_db_query("update " . TABLE_CATEGORIES . " set categories_image = '" . tep_db_input($categories_image->filename) . "' where categories_id = '" . (int)$categories_id . "'");
// 	  }



	  self::$modules->after_update ($categories_id);


	  osCSS_Cache::clear('categoriesBox');
	  osCSS_Cache::clear('category_tree');
	  osCSS_Cache::clear('also_purchased');

	  if(isset($_POST['up_and_close']) ) tep_redirect(tep_href_link(FILENAME_CATEGORIES, 'cPath=' . self::$cPath . '&cID=' . $categories_id));
	  else tep_redirect(tep_href_link(FILENAME_CATEGORIES, 'cPath=' . self::$cPath  . '&cID=' . $categories_id.'&action=edit'));

	break;
	case 'delete_confirm':
	  if (isset($_POST['categories_id'])) {
	    $categories_id = tep_db_prepare_input($_POST['categories_id']);

	    $categories = tep_get_category_tree($categories_id, '', '0', '', true);
	    $products = array();
	    $products_delete = array();

	    for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
	      /* Calcul produist et enfant herite */
	      $product_ids_query = tep_db_query("select products_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
	      while ($product_ids = tep_db_fetch_array($product_ids_query))  $products[$product_ids['products_id']]['categories'][] = $categories[$i]['id'];

	      /* Calcul cms et enfant herite */
	      $content_ids_query = tep_db_query("select content_id from " . TABLE_CONTENT_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
	      while ($content_ids = tep_db_fetch_array($content_ids_query))  $contents[$content_ids['content_id']]['categories'][] = $categories[$i]['id'];
	    }

	    reset($products);
	    while (list($key, $value) = each($products)) {
	      $category_ids = '';
	      for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++)  $category_ids .= "'" . (int)$value['categories'][$i] . "', ";
	      $category_ids = substr($category_ids, 0, -2);

	      /* Ne prend que les produits dont la seul cat est celle a supp */
	      $check_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
	      $check = tep_db_fetch_array($check_query);
	      if ($check['total'] < '1')  $products_delete[$key] = $key;
	    }

	    reset($contents);
	    while (list($key, $value) = each($contents)) {
	      $category_ids = '';
	      for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++)  $category_ids .= "'" . (int)$value['categories'][$i] . "', ";
	      $category_ids = substr($category_ids, 0, -2);

	      /* Ne prend que les cms dont la seul cat est celle a supp */
	      $check_query = tep_db_query($sql="select count(*) as total from " . TABLE_CONTENT_TO_CATEGORIES . " where content_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
	      $check = tep_db_fetch_array($check_query);
	      if ($check['total'] < '1')  $contents_delete[$key] = $key;
	    }


      // removing categories can be a lengthy process
      tep_set_time_limit(0);

	    if(isset($_POST['delete_childs_in_cat']) && $_POST['delete_childs_in_cat']=='on') {
	      for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
		tep_remove_category($categories[$i]['id']);
		// ACA START DELETE CATEGORY
		self::$modules->delete_category ($categories[$i]['id']);
	      }
	    }

	    /* Suppression des produist de la cat */
	    if(isset($_POST['delete_products_in_cat']) && $_POST['delete_products_in_cat']=='on') {
	      reset($products_delete);
	      while (list($key) = each($products_delete)) {
		tep_remove_product($key);
	      }
	    }

	    /* Suppression des cms de la cat */
	    if(isset($_POST['delete_cms_in_cat']) && $_POST['delete_cms_in_cat']=='on') {
	      reset($contents_delete);
	      while (list($key) = each($contents_delete)) {
		tep_remove_cms($key);
	      }
	    }
	  }

	  tep_remove_category($categories_id);

	  osCSS_Cache::clear('categoriesBox');
	  osCSS_Cache::clear('category_tree');
	  osCSS_Cache::clear('also_purchased');



	  tep_redirect(tep_href_link(FILENAME_CATEGORIES, 'cPath=' . self::$cPath ));
	  break;
	case 'new':
	      $cInfo_array=array(
		      'parent_id'=>0,
		      'sort_order'=>0,
		      'categories_id'=>null,
		      'categories_image'=>DIR_WS_CATALOG_IMAGES.IMAGE_NONEXISTENT,
		      'categories_status'=>null,
		      'categories_hidden'=>null,
			    );
	      for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {
		  $cInfo_array['categories_name'][self::$languages[$i]['id']]='';
		  $cInfo_array['categories_description'][self::$languages[$i]['id']]='';
	      }
	      self::$cInfo = new objectInfo($cInfo_array);

	      $oscss->_add_ext(BO_WISIWYG_SELECTED,'editeur/');
	      for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {
		echo $oscss->_call(BO_WISIWYG_SELECTED,'_top','categories_description[' . self::$languages[$i]['id'] . ']','600','400');
	      }

	  break;
	case 'edit':

	      $check_query = tep_db_query("select *  from " . TABLE_CATEGORIES . " c  where c.categories_id = '" . (int)$_GET['cID'] . "'  ");
	      $categories = tep_db_fetch_array($check_query);
	      $category_products = array( 'products_count' => tep_products_in_category_count($_GET['cID'] ),
					    'cms_count' => tep_cms_in_category_count($_GET['cID'] )
					  );
	      $cInfo_array = array_merge($categories,  $category_products);

	      for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {
		  $check_q = tep_db_query("select *  from  " . TABLE_CATEGORIES_DESCRIPTION . " cd where categories_id = '" . (int)$_GET['cID'] . "' and language_id='".(int)self::$languages[$i]['id']."' ");
		  $categ = tep_db_fetch_array($check_q);
		  $cInfo_array['categories_name'][self::$languages[$i]['id']]=$categ['categories_name'];
		  $cInfo_array['categories_description'][self::$languages[$i]['id']]=$categ['categories_description'];
	      }

	      self::$cInfo = new objectInfo($cInfo_array);

	      $oscss->_add_ext(BO_WISIWYG_SELECTED,'editeur/');
	      for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {
		echo $oscss->_call(BO_WISIWYG_SELECTED,'_top','categories_description[' . self::$languages[$i]['id'] . ']','600','400');
	      }
	    // ACA START LOAD VALUES FROM DB
	    self::$modules->load_db_values ($_GET['cID']);

	  break;

	}


    } else {
      /**
	A module has asked to privately take care of this action, check if class and method exist and run it.
      */
	if (!empty(self::$actions['action_method']) && method_exists(self::$modules->modules[self::$actions['action_class']],self::$actions['action_method'] )){
	  $metho=self::$actions['action_method'];
	  self::$box = new box;
	  self::$box=self::$modules->modules[self::$actions['action_class']]->$metho(self::$box,(int)$_GET['cID']);
	}
    }


  }

  public function get_header(){
    echo tep_get_filebroswerserveur();
    if (self::$action == 'new_category') self::$modules->get_header_js('new_category');
    else self::$modules->get_header_js(self::$action);
  }


  public static function load_db_values($ID){
    global $languages_id;
    $DB=Database::getInstance();
    $check_q = $DB->query("select *  from  " . TABLE_CATEGORIES_DESCRIPTION . " cd where categories_id = '" .(int) $ID . "' and language_id='".(int)$languages_id."' ");
    $category_child = array( 'products_count' => tep_products_in_category_count($ID),
			     'cms_count' => tep_cms_in_category_count($ID),
			     'childs_count'=>tep_childs_in_category_count($ID),
			     'cPath'=>tep_get_generated_category_path_ids($ID)
			  );
    return new objectInfo(array_merge($check_q->fetchAssoc(),$category_child));
  }

  /**
  */
  public function display_view() {
    $action=self::$action;

    switch(self::$action){
      case 'new':
	$action='edit';
      break;
      case 'delete':
	self::$cInfo=self::load_db_values((int)$_GET['cID']);
      break;
      case 'copy_to':
	self::$cInfo=self::load_db_values((int)$_GET['cID']);
      break;
      default:

      if(!empty(self::$actions['action_method']) )
	$action='aca_actions';
      else {
	self::tep_get_list();
	$action='listing';
      }
    }
    /// use master gabarit
    return MGabCont::CallGab($action,__FUNCTION__,__CLASS__);
  }

/** public static InterfacedTJsonS */
  /**
    @fn get_item_action($products)
    @brief fonction qui construit l'affichage de la colonne action
      La mise en forme est contenu dans les ressource xml du template en cours
    @param $products array
    @return string
  */
  private static function get_item_action($categories){
    return  sprintf(
		  CsrtAction::getFormat('row_action'),
		  sprintf(CsrtAction::getLink('row_action_right',  __('image view public') , 'publiclink'), '',  tep_catalog_href_link('index.php', 'cPath=' .  $categories['cPath']) ,' target="blank" ' ).
		  sprintf(CsrtAction::getLink('row_action_right', IMAGE_EDIT, 'edit'), '',  tep_href_link(self::FILENAME, 'cPath=' . self::$cPath . '&amp;cID=' . $categories['categories_id'] . '&amp;action=edit' ),'' ).
		  sprintf(CsrtAction::getLink('row_action_right', IMAGE_DELETE, 'delete'), 'fancy',  tep_href_link(self::FILENAME, 'cPath=' . self::$cPath . '&amp;cID=' . $categories['categories_id'] . '&amp;action=delete') ,'' ),
		  sprintf(CsrtAction::getLink('row_action_right', ICON_FOLDER, 'dir'), '',  tep_href_link(self::FILENAME, 'cPath=' . $categories['cPath']  ),'' )
		  );
  }

  private static function get_status_categories($categories){
    if ($categories['categories_status'] == '1')
      return tep_image(DIR_WS_ICONS . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN) . ' <a href="' . tep_href_link(categories::FILENAME, 'action=setflag&amp;flag=0&amp;cID=' . $categories['categories_id'] . '&amp;cPath=' . self::$cPath) . '">' . tep_image(DIR_WS_ICONS . 'icon_status_red_light.gif', IMAGE_ICON_STATUS_RED_LIGHT) . '</a>';
    else
      return '<a href="' . tep_href_link(categories::FILENAME, 'action=setflag&amp;flag=1&amp;cID=' . $categories['categories_id'] . '&amp;cPath=' . self::$cPath) . '">' . tep_image(DIR_WS_ICONS . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN_LIGHT) . '</a> ' . tep_image(DIR_WS_ICONS . 'icon_status_red.gif', IMAGE_ICON_STATUS_RED);
  }

  private static function get_status_menu($categories){
  if ($categories['categories_hidden'] == '1')
    return tep_image(DIR_WS_ICONS . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN) . ' <a href="' . tep_href_link(self::FILENAME, 'action=viewflag&amp;flag=0&amp;cID=' . $categories['categories_id'] . '&amp;cPath=' . self::$cPath) . '" title="'.__('view in menu').'">' . tep_image(DIR_WS_ICONS . 'icon_status_red_light.gif', IMAGE_ICON_STATUS_RED_LIGHT) . '</a>';
   else
    return '<a href="' . tep_href_link(self::FILENAME, 'action=viewflag&amp;flag=1&amp;cID=' . $categories['categories_id'] . '&amp;cPath=' . self::$cPath) . '" title="'.__('view in menu').'">' . tep_image(DIR_WS_ICONS . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN_LIGHT) . '</a> ' . tep_image(DIR_WS_ICONS . 'icon_status_red.gif', IMAGE_ICON_STATUS_RED);
  }

  public static function tep_get_modele(){
      return array( 0 =>false,
		    'c.categories_id'=>true,
		    'categories_image'=>true,
		    'categories_name'=>true,
		    'categories_status'=>true,
		    'categories_hidden'=>true,
		    'action'=>false
	      );
  }

  private static function emptyResult(){
      return array(  'null'=>'',
		  'c.categories_id'=>'',
		  'categories_name'=>'',
		  'categories_image'=>'',
// 		  'parent_id',
// 		  'sort_order',
		  'categories_status'=>'',
		  'categories_hidden'=>'',
// 		  'p.categories_status',
		  'action'=>''
	      );
  }

  public static function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    global $languages_id,$query_numrows;

    self::$cPath=$cID=(isset($_GET['cPath'])? (int)$_GET['cPath'] : 0);

    $DB=Database::getInstance();

    $categories_query = "select c.categories_id, cd.categories_name, c.categories_image, c.parent_id, c.sort_order, c.date_added, c.last_modified,c.categories_status,c.categories_hidden, cd.categories_description, cd.categories_head_keywords_tag from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.parent_id = '" . $cID . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' ".$sWhere." order by  ".((!empty($sOrder)) ? $sOrder : " c.parent_id ASC , c.sort_order ASC, cd.categories_name ASC");

    $categories_split = new splitPageResults($page, $rowbyp, $categories_query,$query_numrows);

    $pq=$DB->query($categories_query);

    while ($categories = $pq->fetchAssoc()) {
      $categories['c.categories_id']=$categories['categories_id'];
      $categories['categories_image']=(!empty($categories['categories_image'])) ? tep_info_image($categories['categories_image'], $categories['categories_name'], TEMP_BO_SMALL_IMAGE_WIDTH, TEMP_BO_SMALL_IMAGE_HEIGHT) : ' N/A';
      $categories['categories_status']=self::get_status_categories($categories);
      $categories['categories_hidden']=self::get_status_menu($categories);
      $categories['cPath']=categorieUtility::get_generated_category_path_ids( $categories['categories_id']);
      self::$list[]=$categories;
    }

    $li=$res=array();
    foreach(self::$list as $item){
      foreach(self::tep_get_modele() as $k=>$v) $li[$k]=(isset($item[$k]) && !empty($item[$k]))? $item[$k] : '&nbsp;';
      $li[0]=$item['categories_id'];
      $li['action']=self::get_item_action($item);
      $res[]=$li;
    }


    if(count($res)==0) $res[]= self::emptyResult();
    return $res;
  }

 /** static InterfacedInnerHtml */

  public static function detail_row_page($id){
    self::$cInfo=self::load_db_values((int)$id);
    return tep_get_include_contents(__CLASS__.'.inline');
  }

}




class categoriesACA
  extends aca
    implements mod_aca{
  var $modules=array();
  var $categories_id;
  var $current_category_id;
  var $parent_id;
  var $image_handler;

  /**
    class constructor
  */
  function __construct($current_category_id=0) {

    global $language, $lang,$oscss;
    $this->name='categories';
    $this->categories_id='';
    $this->parent_id='';
    $this->image_handler='';

    $this->current_category_id = $current_category_id;

    foreach(parent::initialise_type('MODULE_ACACAT_INSTALLED_BO','categories') as $class){
	$cl[$class]=new $class ();
	$list_mod[$class] = $cl[$class]->sort_order;

	asort($list_mod);
	foreach($list_mod as $class=>$s){
	  $this->modules[$class] =$cl[$class];
	}
	unset($cl);unset($list_mod);
    }

    $this->set_image_handler(); // Ask which module takes care of image. Default: stock osc
  }


//   function get_header_js ($action) {
//   }

//   function check_action ($actions){
//   }

//   function set_image_handler () {
//   }

  function get_insert_table_categories (&$sql_data_array,$languages_id){
    foreach ($this->modules as $key=>$module)
      if ($module->enabled && method_exists($module, 'insert_table_categories' ))
            $this->modules[$key]->insert_table_categories($sql_data_array,$languages_id);
  }

  /**
  */
  function get_update_table_categories () {
    $sql_data_array=array ();
    foreach ($this->modules as $key=>$module) {
      if ($module->enabled && method_exists($module, 'update_table_categories' )){
	$sql_module =  $this->modules[$key]->update_table_categories($sql_data_array);
	$sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  function get_insert_table_categories_description ($sql_data_array,$languages_id) {
    $sql_data_array=array();
    foreach ($this->modules as $key=>$module)
	  if ($module->enabled && method_exists($module,'insert_table_categories_description' )) {
            $sql_data= $this->modules[$key]->insert_table_categories_description($sql_data_array, $languages_id);
            $sql_data_array=array_merge($sql_data_array,$sql_data);
      }
    return $sql_data_array;
  }

  /**
  */
  function get_update_table_categories_description ($languages_id) {
    $sql_data_array=array ();
    foreach ($this->modules as $key=>$module) {
      if ($module->enabled && method_exists($module,'update_table_categories_description' )) {
        $sql_module = $this->modules[$key]->update_table_categories_description($sql_data_array,$languages_id);
        $sql_data_array=array_merge ($sql_data_array, $sql_module);
      }
    }
    return $sql_data_array;
  }

  /**
   */
  function after_update ($categories_id){
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled) and (method_exists($module,'after_update')))
        $this->modules[$key]->after_update($categories_id);
    }
    $languages = tep_get_languages();
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
      $languages_id = $languages[$i]['id'];
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled) and (method_exists($module,'after_update_lang')))
          $this->modules[$key]->after_update_lang($languages_id, $categories_id);
      }
    }
  }

  /**
  */
  function delete_category ($categories_id='') {
    if ($categories_id!='') {
      $this->categories_id = $categories_id;
      foreach ($this->modules as $key=>$module) {
        if (method_exists($module, 'delete_category' ))
          $this->modules[$key]->delete_category($categories_id);
        }
    }
  }

  /**
    Load each enabled module parameters from database
  */
  public function load_db_values ($categories_id) {
    $this->categories_id=$categories_id;
    foreach ($this->modules as $key=>$module)
      if (($module->enabled) and (method_exists($module, 'load_db_values' )))
        $this->modules[$key]->load_db_values($categories_id);
  }


  public function load_post_values($post){}

  /**
    Call enabled modules that have something to preview
  */
  public function display_preview($contents, $languages_id){
    foreach ($this->modules as $key=>$module)
        if ($module->enabled && method_exists($module, 'display_preview' ))
          $contents=$this->modules[$key]->display_preview($contents, $languages_id);
     return $contents;
  }



}


?>