<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  28/09/10, 21:57
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class currencies
*/
error_reporting(E_ALL);
class currencies
  implements ExtModPage, InterfacedTJsonS, InterfaceModule {

  const FILENAME =FILENAME_CURRENCIES;
  public static $code;

  public static $action;

  public static $list=array();

  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;

    //! active datatable in ajax, precise les GET necessaire
    define('JSONSTATMENT', 'mod=page&type='.self::$code.(isset($_GET['cID'])?'&cID='.$_GET['cID'] : '' ) );
  }

  public function check_action($actions){
    global $messageStack;

//     $messageStack

    self::$action=$actions;

    switch (self::$action) {
      case 'insert':
      case 'save':
        if (isset($_GET['cID'])) $currency_id = tep_db_prepare_input((int)$_GET['cID']);
        $title = tep_db_prepare_input($_POST['title']);
        $code = tep_db_prepare_input($_POST['code']);
        $symbol_left = tep_db_prepare_input($_POST['symbol_left']);
        $symbol_right = tep_db_prepare_input($_POST['symbol_right']);
        $decimal_point = tep_db_prepare_input($_POST['decimal_point']);
        $thousands_point = tep_db_prepare_input($_POST['thousands_point']);
        $decimal_places = tep_db_prepare_input($_POST['decimal_places']);
        $value = tep_db_prepare_input($_POST['value']);

        $sql_data_array = array('title' => $title,
                                'code' => $code,
                                'symbol_left' => htmlentities($symbol_left),
                                'symbol_right' => htmlentities($symbol_right),
                                'decimal_point' => $decimal_point,
                                'thousands_point' => $thousands_point,
                                'decimal_places' => $decimal_places,
                                'value' => $value);

        if (self::$action == 'insert') {
          $res=tep_db_perform(TABLE_CURRENCIES, $sql_data_array);
          $currency_id = tep_db_insert_id($res);
        } elseif (self::$action == 'save') {
          tep_db_perform(TABLE_CURRENCIES, $sql_data_array, 'update', "currencies_id = '" . (int)$currency_id . "'");
        }

        if (isset($_POST['default']) && ($_POST['default'] == 'on')) {
          tep_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . tep_db_input($code) . "' where configuration_key = 'DEFAULT_CURRENCY'");
        }

        tep_redirect(tep_href_link(self::FILENAME, 'cID=' . $currency_id));
        break;
      case 'deleteconfirm':
        $currencies_id = tep_db_prepare_input($_GET['cID']);

        $currency_query = tep_db_query("select currencies_id from " . TABLE_CURRENCIES . " where code = '" . DEFAULT_CURRENCY . "'");
        $currency = tep_db_fetch_array($currency_query);

        if ($currency['currencies_id'] == $currencies_id) {
          tep_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '' where configuration_key = 'DEFAULT_CURRENCY'");
        }

        tep_db_query("delete from " . TABLE_CURRENCIES . " where currencies_id = '" . (int)$currencies_id . "'");

        tep_redirect(tep_href_link(self::FILENAME));
        break;
      case 'update':
        $server_used = CURRENCY_SERVER_PRIMARY;

        $currency_query = tep_db_query("select currencies_id, code, title from " . TABLE_CURRENCIES);
        while ($currency = tep_db_fetch_array($currency_query)) {
          $quote_function = 'quote_' . CURRENCY_SERVER_PRIMARY . '_currency';
          $rate = $quote_function($currency['code']);

          if (empty($rate) && (tep_not_null(CURRENCY_SERVER_BACKUP))) {
            $messageStack->add_session(sprintf(__('warning primary server failed'), CURRENCY_SERVER_PRIMARY, $currency['title'], $currency['code']), 'warning');

            $quote_function = 'quote_' . CURRENCY_SERVER_BACKUP . '_currency';
            $rate = $quote_function($currency['code']);

            $server_used = CURRENCY_SERVER_BACKUP;
          }

          if (tep_not_null($rate)) {
            tep_db_query("update " . TABLE_CURRENCIES . " set value = '" . $rate . "', last_updated = now() where currencies_id = '" . (int)$currency['currencies_id'] . "'");

            $messageStack->add_session(sprintf(__('text info currency updated'), $currency['title'], $currency['code'], $server_used), 'success');
          } else {
            $messageStack->add_session(sprintf(__('error currency invalid'), $currency['title'], $currency['code'], $server_used), 'error');
          }
        }

        tep_redirect(tep_href_link(self::FILENAME, 'cID=' . $_GET['cID']));
        break;
      case 'delete':
        $currencies_id = tep_db_prepare_input($_GET['cID']);

        $currency_query = tep_db_query("select code from " . TABLE_CURRENCIES . " where currencies_id = '" . (int)$currencies_id . "'");
        $currency = tep_db_fetch_array($currency_query);

        $remove_currency = true;
        if ($currency['code'] == DEFAULT_CURRENCY) {
          $remove_currency = false;
          $messageStack->add(__('error remove default currency'), 'error');
        }
        break;
    }

    return self::$action;
  }

  public function get_header(){
  }


  public static function load_db_values($ID){

    $DB=Database::getInstance();

    $currency_query_raw = "select currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, last_updated, value from " . TABLE_CURRENCIES . " WHERE currencies_id='".$ID."' ";
    $currency_query = $DB->query($currency_query_raw);

    return new objectInfo($currency_query->fetchAssoc() );
  }

  public function display_view(){
    self::tep_get_list();
    return tep_get_include_contents(self::$code.'.listing');
  }


  public static function get_right_bar(){
    global $currencies;
    $heading = array();
    $contents = array();

    if(isset($_GET['cID']) && tep_not_null($_GET['cID']) )  $cInfo=self::load_db_values($_GET['cID']);

    switch (self::$action) {
      case 'new':
        $heading[] = array('text' => __('text info heading new currency') );

        $contents = array('form' => tep_draw_form('currencies', self::FILENAME, '&amp;action=insert') );
        $contents[] = array('text' => __('text info insert intro') );
        $contents[] = array('class' => 'block_input','text' => __('text info currency title') . tep_draw_input_field('title'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency code') . tep_draw_input_field('code'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency symbol left') . tep_draw_input_field('symbol_left'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency symbol right') . tep_draw_input_field('symbol_right'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency decimal point') . tep_draw_input_field('decimal_point'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency thousands point') . tep_draw_input_field('thousands_point'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency decimal places') . tep_draw_input_field('decimal_places'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency value') . tep_draw_input_field('value'));
        $contents[] = array('class' => 'block_input','text' => tep_draw_checkbox_field('default') . __('text info set as default'));
        $contents[] = array('class' => 'button_nav','text' => tep_image_submit('button_insert.gif', IMAGE_INSERT) . ' <a class="button" href="' . tep_href_link(self::FILENAME) . '">' . IMAGE_CANCEL. '</a>');
        break;
      case 'edit':
        $heading[] = array('text' => __('text info heading edit currency') );

        $contents = array('form' => tep_draw_form('currencies', self::FILENAME, 'cID=' . $cInfo->currencies_id . '&amp;action=save'));
        $contents[] = array('class' => 'block_input','text' => __('text info edit intro'));
        $contents[] = array('class' => 'block_input','text' => __('text info currency title') . tep_draw_input_field('title','', $cInfo->title));
        $contents[] = array('class' => 'block_input','text' => __('text info currency code') . tep_draw_input_field('code','', $cInfo->code));
        $contents[] = array('class' => 'block_input','text' => __('text info currency symbol left') . tep_draw_input_field('symbol_left','', $cInfo->symbol_left));
        $contents[] = array('class' => 'block_input','text' => __('text info currency symbol right') . tep_draw_input_field('symbol_right','', $cInfo->symbol_right));
        $contents[] = array('class' => 'block_input','text' => __('text info currency decimal point') . tep_draw_input_field('decimal_point','', $cInfo->decimal_point));
        $contents[] = array('class' => 'block_input','text' => __('text info currency thousands point') . tep_draw_input_field('thousands_point','', $cInfo->thousands_point));
        $contents[] = array('class' => 'block_input','text' => __('text info currency decimal places') . tep_draw_input_field('decimal_places','', $cInfo->decimal_places));
        $contents[] = array('class' => 'block_input','text' => __('text info currency value') . tep_draw_input_field('value', '', $cInfo->value));
        if (DEFAULT_CURRENCY != $cInfo->code) $contents[] = array('class' => 'block_input','text' => tep_draw_checkbox_field('default') . ' ' . __('text info set as default'));
        $contents[] = array('class' => 'button_nav','text' => tep_image_submit('button_update.gif', IMAGE_UPDATE) . ' <a  class="button"  href="' . tep_href_link(self::FILENAME,  'cID=' . $cInfo->currencies_id) . '">' .  IMAGE_CANCEL . '</a>');
        break;
      case 'delete':
        $heading[] = array('text' => __('text info heading delete currency') );

        $contents[] = array('text' => __('text info delete intro') );
        $contents[] = array('text' => '<strong>' . $cInfo->title . '</strong>');
        $contents[] = array('class' => 'button_nav','text' =>  '<a  class="button" href="' . tep_href_link(self::FILENAME, 'cID=' . $cInfo->currencies_id . '&amp;action=deleteconfirm') . '">' . IMAGE_DELETE . '</a>'  . ' <a  class="button"  href="' . tep_href_link(self::FILENAME, 'cID=' . $cInfo->currencies_id) . '">' . IMAGE_CANCEL . '</a>');
        break;
      default:
        if (isset($cInfo) && is_object($cInfo)) {
          $heading[] = array('text' => $cInfo->title );

          $contents[] = array('text' => __('text info currency title') . $cInfo->title);
          $contents[] = array('text' => __('text info currency code') . $cInfo->code);
          $contents[] = array('text' => __('text info currency symbol left') . $cInfo->symbol_left);
          $contents[] = array('text' => __('text info currency symbol right') . $cInfo->symbol_right);
          $contents[] = array('text' => __('text info currency decimal point') . $cInfo->decimal_point);
          $contents[] = array('text' => __('text info currency thousands point') . $cInfo->thousands_point);
          $contents[] = array('text' => __('text info currency decimal places') . $cInfo->decimal_places);
          $contents[] = array('text' => __('text info currency value') . tep_date_short($cInfo->last_updated));
          $contents[] = array('text' => __('text info currency value') . number_format($cInfo->value, 8));
          $contents[] = array('text' => __('text info currency example') . $currencies->format('30', false, DEFAULT_CURRENCY) . ' = ' . $currencies->format('30', true, $cInfo->code));
        }
        break;
    }

    if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
      $box = new box;
      echo $box->infoBox($heading, $contents);

    }
  }


  /** public static InterfacedTJsonS */

  private static function get_item_action($currency){
    return '<span class="view fils fleft">'.
            '<a class="buttonimg" href="' . tep_href_link(self::FILENAME, 'cID=' . $currency['currencies_id']. '&amp;action=edit') . '">' . tep_image(DIR_WS_ICONS . 'icon_edit.png',IMAGE_EDIT) . '</a> '.
            '<a  class="buttonimg" href="' . tep_href_link(self::FILENAME, 'cID=' . $currency['currencies_id'] . '&amp;action=delete') . '">' .  tep_image(DIR_WS_ICONS . 'icon_delete.png',IMAGE_DELETE ). '</a>'.
            '</span>'.
	    '<span class="fright">'.
	      ( (isset($_GET['cID']) && $currency['currencies_id'] == $_GET['cID']) ? tep_image(DIR_WS_ICONS . 'icon_arrow_right.gif') :  '<a href="' . tep_href_link(self::FILENAME, 'cID=' .  $currency['currencies_id']) . '">' . tep_image(DIR_WS_ICONS . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>' ).
            '</span>'
	  ;
  }

  public static function tep_get_modele(){
    return array( 'title'=>true,
                  'code'=>true,
                  'value'=>true,
		  'action'=>false
                );
  }

  public static function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    global $query_numrows;

    $DB=Database::getInstance();

    $query_raw = "select currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, last_updated, value from " . TABLE_CURRENCIES . " ".$sWhere." ORDER BY ".((!empty($sOrder)) ? $sOrder : " title ASC ");
    $currency_split = new splitPageResults($page, $rowbyp, $query_raw, $query_numrows);

    $currency_query = $DB->query($query_raw);

    while ($currency = $currency_query->fetchAssoc() ) {
      $currency['action']=self::get_item_action($currency);
      self::$list[]=$currency;
    }

    $li=$res=array();
    foreach(self::$list as $item){
      foreach(self::tep_get_modele() as $k=>$v) $li[$k]=$item[$k];
      $res[]=$li;
    }

    return $res;
  }

/** Interface module */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;  }
  function keys() { return false; }
}

?>