<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/12/10, 15:25
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class geo_zones
  @brief base manage zone shipping and taxe
*/

class geo_zones
  implements ExtModPage, InterfacedTJsonS, InterfaceModule {

  const FILENAME = FILENAME_GEO_ZONES;

  public static $code;
  /**
    @param string action sur zone
  */
  public static $action;
  /**
    @param string action sur pays
  */
  public static $saction;
  /**
    @param int l'Id de zone
  */
  public static $list=array();
  /**
    @param int l'Id de zone
  */
  public static $getzID;
  /**
    @param int l'Id de pays ou null
  */
  public static $getsID;
  /**
    @param bool true list zone, false list pays
  */
  public static $is_zone;

  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;

    self::init();
  }

  public function check_action($actions){
    global $messageStack;
    self::$action=$actions;
    self::init();

    if(!empty(self::$saction) ||!empty( self::$getzID) ){
	  $zones_query_raw = "select geo_zone_id, geo_zone_name, geo_zone_description from " . TABLE_GEO_ZONES . " WHERE geo_zone_id='". self::$getzID."' " ;
	  $zones_query = tep_db_query($zones_query_raw);
	  $thezone=tep_db_fetch_array($zones_query);
    }

    if (!self::$is_zone)
      switch (self::$action) {
	case 'insert_sub':
	  $zID = tep_db_prepare_input( self::$getzID);

	  if(isset($_POST['zone_country_ids']) && is_array($_POST['zone_country_ids']) /*&& $_POST['zone_country_id'] ==''*/){
	    foreach($_POST['zone_country_ids'] as $zone_country_id )
	      tep_db_query("insert into " . TABLE_ZONES_TO_GEO_ZONES . " (zone_country_id, zone_id, geo_zone_id, date_added) values ('" . (int)$zone_country_id . "', NULL, '" . (int)$zID . "', now())");

	  }
	  else{
	    $zone_country_id = tep_db_prepare_input($_POST['zone_country_id']);
	    if(isset($_POST['zone_ids']) && is_array($_POST['zone_ids'])){
	      foreach($_POST['zone_ids'] as $zone_id )
		tep_db_query("insert into " . TABLE_ZONES_TO_GEO_ZONES . " (zone_country_id, zone_id, geo_zone_id, date_added) values ('" . (int)$zone_country_id . "', '" . (int)$zone_id . "', '" . (int)$zID . "', now())");
	    }
	    else{
	      $zone_id = tep_db_prepare_input($_POST['zone_ids']);
	      tep_db_query("insert into " . TABLE_ZONES_TO_GEO_ZONES . " (zone_country_id, zone_id, geo_zone_id, date_added) values ('" . (int)$zone_country_id . "', '" . (int)$zone_id . "', '" . (int)$zID . "', now())");
	    }
	  }


	  tep_redirect(tep_href_link(self::FILENAME,  tep_get_all_get_params(array( 'sID', 'zID', 'action'), false) . 'zID=' .  self::$getzID));
	break;
	case 'save_sub':
	  $sID = tep_db_prepare_input($_GET['sID']);
	  $zID = tep_db_prepare_input( self::$getzID);
	  $zone_country_id = tep_db_prepare_input($_POST['zone_country_id']);
	  $zone_id = tep_db_prepare_input($_POST['zone_id']);

	  tep_db_query("update " . TABLE_ZONES_TO_GEO_ZONES . " set geo_zone_id = '" . (int)$zID . "', zone_country_id = '" . (int)$zone_country_id . "', zone_id = " . (tep_not_null($zone_id) ? "'" . (int)$zone_id . "'" : 'null') . ", last_modified = now() where association_id = '" . (int)$sID . "'");

	  tep_redirect(tep_href_link(self::FILENAME, tep_get_all_get_params(array('saction'), false)));
	  break;

	case 'deleteconfirm_sub':
	  $sID = tep_db_prepare_input($_GET['sID']);

	  tep_db_query("delete from " . TABLE_ZONES_TO_GEO_ZONES . " where association_id = '" . (int)$sID . "'");

	  tep_redirect(tep_href_link(self::FILENAME, tep_get_all_get_params(array('action', 'sID'), false)));
	break;

      }



    if (self::$is_zone)
      switch (self::$action) {
	case 'insert_zone':
	  $geo_zone_name = tep_db_prepare_input($_POST['geo_zone_name']);
	  $geo_zone_description = tep_db_prepare_input($_POST['geo_zone_description']);

	  $r=tep_db_query("insert into " . TABLE_GEO_ZONES . " (geo_zone_name, geo_zone_description, date_added) values ('" . tep_db_input($geo_zone_name) . "', '" . tep_db_input($geo_zone_description) . "', now())");
	  $new_zone_id = tep_db_insert_id($r);

	  tep_redirect(tep_href_link(self::FILENAME,  tep_get_all_get_params(array('action', 'zID'), false). 'zID=' . $new_zone_id));
	  break;
	case 'save_zone':
	  $zID = tep_db_prepare_input( self::$getzID);
	  $geo_zone_name = tep_db_prepare_input($_POST['geo_zone_name']);
	  $geo_zone_description = tep_db_prepare_input($_POST['geo_zone_description']);

	  tep_db_query("update " . TABLE_GEO_ZONES . " set geo_zone_name = '" . tep_db_input($geo_zone_name) . "', geo_zone_description = '" . tep_db_input($geo_zone_description) . "', last_modified = now() where geo_zone_id = '" . (int)$zID . "'");

	  tep_redirect(tep_href_link(self::FILENAME, tep_get_all_get_params(array('action'), false)));
	  break;
	case 'deleteconfirm_zone':
	  $zID = tep_db_prepare_input( self::$getzID);

	  tep_db_query("delete from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$zID . "'");
	  tep_db_query("delete from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . (int)$zID . "'");

	  tep_redirect(tep_href_link(self::FILENAME, tep_get_all_get_params(array('action', 'zID'), false)));
	  break;
      }


    return self::$action;
  }

  public function get_header(){
    ?>
    <script language="javascript"><!--
    function resetZoneSelected(theForm) {
      if (theForm.state.value != '') {
	theForm.zone_ids.selectedIndex = '0';
	if (theForm.zone_ids.options.length > 0) {
	  theForm.state.value = '<?php echo JS_STATE_SELECT; ?>';
	}
      }
    }

    function update_zone(theForm) {
      var NumState = theForm.zone_ids.options.length;
      var SelectedCountry = "";

      while(NumState > 0) {
	NumState--;
	theForm.zone_ids.options[NumState] = null;
      }

      SelectedCountry = theForm.zone_country_id.options[theForm.zone_country_id.selectedIndex].value;

    <?php echo self::tep_js_zone_list('SelectedCountry', 'theForm', 'zone_ids'); ?>

    }
    //--></script>
    <?php
  }


  public static function load_db_values($ID){

    $DB=Database::getInstance();

    if (self::$is_zone) {
      $query_raw = "select geo_zone_id, geo_zone_name, geo_zone_description, last_modified, date_added from " . TABLE_GEO_ZONES . " WHERE geo_zone_id='".$ID."' ";
      $currency_query = $DB->query($query_raw);
      $zones=$currency_query->fetchAssoc();
      $num_zones_query = $DB->query("select count(*) as num_zones from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . (int)$zones['geo_zone_id'] . "' group by geo_zone_id");
      $num_zones =$num_zones_query->fetchAssoc();
      $zones['num_zones'] =  ($num_zones['num_zones'] > 0) ? $num_zones['num_zones'] : 0;
    } else {
      $query_raw = "select a.association_id, a.zone_country_id,  a.zone_id, a.geo_zone_id, a.last_modified, a.date_added,c.countries_name, z.zone_name from " . TABLE_ZONES_TO_GEO_ZONES . " a left join " . TABLE_COUNTRIES . " c on a.zone_country_id = c.countries_id left join " . TABLE_ZONES . " z on a.zone_id = z.zone_id where a.association_id =  '".$ID."' ";
      $currency_query = $DB->query($query_raw);
      $zones=$currency_query->fetchAssoc();
    }
    return new objectInfo($zones );
  }


  public function display_view(){

    if (self::$is_zone)
      switch (self::$action) {
	default:
	  self::tep_get_list();
	  return tep_get_include_contents(self::$code.'.listing');
      }
    else
      switch (self::$action) {
	default:
	  self::tep_get_list();
	  return tep_get_include_contents(self::$code.'.list');
      }
  }




  /** public static InterfacedTJsonS */

  private static function get_item_action($zones){
    self::init();
    $s = '<span class="view fils fleft">';
    if (self::$is_zone) {
      $s .=
            '<a class="buttonimg" href="' . tep_href_link(self::FILENAME, 'zID=' . $zones['geo_zone_id']. '&amp;action=edit') . '">' . tep_image(DIR_WS_ICONS . 'icon_edit.png',IMAGE_EDIT) . '</a> '.
            '<a  class="buttonimg" href="' . tep_href_link(self::FILENAME, 'zID=' . $zones['geo_zone_id'] . '&amp;action=delete') . '">' .  tep_image(DIR_WS_ICONS . 'icon_delete.png',IMAGE_DELETE ). '</a>'.
            '</span>'.
	    '<span class="fright">'.
// 	    '<a href="' . tep_href_link(FILENAME_GEO_ZONES, 'zpage=' . $zpage . '&amp;zID=' . $zones['geo_zone_id'] . '&amp;action=list&amp;spage=1&amp;sID=' . $zones['geo_zone_id'] .'&amp;saction=new') . '">' . tep_image(DIR_WS_ICONS . 'icon_add_new.png', IMAGE_INSERT) . '</a> '
	    '<a href="' . tep_href_link(self::FILENAME,'&amp;zID=' . $zones['geo_zone_id']. '&amp;geo_zone_name=' . $zones['geo_zone_name'] . '&amp;saction=list') . '">' . tep_image(DIR_WS_ICONS . 'icon_plus.gif', ICON_FOLDER) . '</a> ';
      if (self:: $getzID == $zones['geo_zone_id'] ) { $s .= tep_image(DIR_WS_ICONS . 'icon_arrow_right.gif'); }
      else { $s .= '<a href="' . tep_href_link(self::FILENAME, 'zID=' . $zones['geo_zone_id']) . '">' . tep_image(DIR_WS_ICONS . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; }

    }
    else {
      $s .=
		'<a class="buttonimg" href="' . tep_href_link(self::FILENAME, 'sID=' . $zones['association_id'] .  '&amp;zID='.self:: $getzID.'&amp;saction=list&amp;action=edit') . '">' . tep_image(DIR_WS_ICONS . 'icon_edit.png',IMAGE_EDIT ). '</a>'.
		'<a  class="buttonimg" href="' . tep_href_link(self::FILENAME,'sID=' . $zones['association_id'] .  '&amp;zID='.self:: $getzID.'&amp;saction=list&amp;action=delete') . '">' . tep_image(DIR_WS_ICONS . 'icon_delete.png',IMAGE_DELETE).'</a>'.
            '</span>'.
	    '<span class="fright">';

      if (self:: $getsID == $zones['association_id'] ) { $s .= tep_image(DIR_WS_ICONS . 'icon_arrow_right.gif'); }
      else { $s .= '<a href="' . tep_href_link(self::FILENAME, 'sID=' . $zones['association_id'] .  '&amp;zID='.self:: $getzID.'&amp;saction=list') . '">' . tep_image(DIR_WS_ICONS . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; }
    }

    $s .='</span>';
    return $s;
  }

  public static function tep_get_modele(){
    self::init();
    if (self::$is_zone)
      return array( 'type'=>false,
		    'geo_zone_name'=>true,
		    'geo_zone_description'=>true,
		    'num_zones' =>false,
		    'action'=>false
		  );
    else
      return array( 'countries_name'=>true,
		    'zone_name'=>true,
		    'action'=>false
		  );
  }

  public static function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    global $query_numrows;
    self::init();
    $DB=Database::getInstance();

     if (self::$is_zone) {
	$query_raw = "select geo_zone_id, geo_zone_name, geo_zone_description, last_modified, date_added from " . TABLE_GEO_ZONES . " ".$sWhere." ORDER BY ".((!empty($sOrder)) ? $sOrder : 'geo_zone_name ASC');

	$currency_split = new splitPageResults($page, $rowbyp, $query_raw, $query_numrows);
	$currency_query = $DB->query($query_raw);

	while ($zones = $currency_query->fetchAssoc() ) {
	  $num_zones_query = $DB->query("select count(*) as num_zones from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . (int)$zones['geo_zone_id'] . "' group by geo_zone_id");
	  $num_zones = $num_zones_query->fetchAssoc();
	  $zones['num_zones'] =  ($num_zones['num_zones'] > 0) ? $num_zones['num_zones'] : 0;
	  self::$list[]=$zones;
	}

	$li=$res=array();
	foreach(self::$list as $item){
	  foreach(self::tep_get_modele() as $k=>$v)$li[$k]=(isset($item[$k]) && !empty($item[$k]))? $item[$k] : '&nbsp;';
	  $li['type']=substr($item['geo_zone_name'], 0, strpos($item['geo_zone_name'],':'));
	  $li['action']=self::get_item_action($item);
	  $res[]=$li;
	}
      }
      else {

	$query_raw = "select a.association_id, a.zone_country_id,  a.zone_id, a.geo_zone_id, a.last_modified, a.date_added,c.countries_name, z.zone_name from " . TABLE_ZONES_TO_GEO_ZONES . " a left join " . TABLE_COUNTRIES . " c on a.zone_country_id = c.countries_id left join " . TABLE_ZONES . " z on a.zone_id = z.zone_id where a.geo_zone_id = '" .  self::$getzID . "' ".$sWhere." ORDER BY ".((!empty($sOrder)) ? $sOrder :  'association_id ASC');

	$zones_split = new splitPageResults($page, $rowbyp, $query_raw, $query_numrows);
	$zones_query = $DB->query($query_raw);

	while ($zones = $zones_query->fetchAssoc()) {
	  $zones['countries_name']= (!empty($zones['countries_name']) ? $zones['countries_name'] : __('text all countries'));
	  $zones['zone_name'] =(!empty($zones['zone_id']) ? $zones['zone_name'] : __('please select'));
	  self::$list[]=$zones;
	}
	$li=$res=array();
	foreach(self::$list as $item){
	  foreach(self::tep_get_modele() as $k=>$v)$li[$k]=(isset($item[$k]) && !empty($item[$k]))? $item[$k] : '&nbsp;';
	  $li['action']='&nbsp;'.self::get_item_action($item);
	  $res[]=$li;
	}
	if(!isset($res) || count($res)==0) $res[]=array('countries_name'=>'&nbsp;','zone_name'=>'&nbsp;','action'=>'&nbsp;');
      }
// print_r($res);
    return $res;
  }



  private static function init(){
    self::$action = (isset($_GET['action']) ? $_GET['action'] : '');
    self::$saction = (isset($_GET['saction']) ? $_GET['saction'] : '');
    self::$is_zone= (self::$saction == 'list') ? false : true   ;
    self::$getzID = (isset($_GET['zID']) ? $_GET['zID'] : '1');
    self::$getsID = (isset($_GET['sID']) ? $_GET['sID'] : '');


    //! active datatable in ajax, precise les GET necessaire
    if(!defined('JSONSTATMENT')) define('JSONSTATMENT', 'mod=page&type='.self::$code.(isset($_GET['zID']) ? '&zID='.$_GET['zID'] : '').(isset($_GET['saction']) ? '&saction='.$_GET['saction'] : ''));
  }

  /**
    Liste des zone geo
  */
  private static function tep_prepare_country_zones_pull_down($country_id = '') {
  // preset the width of the drop-down for Netscape
      $pre = '';
      if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
	for ($i=0; $i<45; $i++) $pre .= '&nbsp;';
      }

      $zones = tep_get_country_zones($country_id);

      if (sizeof($zones) > 0) {
	$zones_select = array(array('id' => '', 'text' => __('please select')));
	$zones = array_merge($zones_select, $zones);
      } else {
	$zones = array(array('id' => '', 'text' => __('type below')));
    // create dummy options for Netscape to preset the height of the drop-down
	if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
	  for ($i=0; $i<9; $i++) {
	    $zones[] = array('id' => '', 'text' => $pre);
	  }
	}
      }

    return $zones;
  }


  public static function get_right_bar(){
    global $currencies;
    $heading = array();
    $contents = array();

      if (self::$is_zone) {
	$zInfo=self::load_db_values(self:: $getzID);

	switch (self::$action) {
	  case 'new_zone':
	    $heading[] = array('text' => __('text info heading new zone') );

	    $contents = array('form' => tep_draw_form('zones', self::FILENAME, 'action=insert_zone'));
	    $contents[] = array('text' => __('text info new zone intro'));
	    $contents[] = array('class' => 'block_input','text' => __('text info zone name')  . tep_draw_input_field('geo_zone_name'));
	    $contents[] = array('class' => 'block_input','text' => __('text info zone description') . tep_draw_input_field('geo_zone_description'));
	    $contents[] = array('class' => 'button_nav','text' => tep_image_submit('button_insert.gif', IMAGE_INSERT) . ' <a class="button" href="' . tep_href_link(self::FILENAME) . '">' .  IMAGE_CANCEL . '</a>');
	    break;
	  case 'edit':
	    $heading[] = array('text' => __('text info heading edit zone') );

	    $contents = array('form' => tep_draw_form('zones', self::FILENAME, 'zID=' . $zInfo->geo_zone_id . '&amp;action=save_zone'));
	    $contents[] = array('text' => __('text info edit zone intro'));
	    $contents[] = array('class' => 'block_input','text' => __('text info zone name') . tep_draw_input_field('geo_zone_name','', $zInfo->geo_zone_name));
	    $contents[] = array('class' => 'block_input','text' => __('text info zone description') . tep_draw_input_field('geo_zone_description','', $zInfo->geo_zone_description));
	    $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_update.gif', IMAGE_UPDATE) . ' <a class="button" href="' . tep_href_link(self::FILENAME, 'zID=' . $zInfo->geo_zone_id) . '">' .  IMAGE_CANCEL . '</a>');
	    break;
	  case 'delete':
	    $heading[] = array('text' => __('text info heading delete zone') );

	    $contents = array('form' => tep_draw_form('zones', self::FILENAME,'zID=' . $zInfo->geo_zone_id . '&amp;action=deleteconfirm_zone'));
	    $contents[] = array('text' => __('text info delete zone intro'));
	    $contents[] = array('text' => '<strong>' . $zInfo->geo_zone_name . '</strong>');
	    $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a class="button" href="' . tep_href_link(self::FILENAME,'zID=' . $zInfo->geo_zone_id) . '">' .  IMAGE_CANCEL . '</a>');
	    break;
	  default:
	    if (isset($zInfo) && is_object($zInfo) && isset($zInfo->geo_zone_name)) {
	      $heading[] = array('text' => $zInfo->geo_zone_name );

	      $contents[] = array('class' => 'button_nav','text' => '<a class="button" href="' . tep_href_link(self::FILENAME, 'zID=' . $zInfo->geo_zone_id . '&amp;action=edit_zone') . '">' .  IMAGE_EDIT . '</a> <a class="button" href="' . tep_href_link(self::FILENAME,'zID=' . $zInfo->geo_zone_id . '&amp;action=delete_zone') . '">' .  IMAGE_DELETE . '</a>' . ' <a class="button" href="' . tep_href_link(self::FILENAME, 'zID=' . $zInfo->geo_zone_id . '&amp;saction=list') . '">' . IMAGE_DETAILS . '</a>');
	      $contents[] = array('text' => __('text info number zones') . $zInfo->num_zones);
	      $contents[] = array('text' => __('text info date added') . tep_date_short($zInfo->date_added));
	      if (tep_not_null($zInfo->last_modified)) $contents[] = array('text' => __('text info last modified') . tep_date_short($zInfo->last_modified));
	      $contents[] = array('text' => __('text info zone description') . $zInfo->geo_zone_description);
	    }
	}

      } else {

	if(!empty(self:: $getsID))$sInfo=self::load_db_values(self:: $getsID);

	switch (self::$action) {
	  case 'new':
	    $heading[] = array('text' => __('text info heading new sub zone') );
	    $contents = array('form' => tep_draw_form('zones', self::FILENAME,  'saction=list&amp;action=insert_sub&amp;zID=' .  self::$getzID));
	    $contents[] = array('text' => __('text info new sub zone intro'));
	    $contents[] = array('class' => 'block_input','text' => __('text info country') . tep_draw_pull_down_menu('zone_country_ids[]', tep_get_countries(__('text all countries'),array()), '', ' multiple="multiple"'));
	    $contents[] = array('class' => 'block_input','text' => __('text info country') . tep_draw_pull_down_menu('zone_country_id', tep_get_countries(__('text all countries')), '', ' onchange="update_zone(this.form);" '));
	    $contents[] = array('class' => 'block_input','text' => __('text info country zone') . tep_draw_pull_down_menu('zone_ids[]', self::tep_prepare_country_zones_pull_down(), '','multiple="multiple"'));
	    $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_insert.gif', IMAGE_INSERT) . ' <a class="button" href="' . tep_href_link(self::FILENAME, 'zID=' .  self::$getzID . '&amp;saction=list&amp;' . (!empty(self:: $getsID) ? 'sID=' . self:: $getsID : '')) . '">' .  IMAGE_CANCEL . '</a>');
	    break;
	  case 'edit':
	    $heading[] = array('text' => __('text info heading edit sub zone') );

	    $contents = array('form' => tep_draw_form('zones', self::FILENAME,   'sID=' . $sInfo->association_id . '&amp;saction=list&amp;action=save_sub&amp;zID=' .  self::$getzID));
	    $contents[] = array('text' => __('text info edit sub zone intro'));
	    $contents[] = array('class' => 'block_input','text' => __('text info country') . tep_draw_pull_down_menu('zone_country_id', tep_get_countries(__('text all countries')), $sInfo->zone_country_id, 'onchange="update_zone(this.form);"'));
	    $contents[] = array('class' => 'block_input','text' => __('text info country zone') . tep_draw_pull_down_menu('zone_id', self::tep_prepare_country_zones_pull_down($sInfo->zone_country_id), $sInfo->zone_id));
	    $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_update.gif', IMAGE_UPDATE) . ' <a class="button" href="' . tep_href_link(self::FILENAME, 'zID=' .  self::$getzID . '&amp;saction=list&amp;sID=' . $sInfo->association_id) . '">' . IMAGE_CANCEL . '</a>');
	    break;
	  case 'delete':
	    $heading[] = array('text' => __('text info heading delete sub zone') );

	    $contents = array('form' => tep_draw_form('zones', self::FILENAME, 'sID=' . $sInfo->association_id . '&amp;saction=list&amp;action=deleteconfirm_sub&amp;zID=' .  self::$getzID));
	    $contents[] = array('text' => __('text info delete sub zone intro'));
	    $contents[] = array('text' => '<strong>' . $sInfo->countries_name . '</strong>');
	    $contents[] = array('class' => 'button_nav', 'text' => tep_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a class="button" href="' . tep_href_link(self::FILENAME,  'sID=' . $sInfo->association_id) . '">' .  IMAGE_CANCEL . '</a>');
	    break;
	  default:
	    if (isset($sInfo) && is_object($sInfo)) {
	      $heading[] = array('text' => $sInfo->countries_name );

	      $contents[] = array('class' => 'button_nav', 'text' => '<a class="button" href="' . tep_href_link(self::FILENAME, 'sID=' . $sInfo->association_id . '&amp;action=edit') . '">' .  IMAGE_EDIT . '</a> <a class="button" href="' . tep_href_link(self::FILENAME, 'sID=' . $sInfo->association_id . '&amp;action=delete') . '">' .  IMAGE_DELETE . '</a>');
	      $contents[] = array('text' => __('text info date added') . tep_date_short($sInfo->date_added));
	      if (isset($sInfo->last_modified)) $contents[] = array('text' => __('text info last modified') . tep_date_short($sInfo->last_modified));
	    }
	    break;
	}


      }


      if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
	$box = new box;
	echo $box->infoBox($heading, $contents);

      }
  }

  private static function tep_js_zone_list($country, $form, $field) {
    $DB=Database::getInstance();
    $countries_query = $DB->query("select distinct zone_country_id from " . TABLE_ZONES . " order by zone_country_id");
    $num_country = 1;
    $output_string = '';
    while ($countries = $countries_query->fetchAssoc()) {
      if ($num_country == 1) {
	$output_string .= '  if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      } else {
	$output_string .= '  } else if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      }

      $states_query = $DB->query("select zone_name, zone_id from " . TABLE_ZONES . " where zone_country_id = '" . $countries['zone_country_id'] . "' order by zone_name");

      $num_state = 1;
      while ($states = $states_query->fetchAssoc()) {
	if ($num_state == '1') $output_string .= '    ' . $form . '.' . $field . '.options[0] = new Option("' . PLEASE_SELECT . '", "");' . "\n";
	$output_string .= '    ' . $form . '.' . $field . '.options[' . $num_state . '] = new Option("' . $states['zone_name'] . '", "' . $states['zone_id'] . '");' . "\n";
	$num_state++;
      }
      $num_country++;
    }
    $output_string .= '  } else {' . "\n" .
		      '    ' . $form . '.' . $field . '.options[0] = new Option("' . TYPE_BELOW . '", "");' . "\n" .
		      '  }' . "\n";

    return $output_string;
  }


/** Interface module */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;  }
  function keys() { return false; }
}

?>