<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  20/04/11, 18:04
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class graphs_stats
  @brief this class call and load data by childs module graph_stats

    The module  childs is in DIR_WS_MODULES.graphs_stats/

    This page display 2 block
      - One block for list childs modules , and form this ecart date start / end graph
      - Two block for construct master display.
	- One  graph current load module
	- One table by data use in graphs
*/


class graphs_stats
  implements ExtModPage, InterfaceModule{

  /**
    @var Folder childs modules
  */
  const PATH_GRAPH = 'graph_stats/';
  /**
    @var
  */
  public static $code;
  /**
    @var
  */
  public static $type;
  /**
    @var
  */
  public static $action;
  /**
    @var
  */
  public static $mode_view;
  /**
    @var
  */
  public static $list=array();
  /**
    @var
  */
  public static $Vue;

  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;
    self::$type='pages';


    self::$Vue= ((isset($_REQUEST['vue']) || !empty($_REQUEST['vue']))? $_REQUEST['vue'] : 'Sales' );

    //! active datatable in ajax, precise les GET necessaire
    define('JSONSTATMENT', 'mod=page&type='.self::$code.
			      (isset(self::$Vue)?'&vue='.self::$Vue : '' ).
			      (isset($_REQUEST['year'])?'&year='.$_REQUEST['year'] : '' ).
			      (isset($_REQUEST['year_end'])?'&year_end='.$_REQUEST['year_end'] : '' ).
			      (isset($_REQUEST['mode_view'])?'&mode_view='.$_REQUEST['mode_view']: '' ).
			      (isset($_REQUEST['width'])?'&width='.$_REQUEST['width'] : '' )
			    );
// var_dump(JSONSTATMENT);
    //! mode graph
    self::$mode_view[]=array('id'=>'stackedbars', 'text'=>__('txt barre cummulé') );
    self::$mode_view[]=array('id'=>'bars', 'text'=>__('txt barre') );
    self::$mode_view[]=array('id'=>'stackedarea', 'text'=>__('txt stackedarea') );
    self::$mode_view[]=array('id'=>'lines', 'text'=>__('txt lines') );
    self::$mode_view[]=array('id'=>'linepoints', 'text'=>__('txt linepoints') );
    self::$mode_view[]=array('id'=>'area', 'text'=>__('txt area') );
    self::$mode_view[]=array('id'=>'points', 'text'=>__('txt points') );
    self::$mode_view[]=array('id'=>'pie', 'text'=>__('txt pie') );
    self::$mode_view[]=array('id'=>'thinbarline', 'text'=>__('txt thinbarline') );
    self::$mode_view[]=array('id'=>'squared', 'text'=>__('txt squared') );
    self::$mode_view[]=array('id'=>'stackedarea', 'text'=>__('txt stackedarea') );


    self::loadMod(self::$Vue);
  }

  /**
    @fn $var->check_action($actions);
    @brief call action exe module
  */
  public function check_action($actions){
    global $messageStack;

    if (function_exists('imagecreate') ) {
      if (is_dir(DIR_WS_IMAGES . 'graphs')) {
	if (!is_writeable(DIR_WS_IMAGES . 'graphs'))  $messageStack->add(ERROR_GRAPHS_DIRECTORY_NOT_WRITEABLE, 'error');

      }
      else  $messageStack->add(ERROR_GRAPHS_DIRECTORY_DOES_NOT_EXIST, 'error');
    }

    return self::$action;
  }

  /**
    @fn $var->get_header();
    @brief call header block display
  */
  public function get_header(){
    ?>
    <script type="text/javascript"><!--
    /* Appel des pages, et execution de commande*/
    function get_ajax(id,vars,lib){
      var ter = document.getElementById(id);
      ter.innerHTML = '<p style="text-align:center"><img src="<?php echo DIR_WS_IMAGES ?>loading.gif"/></p>';
      $.ajax({
	type: "GET",
	url: lib,
	data: "<?php echo tep_session_name().'='.tep_session_id() ?>&" + vars,
	success: function(msg){
	  ter.innerHTML = msg;
	}
      });
      return false;
    }
    $(document).ready(function() {
      var gets = '<?php echo '&'.tep_get_all_get_params(array('class','exe','width','forceajax','print','lib'), false); ?>';
      var class_graph='<?php echo (!isset($_REQUEST['vue']))?'Sales': $_REQUEST['vue']; ?>';
       get_ajax('stats_div','forceajax=true&var='+class_graph+'&width='+$("div#stats_div").width()+'&mini=false&print=true&class=GraphLoader&funct=ajax_in_Sats'+gets,'ajax.php');
    });

    // --></script>
    <?php
  }

  /**
    @fn $var->load_db_values($ID);
    @param $ID integer
    @brief call db load for current id
  */
  public static function load_db_values($ID){

    foreach(scan(DIR_FS_ADMIN .DIR_WS_MODULES.self::PATH_GRAPH) as $file)
        if (substr("$file", -4) == '.php') {
            $name=substr("$file",0,strlen($file)-4);
	    self::$list[]=$name;
        }
  }

  /**
    @fn $var->display_view();
    @brief display view return content modules
  */
  public function display_view(){
    self::load_db_values('');
    return tep_get_include_contents(self::$code.'.page');
  }

  /**
    @fn $var->AjaxInSats($cl);
    @param $cl
    @brief Alias graphs_stats::ajax_in_Sats($cl='')
  */
  public static function AjaxInSats($cl='Sales'){
    return GraphUtility::CallGraph($cl, true);
  }

  /**
      @remarks  Next code is for call module childs graphs_stats.

      TODO: Centraliser avec les Graphxxx Et y deporter les fonction specilisés du chargement et utilisation des module de data type graphs_stats
  */


  /**
    @var object module child
  */
  public static $Mod;
  /**
    @var object module child
  */
  public static $ModPile;


  /**
    @fn graphs_stats::loadMod($class)
    @brief load module child
  */
  public static  function loadMod($class){
    if(!class_exists($class)){
      global $language,$oscss;
      $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/graph_stats/'.$class.'.txt');

      include_once(DIR_WS_MODULES.'graph_stats/'.$class.'.php');
    }
    if(isset(self::$ModPile[$class]) && is_object(self::$ModPile[$class])) return self::$Mod=self::$ModPile[$class];
    return self::$Mod=new $class;
  }


  /**
    @fn graphs_stats::tep_get_th()
    @brief call block theader table in module childs
  */
  public static function tep_get_th(){
    if(!isset($_REQUEST['vue'])) return;
    self:: loadMod($_REQUEST['vue']);
    return self::$Mod->tep_get_th();
  }

  /**
    @fn graphs_stats::tep_get_modele()
    @brief call array modele for table in module childs
  */
  public static function tep_get_modele(){
    if(!isset($_REQUEST['vue'])) return;
    self:: loadMod($_REQUEST['vue']);

    $s=array();
    for($is=0; $is<=self::$Mod->nbr_val; $is++ )
      $s[$is]=true;

    return $s;
  }

  /**
    @fn graphs_stats::tep_get_list()
    @brief call array list data for table in module childs
  */
  public static function tep_get_list($page=1,$rowbyp=10,$sOrder='',$sWhere='',$options=''){
    if(!isset($_REQUEST['vue'])) return;
    self:: loadMod($_REQUEST['vue']);

    return self::$Mod->tep_get_list($page,$rowbyp,$sOrder,$sWhere,$options);
  }







  /**
      @remarks  Next code is for call install config and remove this modules
      In use  by Interface module
  */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;  }
  function keys() { return false; }
}

?>