<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  18/04/11, 22:45
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class header_tag
*/

class header_tags
  extends AbstractHeader_tags
    implements ExtModPage {

  const FILENAME = FILENAME_FULL_TAG;
  /**
    @param string
  */
  public static $code;
  /**
    @param string
  */
  public static $action;
  /**
    @param array
  */
  public static $list=array();
  /**
    @param object
  */
  public static $pInfo;
  /**
    Element systeme, non listé
    @param array
  */
  public static $not_list=array('product_info',
		    'checkout_shipping_address',
		    'checkout_payment_address',
		    'checkout_payment', 'checkout',
		    'checkout_shipping',
		    'checkout_confirmation',
		    'checkout_success',
		    'account_newsletters',
		    'account_edit',
		    'account_history',
		    'password_forgotten',
		    'account',
		    'create_account_success',
		    'cookie_usage',
		    'logoff',
		    'account_history_info',
		    'account_aca',
		    'ssl_check',
		    'info_shopping_cart',
		    'privacy',
		    'account_password',
		    'index_listing',
		    'index' /** Correspond page home */
		    );
  /**
    @param array
  */
  public static $languages=array();
  /**
    @param string
  */
  public static $nameID;


  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;

    global $language,$languages_id;
    parent::load_lang();

    self::$languages = tep_get_languages();
  }

  public function check_action($actions){
    global $messageStack;

    $DB=Database::getInstance();

    self::$nameID=(isset($_GET['name'])?$_GET['name'] : '');
    self::$action=$actions;

    //! chosse page/generic
    $mode_key=(self::$nameID=='generic')? 'generic' : 'page';

    switch (self::$action) {
    case 'update':
      $_id = tep_db_prepare_input(self::$nameID);

      $com=parent::load_db_base($_id, $mode_key);

      $myarray=array('page_type' => $mode_key,
		    'page_id' => $_id);

      if(isset($com->tag_id)){
	tep_db_perform(TABLE_FULL_TAG, $myarray, 'update', " tag_id='".$com->tag_id."'" );
	$tag_id=$com->tag_id;
      }
      else {
	tep_db_perform(TABLE_FULL_TAG, $myarray);
	$products_query = $DB->query($sql="SELECT tag_id FROM " . TABLE_FULL_TAG . " ft WHERE ft.page_type='".$mode_key."' and  ft.page_id = '" . $_id . "' ");
	$tag_id=$products_query->__get('insertId');
      }

      $com=parent::load_post_values($_POST);
      $com->tag_id=$tag_id;
      $com2=parent::load_db_values($_id, $mode_key);

      for ($i=0, $n=sizeof(self::$languages); $i<$n; $i++) {

	if(parent::load_db_descr_check($tag_id,self::$languages[$i]['id'])) $action='update';
	else $action='insert';

	parent::insert_db_values($tag_id,$action,$com,self::$languages[$i]['id']);
      }

      tep_redirect(tep_href_link(self::FILENAME, 'name='.self::$nameID.'&action=edit'));
    break;
    case 'edit':
      $_id = tep_db_prepare_input(self::$nameID);
      $com=parent::load_db_values($_id, $mode_key);
    break;
    default:
    }

    return self::$action;
  }

  public function get_header(){
  }


  public static function load_db_values($ID){

    //! liste des page dispo , hors page specifique, et si un article cms ne prend pas la priorité
    foreach (scan(DIR_FS_CATALOG .DIR_WS_INCLUDES.'content/') as $file) {
        if (substr("$file", -4) == '.php') {
          $name=substr("$file",0,strlen($file)-4);
          if(!in_array($name, self::$not_list) && parent::get_prio_cms($name)==false ) {

            self::$list[]=array('file'=>$file, 'name'=>$name, 'key'=>$name);
          }
        }
    }
    //! Ajout Element generic
    self::$list[]=array('file'=>'generic', 'name'=>__('generic shop'), 'key'=>'generic');

    return  self::$list;
  }


  public function display_view(){
    self::$nameID=(isset($_GET['name'])?$_GET['name'] : '');
    self::load_db_values('');
    return tep_get_include_contents(self::$code.'.listing');
  }


  public static function get_right_bar(){
    global $currencies;
    $heading = array();
    $contents = array();

    //! chosse page/generic
    $mode_key=(isset($_GET['name']) && $_GET['name']=='generic')? 'generic' : 'page';
    self::$pInfo=new objectInfo(parent::load_db_values(@$_GET['name'],$mode_key));

    switch (self::$action) {
    case 'edit':
        if (self::$nameID != '') {
	  $heading[] = array('text' => __('Remplisser les champs suivants') );
	  $contents = array('form' => tep_draw_form('customers_groups', self::FILENAME, tep_get_all_get_params(array('cID', 'action')) .  'action=update'));

	  $m  = tep_draw_hidden_field('name','name',self::$nameID ).
	        tep_get_include_contents(self::$code.'.form').
		'<div class="button_nav">'.
		  tep_image_submit('button_delete.gif', IMAGE_UPDATE) .
		  tep_js_back(tep_href_link(self::FILENAME, 'name=' . $_GET['name']), IMAGE_CANCEL).
		'</div>';
	  $contents[] = array('text' =>$m);
        }
      break;
    default:
    }

    if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
      $box = new box;
      echo $box->infoBox($heading, $contents);

    }
  }

  /** Abstract Class Extends */
  public function after_update ($id) {}
  public function after_update_lang ($language_id,$id) {}

  public function display_edit(&$contents) {
    return tep_get_include_contents(self::$code.'.form');
  }


}

?>