<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  18/04/11, 18:46
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class index

  Class de gestion des tableau de bord, s'appuit sur le ficher dashboard.xml du dossier /includes/data/
  Un tableau de bord par type de menu
*/

class index
  implements ExtModPage {

  /**
    Data de base
  */
  const FILEDATA = 'dashboard.xml';
  /**
    @p string
  */
  public static $code;
  /**
    @p string
  */
  public static $action;
  /**
    liste des widget
  */
  public static $list=array('left'=>array(),'right'=>array());
  /**
    liste des graph, appel via ajax
  */
  private static $listgraph=array();
  /**
    @p string
  */
  private static $type;


  /**
    class constructor
  */
  public function __construct() {
    self::$code=__CLASS__;
    self::$type=(isset($_GET['type'])? $_GET['type'] : 'home');
  }

  public function check_action($actions){
    global $messageStack;


    self::$action=$actions;
    switch (self::$action) {
      case 'check_upgrade':
	if (!ini_get('allow_url_fopen')) {
	  $messageStack->add(ERROR_FOPEN, 'error');
	} else {

	  $fp = @fopen('http://www.oscss.org/latest_version', 'r');
	  $latest_version = trim(@fread($fp, 16));
	  @fclose($fp);

	  if ($latest_version == '') {
	    $error = true;
	    $messageStack->add(ERROR_UNKNOW, 'error');
	  }


	  if ($error == false) {
	    $cur_version = str_replace(array('.', 'dev', 'beta', ' ','oscss'), '', strtolower(PROJECT_VERSION));
	    $cur_version = (strlen($cur_version) == 2) ? intval($cur_version) * 10 : intval($cur_version);

	    $latest_version = str_replace('.', '', strtolower($latest_version));
	    $latest_version = (strlen($latest_version) == 2) ? intval($latest_version) * 10 : intval($latest_version);

	    if ($cur_version >= $latest_version)  $messageStack->add(LATEST_VERSION, 'success');
	    else  $messageStack->add(NEW_VERSION_AVAILABLE, 'success');
	  }
	}
      break;
      default:
	self::load_db_values(self::FILEDATA);
    }

      if ( preg_match('/averages?: ([0-9\.]+),[\s]+([0-9\.]+),[\s]+([0-9\.]+)/i', @exec('uptime'), $load_averages) )
	$server_load = $load_averages[1].' '.$load_averages[2].' '.$load_averages[3];
      else
	$server_load = 'Not available';

    return self::$action;
  }

  public function get_header(){
    ?>
    <script type="text/javascript"><!--
    /* Appel des pages, et execution de commande*/
    function get_ajax(id,vars,lib){
      var ter = document.getElementById(id);
      ter.innerHTML = '<p style="text-align:center"><img src="<?php echo DIR_WS_IMAGES ?>loading.gif"/></p>';
      $.ajax({
	type: "GET",
	url: lib,
	data: "<?php echo tep_session_name().'='.tep_session_id() ?>&" + vars,
	success: function(msg){
	  ter.innerHTML = msg;
	}
      });
      return false;
    }
    $(document).ready(function() {
      <?php foreach(self::$listgraph as $graph): ?>
	get_ajax('<?php echo $graph['name'] ?>_ImgGraph','forceajax=true&var=<?php echo $graph['querystring'] ?>&width='+(($("div#<?php echo $graph['name'] ?>").width())-50)+'&mini=true&print=false&class=GraphLoader&funct=ajax_in_Sats','ajax.php');
      <?php endforeach; ?>
    });

    // --></script>
    <?php
  }


  public static function load_db_values($ID){
    global $messageStack, $languages_id;
    try{
      if(!$SParser = simplexml_load_file(DIR_WS_INCLUDES.'data/'.$ID)) throw new Exception('Flux introuvable');

	foreach($SParser->xpath(self::$type) as $item){
	  foreach($item as $k=>$col){
	    foreach($col->widget as $widget){
	      $widg=(isset($widget[0])?$widget[0]:$widget);
	      //! list widget
	      self::$list[(string)$k][]=array('name'=>(string) $widg,
					      'class'=>(string)$widg['class'],
					      'querystring'=>(string)$widg['querystring'],
					      'acl'=>'');

	      //! list graph
	      if(isset($col->widget['class']) && (string)$col->widget['class'] =='graph')
		self::$listgraph[]=array( 'name'=>(string)$widg,
					  'class'=>(string)$widg['class'],
					  'querystring'=>(string)$widg['querystring'],
					  'acl'=>'');
	    }
	  }
	}

    }
    catch(Exception $e){
      $messageStack->add($e->getMessage(), 'error');
    }
  }

  public function display_view(){

    return tep_get_include_contents(self::$code.'.dashboard');
  }

}

?>