<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  17/10/10, 17:37
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class desc_base

  Gestion des description des produits
*/

class desc_base
  implements InterfaceModule{
  public $code;
  public $title;
  public $description;
  public $sort_order;
  public static $pInfo;
  public $enabled;

  /**
    class constructor
  */
  function desc_base() {
    $this->code = 'desc_base';
    $this->title = __('Description produits ');
    $this->description = __('Description simple des produits avec chapeau');
    $this->sort_order = (defined('MODULE_ACAPRO_DESC_BASE_SORT_ORDER'))?MODULE_ACAPRO_DESC_BASE_SORT_ORDER : 0;
    $this->enabled = true;

   self::$pInfo= new objectInfo (array());

    global $languages_id;
    $this->language_id = $languages_id;
  }

  /**
  */
  public function check_action($actions){
    global $oscss;
    $languages = tep_get_languages();
    $oscss->_add_ext(BO_WISIWYG_SELECTED,'editeur/');
    $nam='';
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
	$nam .= $this->code .'[products_chapo][' . $languages[$i]['id'] . '],'.$this->code .'[products_description][' . $languages[$i]['id'] . '],';
    }

    echo $oscss->_call(BO_WISIWYG_SELECTED,'_top',substr($nam,0, strlen($nam)-1),'400','100');

    return $actions;
  }

  /**
    Edition produit
    UP db
  */
  function insert_table_products_description ($language_id) {
    $myarray=array( 'products_description' => self::$pInfo['products_description'][$language_id],
		    'products_chapo' => self::$pInfo['products_chapo'][$language_id],
		    'products_url' => self::$pInfo['products_url'][$language_id]
		  );
    return $myarray;
  }

  /**
    Edition produit
    UP db
  */
  function update_table_products_description ($language_id) {
    $myarray= $this->insert_table_products_description ($language_id);
    return $myarray;
  }

  /**
    Edition/affichage  produit
    UP db
  */
  function load_db_values ($products_id) {
    $languages = tep_get_languages();
    $DB=Database::getInstance();
    $arr ['products_id'] = $products_id;
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
      $languages_id = $languages[$i]['id'];
        $product_query = $DB->query("SELECT pd.products_description,pd.products_chapo , pd.products_url FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd WHERE pd.products_id = '" . (int)$products_id . "' and pd.language_id = '" . (int)$languages_id . "'");
        $product = $product_query->fetchAssoc();
        $arr ['products_description'][$languages_id]=tep_output_string_protected($product['products_description'], false, true);
	$arr ['products_chapo'][$languages_id]=tep_output_string_protected($product['products_chapo'], false, true);
	$arr ['products_url'][$languages_id]=tep_output_string_protected($product['products_url'], false, true);
    }

   self::$pInfo->objectInfo($arr);
  }

  /**
    The $post contains only post values for this module pInfo is an array: [field name][language id]=value
  */
  function load_post_values ($post) {
   self::$pInfo=$post;
  }


  /**
  */
  function display_edit(&$contents, $product_id) {
    global $oscss;
    $languages = tep_get_languages();

    if(empty($product_id)) $m=__('enregistrer votre produit pour acceder à ces options ');
    else {
	/// use master gabarit
	$m= MGabCont::CallGab('edit',__FUNCTION__,'products/'.__CLASS__);
      }
        $contents []=array('title'=> __('Description') ,'text'=> $m);
    }

/** Fonction complementaire utilisé dans la page produits */

    /**
      Fournit tableau pour construire la rechchere en utilisant les option de ce modules
    */
    public function shearch_in_product(){

//       return array(
// //                   'table'=> TABLE_PRODUCTS_DESCRIPTION . " pd ",
// //                   'field_where' => " pd.products_id = '" .'%1$s'. "' and pd.language_id = '" .'%2$s'. "'   ",
//                   'field_shearch' => " or pd.products_head_title_tag Like '".'%1$s'."' or pd.products_head_desc_tag Like '".'%1$s'."' or pd.products_head_keywords_tag Like '".'%1$s'."'   ",
//                   'field_select'=> ', pd.products_head_title_tag, pd.products_head_desc_tag, pd.products_head_keywords_tag '
//                   );
    }


/** Force implements InterfaceModule class to define this method */

  function check() { return false; }
  function install() { return false; }
  function remove() { return false;    }
  function keys() {
    return array('MODULE_ACAPRO_DESC_BASE_SORT_ORDER');
  }

}
?>