<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  29/08/10, 21:47
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class header_tags
*/

class header_tags
  extends AbstractHeader_tags
    implements InterfaceModule{

  /**
    @param array
  */
  public static $languages = array();
  /**
    @param object
  */
  public static $pInfo;

  var $code;
  var $title;
  var $description;
  var $sort_order;
  var $enabled;

  /**
    class constructor
  */
  public function __construct() {
    global $language,$languages_id;
    parent::load_lang();

    $this->code = __CLASS__ ;
    $this->title = __('module acapro headertags text title');
    $this->description = __('module acapro headertags text description');
    $this->sort_order = (defined('MODULE_ACACAT_HTC_SORT_ORDER'))?MODULE_ACACAT_HTC_SORT_ORDER : 0;
    $this->enabled = true;

    self::$pInfo= new objectInfo (array());

    self::$languages= tep_get_languages();
  }


  /**
    Edition produit
    UP db
  */
  public function after_update ($products_id) {
    self::$pInfo=parent::load_db_base($products_id, 'product');
    $myarray=array('page_type' => 'product',
                  'page_id' => $products_id);

    if(isset(self::$pInfo->tag_id))tep_db_perform(TABLE_FULL_TAG, $myarray, 'update', " tag_id='".self::$pInfo->tag_id."'" );
    else {
      tep_db_perform(TABLE_FULL_TAG, $myarray);
      $products_query = tep_db_query("SELECT tag_id FROM " . TABLE_FULL_TAG . " ft WHERE ft.page_type='product' and  ft.page_id = '" . (int)$products_id . "' ");
      $products = tep_db_fetch_array($products_query);
      self::$pInfo->tag_id=$products['tag_id'];
    }

    $this->load_post_values($_POST);
  }

  /**
    Update table langue
  */
  public function after_update_lang ($language_id,$products_id) {

    $this->load_db_values($products_id);
    if(parent::load_db_descr_check(self::$pInfo->tag_id,$language_id)) $action='update';
    else $action='insert';

    $pInfo=parent::load_post_values($_POST);

   $pInfo->header_tags['head_title_tag'][$language_id]=(!empty($pInfo->header_tags['head_title_tag'][$language_id]) ?$pInfo->header_tags['head_title_tag'][$language_id] : $pInfo->products_name[$language_id]) ;
    parent::insert_db_values(self::$pInfo->tag_id,$action,$pInfo,$language_id);
  }

  /**
    Edition/affichage  produit
    UP db
  */
  public static function load_db_values ($Id, $type) {
    $arr ['products_id'] = $Id;
    $arr=array_merge(array('products_id'=>$Id) ,parent::load_db_values ($Id, 'product') );
    self::$pInfo->objectInfo($arr);
  }

  /**
    Draw
  */
  public function display_edit(&$contents) {
    $contents []=array('title'=> __('tab products meta'),'text'=>tep_get_include_contents(__CLASS__.'.form'));
  }

/** Force implements InterfaceModule class to define this method */
    public function check() { return true; }
    public function install() { return false; }
    public function remove() { return false;    }
    public function keys() {
      return array( 'MODULE_ACAPRO_HEADERTAGS_SORT_ORDER');
    }

}
?>