<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  14/11/10, 14:29
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
      Copyright (c) 2004 Ralph Day
      Released under the GNU General Public License

      Based on prior works released under the GNU General Public License:
        QT Pro prior versions
          Ralph Day, October 2004
          Tom Wojcik aka TomThumb 2004/07/03 based on work by Michael Coffman aka coffman
          FREEZEHELL - 08/11/2003 freezehell@hotmail.com Copyright (c) 2003 IBWO
          Joseph Shain, January 2003
        osCommerce MS2
          Copyright (c) 2003 osCommerce

      Modifications made:
        11/2004 - Clean up to not replicate for all languages
                  Handle multiple attributes per product
                  Ignore attributes that stock isn't tracked for
                  Remove unused code
        ENCODE UTF-8
*/

  require(DIR_WS_CLASSES . 'tracked_stock.php');
  $tracked_stock = new tracked_stock();
?>

  <h4><?php echo HEADING_TITLE; ?></h4>

<div class="box_uniq">

</div>
<div class="box_uniq">
<table style="width:100%" class="dataTableBase stock">
  <thead>
    <tr>
      <th><?php echo TABLE_HEADING_PRODUCTS.tep_link_sort_by(FILENAME_STATS,'pd.products_name'); ?></th>
      <th><?php echo TABLE_HEADING_MODEL.tep_link_sort_by(FILENAME_STATS_LOW_STOCK_ATTRIB,'p.products_model'); ?></th>
      <th><?php echo TABLE_HEADING_QUANTITY.tep_link_sort_by(FILENAME_STATS_LOW_STOCK_ATTRIB,'p.products_quantity'); ?></th>
      <th class="tright"><?php echo TABLE_HEADING_PRICE.tep_link_sort_by(FILENAME_STATS_LOW_STOCK_ATTRIB,'p.products_price'); ?></th>
    </tr>
</thead>
<tbody>
<?php
        $products_query_raw = "select distinct p.products_id, pd.products_name, p.products_model, p.products_quantity,p.products_price, l.name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_LANGUAGES . " l where p.products_id = pd.products_id and p.products_id = pd.products_id and l.languages_id = pd.language_id and pd.language_id = '" . (int)$languages_id . "' order by ".((isset($_GET['sort_by'])) ? $_GET['sort_by'] : 'pd.products_name ASC');

	if (isset($_GET['page']) && ($_GET['page'] > 1)) $rows = $_GET['page'] * MAX_DISPLAY_SEARCH_RESULTS - MAX_DISPLAY_SEARCH_RESULTS;
	$db_query_numrows= tep_db_num_rows( tep_db_query($products_query_raw));
        $db_query_split = new splitPageResults($_GET['page'], MAX_DISPLAY_ROW_BY_PAGE, $products_query_raw, $db_query_numrows);
        $products_query = tep_db_query($products_query_raw);


  while ($products = tep_db_fetch_array($products_query)) {

      $products_id = $products['products_id'];

      // check for product or attributes below reorder level
      $products_stock_query=tep_db_query("SELECT products_stock_attributes, products_stock_quantity
                                          FROM " . TABLE_PRODUCTS_STOCK . "
                                          WHERE products_id=" . $products['products_id'] ."
                                          ORDER BY products_stock_attributes");
      $products_stock_rows=tep_db_num_rows($products_stock_query);
      // Highlight products with low stock
      if ($products['products_quantity'] > STOCK_REORDER_LEVEL)$trclass="dataTableRow";
      else $trclass="OutofStock";


      //if (($products['products_quantity'] > (-1)) || ($products_stock_rows > 0)) {  //Note from Olof Larsson: I commented this out as we would like to se oversold products to. We would like to see the stockreport for ALL products regardles quantity right?
        $products_quantity= $products['products_quantity'];
        $products_price=($products_stock_rows > 0) ? '' : $currencies->format($products['products_price']);

    /**
         Add Attributes
    */
      if ($products_stock_rows > 0) {
        $products_options_name=$tracked_stock->db_option_tracked_stock($products['products_id']); ?>

    <tr class="dataTableRow">
      <td><?php echo '<a href="' . tep_href_link(FILENAME_STOCK, 'product_id=' . $products['products_id']) . '">' . $products['products_name'] .'</a>'; ?></td>
      <td class="tcenter"><?php echo $products['products_model']; ?></td>
      <td class="tcenter"> <?php echo $products_quantity; ?></td>
      <td class="tcenter"><?php echo $products_price; ?></td>
    </tr>

    <tr class="dataTableRow attribute stock">
      <td class="main">
        <table style="width:100%" class="dataTable">
          <tr class="dataTableRow ">
            <?php  foreach($products_options_name as $products_options_name) echo " <td class=\"smalltext\"><u>" . $products_options_name['products_options_name'] . "</u></td>\n"; ?>
          </tr>
<?php
          // buld array of attributes price delta
        $attributes_price = array();
        $products_attributes=$tracked_stock->db_attribute_value( $products['products_id']);
        foreach($products_attributes as $products_attributes_values) {
        $option_price = $products_attributes_values['options_values_price'];
        if ($products_attributes_values['price_prefix'] == "-") $option_price= -1*$option_price;
        $attributes_price[$products_attributes_values['options_id']][$products_attributes_values['options_values_id']] = $option_price;
      }

      // now display the attribute value names, table the html for quantity & price to get everything
      // to line up right
      $model_html_table="<table border=\"0\" width=\"100%\" class=\"dataTable\">\n";
      $model_html_table.=" <tr class=\"dataTableRow\"><td class=\"smalltext\" colspan=\"" . sizeof($products_attributes_values) . "\">&nbsp;</td></tr>\n";
      $quantity_html_table="<table width=\"100%\" class=\"dataTable\">\n";
      $quantity_html_table.="<tr class=\"dataTableRow\"><td class=\"smalltext\" colspan=\"" . sizeof($products_attributes_values) . "\">&nbsp;</td></tr>\n";
      $price_html_table="<table width=\"100%\" class=\"dataTable\">\n";
      $price_html_table.="<tr class=\"dataTableRow\"><td class=\"smalltext\" colspan=\"" . sizeof($products_attributes_values) . "\">&nbsp;</td></tr>\n";

      while($products_stock_values=tep_db_fetch_array($products_stock_query)) {
        $attributes=explode(",",$products_stock_values['products_stock_attributes']);
        echo "<tr class=\"dataTableRowSelected\">\n";

        $model_html_table.="<tr class=\"dataTableRowSelected\">\n";
        $quantity_html_table.="<tr class=\"dataTableRowSelected\">\n";
        $price_html_table.="<tr class=\"dataTableRowSelected\">\n";
        $total_price=$products['products_price'];

        // Highlight products out of stock
        if (($products_stock_values['products_stock_quantity']) > STOCK_REORDER_LEVEL) $trclassstock="dataTableContent";
        else $trclassstock="OutofStockAttrib";


        foreach($attributes as $attribute) {
          $attr=explode("-",$attribute);
          echo "<td class=\" " . $trclassstock . " \" >".tep_values_name($attr[1])."</td>\n";
          $total_price+=$attributes_price[$attr[0]][$attr[1]];
        }

        $total_price=$currencies->format($total_price);
        echo "</tr>\n";

        $model_html_table.="<td class=\"" . $trclassstock . " tcenter \">&nbsp;</td>\n";
        $model_html_table.="</tr>\n";
        $quantity_html_table.="<td class=\"" . $trclassstock . " tcenter\">" . $products_stock_values['products_stock_quantity'] . "</td>\n";
        $quantity_html_table.="</tr>\n";
        $price_html_table.="<td align=\"right\" class=\" " . $trclassstock . " tcenter\">" . $total_price . "</td>\n";
        $price_html_table.="</tr>\n";
      }
      $model_html_table.="</table>\n";
      $quantity_html_table.="</table>\n";
      $price_html_table.="</table>\n";

      echo "</table>\n";
      echo "</td>\n";
      echo "<td>" . $model_html_table . "</td>\n";
      echo "<td>" . $quantity_html_table . "</td>\n";
      echo "<td>" . $price_html_table . "</td>\n";
      echo "</tr>\n";
      echo "</table></td>\n";
      echo "</tr>\n";
        } else { ?>
        <tr class="<?php echo $trclass; ?>">
          <td><?php echo '<a href="' . tep_href_link(FILENAME_STOCK, 'product_id=' . $products['products_id']) . '">' . $products['products_name'] .'</a>'; ?></td>
          <td class="tcenter"><?php echo $products['products_model']; ?></td>
          <td class="tcenter"><?php echo $products_quantity; ?></td>
          <td class="tcenter"><?php echo $products_price; ?></td>
        </tr>
 <?php }
  }
?>
</tbody>
</table>
</div>
<!-- body_text_eof //-->

<!-- body_eof //-->
