<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  31/03/11, 11:32
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

    $le_Y=0;
    $marge_block=3;
    $padding_block=5;

    // Add the first page
    $pdf->AddPage();

    /**
      Ligne + titre doc
    */
      $pdf->Cell(50);
      $pdf->SetY(60);
      $pdf->SetDrawColor(153,153,153);
      $pdf->Cell(15,.1,'',1,1,'L',1);
      $pdf->SetFont('Arial','BI',15);
      $pdf->SetTextColor(153,153,153);
      $pdf->Text(22,61.5,tep_correct_entitie_put_pdf(PRINT_PACKINGSLIP_HEADING));
      $pdf->SetY(60);
      $pdf->SetDrawColor(153,153,153);
      $pdf->Cell(65);
      $pdf->Cell(126.6,.1,'',1,1,'L',1);

    /**
      Block des Adresse client
    */
      $le_Y=67;
      $hauteur_block=35;
      //Draw Box for Invoice Address
      $pdf->SetDrawColor(0);
      $pdf->SetLineWidth(0.2);
      $pdf->SetFillColor(245);
      $pdf->RoundedRect(6, $le_Y, 90, 35, 2, 'DF');

      //Draw the invoice address text
      $pdf->SetFont('Arial','B',10);
      $pdf->SetTextColor(0);
      $pdf->Text(11,77, tep_correct_entitie_put_pdf(ENTRY_SOLD_TO));
      $pdf->SetX(0);
      $pdf->SetY(80);
      $pdf->Cell(9);
      $pdf->MultiCell(70, 3.3, tep_correct_entitie_put_pdf(tep_address_format(1, $order->customer, '', '', "\n")),0,'L');

      //Draw Box for Delivery Address
      $pdf->SetDrawColor(0);
      $pdf->SetLineWidth(0.2);
      $pdf->SetFillColor(255);
      $pdf->RoundedRect(108, $le_Y, 90, 35, 2, 'DF');

      //Draw the invoice delivery address text
      $pdf->SetFont('Arial','B',10);
      $pdf->SetTextColor(0);
      $pdf->Text(113,77,tep_correct_entitie_put_pdf(ENTRY_SHIP_TO));
      $pdf->SetX(0);
      $pdf->SetY(80);
      $pdf->Cell(111);
      $pdf->MultiCell(70, 3.3, tep_correct_entitie_put_pdf(tep_address_format(1, $order->delivery, '', '', "\n")),0,'L');


    /**
      Block id commande et date
    */
      $le_Y=($le_Y+$hauteur_block+$marge_block);
      $hauteur_block=11;
      //Draw Box for Order Number, Date & Payment method
      $pdf->SetDrawColor(0);
      $pdf->SetLineWidth(0.2);
      $pdf->SetFillColor(245);
      $pdf->RoundedRect(6, $le_Y, 192, $hauteur_block, 2, 'DF');

      //Draw Order Number Text
      $temp = tep_correct_entitie_put_pdf(PRINT_PACKINGSLIP_ORDERNR);
      $pdf->Text(10,113, $temp .$order->info['orders_prefix'].$orders['orders_id']);
      //Draw Date of Order Text
      $temp = tep_correct_entitie_put_pdf(PRINT_INVOICE_DATE);
      $pdf->Text(130,113,$temp . tep_date_short($order->info['date_purchased']));

    /**
      Method payement
    */
      $le_Y=($le_Y+$hauteur_block+$marge_block);
      $hauteur_block=11;
      $pdf->SetDrawColor(0);
      $pdf->SetLineWidth(0.2);
      $pdf->SetFillColor(245);
      $pdf->RoundedRect(6, $le_Y, 192, $hauteur_block, 2, 'DF');
      $pdf->Text(10,127,tep_correct_entitie_put_pdf(ENTRY_PAYMENT_METHOD . ' ' . $order->info['payment_method']), 0, 0, 'R');


    /**
      Block detail commande
    */
    //Fields Name position
    $Y_Fields_Name_position = ($le_Y+$hauteur_block+$marge_block);
    $item_count=0;
    //Table position, under Fields Name
    $Y_Table_Position = ($Y_Fields_Name_position+6);

    output_table_heading_packingslip($Y_Fields_Name_position);
    //Show the products information line by line
    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
	$hauteur_block=$hauteur_block_r=6;
	$nbr_l=1;
      //. cesure general name produits
	if (strlen($order->products[$i]['name']) > 40 ) {
	  $r=tep_wordwrap($order->products[$i]['name'], 40);
	  $order->products[$i]['name'] =$r['txt'];
	  $nbr_l +=$r['nbr'];
	}
      // concat des attribut de produits  sur les nom, avec saut de ligne
	if (isset($order->products[$i]['attributes']) && (($k = sizeof($order->products[$i]['attributes'])) > 0)) {
	  for ($j = 0; $j < $k; $j++) {
	    $ligne="\n - ".$order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
	    if (strlen($ligne) > 40 ) {
	      $r=tep_wordwrap($ligne, 40);
	      $order->products[$i]['name'] .=$r['txt'];
	      $nbr_l +=$r['nbr'];
	    } else {
	      $order->products[$i]['name'] .=$ligne;
	      $nbr_l +=1;
	    }
	  }
	}
	$hauteur_block_r=($nbr_l*$hauteur_block_r);
    // quantite
      $pdf->SetFont('Arial','',10);
      $pdf->SetY($Y_Table_Position);
      $pdf->SetX(6);
      $pdf->MultiCell(9,$hauteur_block_r,$order->products[$i]['qty'],1,'C');
    // modele
      $pdf->SetY($Y_Table_Position);
      $pdf->SetX(15);
      $pdf->SetFont('Arial','',8);
      $pdf->MultiCell(25,$hauteur_block_r,tep_correct_entitie_put_pdf($order->products[$i]['model']),1,'C');

    // nom product
      $pdf->SetY($Y_Table_Position);
      $pdf->SetX(40);
      $pdf->SetFont('Arial','',8);
      $pdf->MultiCell(158,$hauteur_block,tep_correct_entitie_put_pdf($order->products[$i]['name']),1,'L');

      $Y_Table_Position += $hauteur_block_r;

      /* Check for product line overflow*/
      $item_count++;
      if ((is_long($item_count / 32) && $i >= 20) || ($i == 20)){
	$pdf->AddPage();
	//Fields Name position
	$Y_Fields_Name_position = 125;
	//Table position, under Fields Name
	$Y_Table_Position = 70;
	output_table_heading($Y_Table_Position-$hauteur_block_r);
	if ($i == 20) $item_count = 1;
      }
    }

?>
