<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/12/10, 17:51
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
  // Start the clock for the page parse time log
  define('PAGE_PARSE_START_TIME', microtime());

// Set the level of error reporting
  error_reporting(0);

// Set the local configuration parameters - mainly for developers
  if (file_exists('includes/local/configure.php'))include('includes/local/configure.php');
  else require('includes/configure.php');

  // force config in object, by stdclass
  $conf = (object)$conf;

  //! gestionnaire d'erreur
    //! gestionnaire d'erreur
  if(OSCSS_GARBAGE_ERROR==true) {
    include(DIR_WS_CLASSES.'osC_ErrorHandler.php');
    $errorHandler = osC_ErrorHandler::start();
    $errorHandler->attach($mock=new MockWriter());
    $file=( (getenv('HTTPS') == 'on')? 'err-login-php-ssl' : 'err-login-php' );
    $errorHandler->attachFileWriter(DIR_WS_INCLUDES.'tmp/'.$file.'.log');
  }


  require(DIR_WS_FUNCTIONS . 'general.php');

// set php_self in the local scope
  $PHP_SELF = (isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

  // include the list of project constante
  require(DIR_WS_INCLUDES . 'filenames.php');
  require(DIR_WS_INCLUDES . 'database_tables.php');

/// include the database functions
  require(DIR_FS_CATALOG.DIR_WS_COMMON_FUNCTIONS . 'database.php');
/// make a connection to the database... now
  $DB=Database::getInstance();

  //! element optionnel
  if (file_exists(DIR_WS_INCLUDES . 'tables_files_modules.php')) require(DIR_WS_INCLUDES . 'tables_files_modules.php');

  //! set application wide parameters
  $res=$DB->query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION .' where configuration_type IN ("1","2") ');
  while ($configuration = $res->fetchAssoc()){
    if(!empty($configuration['cfgKey'])){
      define(strtoupper($configuration['cfgKey']), $configuration['cfgValue']);
      $conf->$configuration['cfgKey']=$configuration['cfgValue'];
    }
  }

  //! define our general functions used application-wide
  require(DIR_WS_FUNCTIONS . 'html_output.php');

  // master Content gabarit
  require(DIR_WS_CLASSES . 'MGabCont.php');

  require(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES . 'osCSS_Cache.php');
  //! initialize the cache class
  $osCSS_Cache = new osCSS_Cache();

  // include navigation history class
  $navigation=new navigationHistory();

  //! define how the session functions will be used
  require(DIR_WS_FUNCTIONS . 'sessions.php');
  //! récupère la MASTER VALUE de 'session.save_path'
  define('PHP_SESSION_SAVE_PATH_MASTER', ini_get('session.save_path'));

// set the session name and save path
  tep_session_name('osCAdminID');
  tep_session_save_path();

// set the session cookie parameters
   if (function_exists('session_set_cookie_params')) {
    session_set_cookie_params(0, DIR_WS_ADMIN);
  } elseif (function_exists('ini_set')) {
    ini_set('session.cookie_lifetime', '0');
    ini_set('session.cookie_path', DIR_WS_ADMIN);
  }

// lets start our session
  tep_session_start();
  tep_session_regenerate(tep_session_id());


// set the language
  if ((!tep_session_is_registered('language') || empty($language)) || isset($_GET['language'])) {
    if (!tep_session_is_registered('language')) {
      tep_session_register('language');
      tep_session_register('languages_id');
      tep_session_register('language_code2');
      tep_session_register('language_iso');
    }

    $lng = new language();

    if (isset($_GET['language']) && tep_not_null($_GET['language']))  $lng->set_language($_GET['language']);
    else  $lng->get_browser_language();

    $language = $lng->language['directory'];
    $language_code2 = $lng->language['directory_code2'];
    $languages_id = $lng->language['id'];
    $language_iso = $lng->language['code'];
  }
  //! definiton des langue
  $languages = tep_get_languages(false, false);

  $languages_array = array();
  $languages_selected = $conf->DEFAULT_LANGUAGE;
  //! Boucle recup lang dispo
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
      $languages_array[] = array('id' => $languages[$i]['code'], 'text' => $languages[$i]['name']);
      if ($languages[$i]['directory'] == $language) $languages_selected = $languages[$i]['code'];
    }
  if(empty($language)) $language='fr_FR';
  require(DIR_WS_LANGUAGES . $language .'.php');
  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGIN);

  /*
   *\brief Block access for admin login, if test process >3
   */
  if(!isset($_SESSION['init_login'])) $_SESSION['init_login']=1;
  if($_SESSION['init_login']>30) exit;

  $login=new login_ident;

  if ( (isset($_GET['action']) && ($_GET['action'] == 'process')) || ( (isset($_GET['openid_assoc_handle'])) ) ) {
    // incremente compteur essai login
    $_SESSION['init_login'] +=1;

    if($login->check_user() !=false) {
      $login->init_login();

      //!  increment session login process
      $_SESSION['init_login'] +=1;

      //!
      if(tep_cst_define('WHOS_ONLINE_ACTIVE') =='auto')
	       $DB->query("update " . TABLE_CONFIGURATION ." set last_modified = now(),configuration_value='true'  where configuration_key='WHOS_ONLINE_FLAG'");

      if (sizeof($navigation->snapshot) > 0 ) {
				$origin_href = tep_href_link($navigation->snapshot['page'], tep_array_to_string($navigation->snapshot['get'], array(tep_session_name(), 'action')));
				$navigation->clear_snapshot();
				tep_redirect($origin_href);
    /*  } elseif (($login_lognum == 0) || !($login_logdate) || ($login_email_address == 'admin@localhost') || ($login_modified == '0000-00-00 00:00:00')) {
	tep_redirect(tep_href_link(FILENAME_ADMIN_ACCOUNT));*/
      } else {
	      tep_redirect(tep_href_link(FILENAME_DEFAULT));
      }
    }
    else $_GET['login'] = 'fail';
  }

  //!this is for admin themes
  if (!isset($_GET['menu_theme']) && isset($_COOKIE['menu_theme']) )
    $current_theme = $_COOKIE['menu_theme'] ;
  else
    $current_theme = get_info_core(DIR_FS_CATALOG. DIR_WS_COMMON.'oscss.version.xml','template_admin');


  //! rep courant template
  if(is_dir(DIR_WS_INCLUDES . "template/".$current_theme.'/') && file_exists(DIR_WS_INCLUDES . "template/".$current_theme.'/'.basename(__FILE__))) define('DIR_WS_TEMPLATE', DIR_WS_INCLUDES . "template/".$current_theme.'/');
  else define('DIR_WS_TEMPLATE', DIR_WS_INCLUDES . 'template/defaut/');

  require(DIR_WS_TEMPLATE.basename(__FILE__));

  if(OSCSS_GARBAGE_ERROR==true)$errorHandler = osC_ErrorHandler::stop();
?>