<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  19/08/10, 15:36
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
// Start the clock for the page parse time log
  define('PAGE_PARSE_START_TIME', microtime());

  if (file_exists('includes/local/configure.php'))include('includes/local/configure.php');
  else require('includes/configure.php');

  //! gestionnaire d'erreur
  include(DIR_WS_CLASSES.'osC_ErrorHandler.php');
  $errorHandler = osC_ErrorHandler::start();
  $errorHandler->attach($mock=new MockWriter());
  $errorHandler->attachFileWriter(DIR_WS_INCLUDES.'tmp/err-login-php.log');

  require(DIR_WS_FUNCTIONS . 'general.php');

// set php_self in the local scope
  $PHP_SELF = (isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

  // include the list of project constante
  require(DIR_WS_INCLUDES . 'filenames.php');
  require(DIR_WS_INCLUDES . 'database_tables.php');

/// include the database functions
  require(DIR_FS_CATALOG.DIR_WS_COMMON_FUNCTIONS . 'database.php');
/// make a connection to the database... now
  $DB=Database::getInstance();

  //! element optionnel
  if (file_exists(DIR_WS_INCLUDES . 'tables_files_modules.php')) require(DIR_WS_INCLUDES . 'tables_files_modules.php');

  //! set application wide parameters
  $res=$DB->query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION .' where configuration_type IN ("1","2") ');
  while ($configuration = $res->fetchAssoc())
    define(strtoupper($configuration['cfgKey']), $configuration['cfgValue']);

  //! define our general functions used application-wide
  require(DIR_WS_FUNCTIONS . 'html_output.php');

  require(DIR_WS_FUNCTIONS . 'password_funcs.php');

  $navigation=new navigationHistory();
// define how the session functions will be used
  require(DIR_WS_FUNCTIONS . 'sessions.php');


// set the session name and save path
  tep_session_name('osCAdminID');
  tep_session_save_path();

// set the session cookie parameters
   if (function_exists('session_set_cookie_params')) {
    session_set_cookie_params(0, DIR_WS_ADMIN);
  } elseif (function_exists('ini_set')) {
    ini_set('session.cookie_lifetime', '0');
    ini_set('session.cookie_path', DIR_WS_ADMIN);
  }

// lets start our session
  tep_session_start();
  tep_session_regenerate(tep_session_id());

// set the language
  if (!tep_session_is_registered('language') || isset($_GET['language'])) {
    if (!tep_session_is_registered('language')) {
      tep_session_register('language');
      tep_session_register('languages_id');
    }

    include(DIR_WS_CLASSES . 'language.php');
    $lng = new language();

    if (isset($_GET['language']) && tep_not_null($_GET['language'])) {
      $lng->set_language($_GET['language']);
    } else {
      $lng->get_browser_language();
    }

    $language = $lng->language['directory'];
    $languages_id = $lng->language['id'];
  }
  /* definiton des langue */
  $languages = tep_get_languages();
  $languages_array = array();
  $languages_selected = DEFAULT_LANGUAGE;
  /* Boucle recup lang dispo */
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
      $languages_array[] = array('id' => $languages[$i]['code'], 'text' => $languages[$i]['name']);
      if ($languages[$i]['directory'] == $language) $languages_selected = $languages[$i]['code'];
    }
  if(empty($language)) $language='fr_FR';
  require(DIR_WS_LANGUAGES . $language .'.php');
//   require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGIN);

  /* definiton des langue */
  $languages = tep_get_languages();
  $languages_array = array();
  $languages_selected = DEFAULT_LANGUAGE;
  /* Boucle recup lang dispo */
  for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
    $languages_array[] = array('id' => $languages[$i]['code'], 'text' => $languages[$i]['name']);
    if ($languages[$i]['directory'] == $language) $languages_selected = $languages[$i]['code'];
  }
  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGIN);

  if (isset($_GET['action']) && ($_GET['action'] == 'process')) {
    $email_address = tep_db_prepare_input($_POST['email_address']);
    $firstname = tep_db_prepare_input($_POST['firstname']);
    $log_times = (isset($_POST['log_times'])) ? $_POST['log_times']+1 : 1 ;
    if ($log_times >= 4) {
      tep_session_register('password_forgotten');
    }

// Check if email exists
    $check_admin_query = tep_db_query("select admin_id as check_id, admin_firstname as check_firstname, admin_lastname as check_lastname, admin_email_address as check_email_address from " . TABLE_ADMIN . " where admin_email_address = '" . tep_db_input($email_address) . "'");
    if (!tep_db_num_rows($check_admin_query)) {
      $_GET['login'] = 'fail';
    } else {
      $check_admin = tep_db_fetch_array($check_admin_query);
      if ($check_admin['check_firstname'] != $firstname) {
        $_GET['login'] = 'fail';
      } else {
        $_GET['login'] = 'success';

        function randomize() {
         $pass='';
          $salt = "ABCDEFGHIJKLMNOPQRSTUVWXWZabchefghjkmnpqrstuvwxyz0123456789";
          srand((double)microtime()*1000000);
          $i = 0;

          while ($i <= 7) {
            $num = rand() % 33;
            $tmp = substr($salt, $num, 1);
            $pass = $pass . $tmp;
            $i++;
          }
          return $pass;
        }
        $makePassword = randomize();

        tep_mail($check_admin['check_firstname'] . ' ' . $check_admin['check_lastname'], $check_admin['check_email_address'], ADMIN_EMAIL_SUBJECT, sprintf(ADMIN_EMAIL_TEXT, $check_admin['check_firstname'], HTTP_SERVER . DIR_WS_ADMIN, $check_admin['check_email_address'], $makePassword, STORE_OWNER), STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
        tep_db_query("update " . TABLE_ADMIN . " set admin_password = '" . tep_encrypt_password($makePassword) . "' where admin_id = '" . $check_admin['check_id'] . "'");
      }
    }
  }

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php echo HTML_PARAMS; ?> >
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
    <title><?php echo TITLE; ?></title>
    <style type="text/css">
        body { width: 100%; margin: 0; padding: 0; text-align: center; font: 0.8em Georgia,Tahoma,sans-serif; color: #000; background: #fff url(images/fond.jpg) repeat-y center; }
        h1 { width:210px; height:105px; background: transparent url(images/oscss.jpg) no-repeat; text-indent:-9999px; }
        h2 { font-size: 1em }
        h3 { font-size: 0.8em }
        #page{position: relative; width : 210px; margin: 0 auto 0 auto;  text-align: left;}
#content,#password_perdu { border:1px solid #000; padding:2em 0 2em 1em;}
        .button{font-family:Arial; font-size:13px;white-space:nowrap;}
        input.button{background:#e3e5f0; border:1px solid #003c74; padding:1px 5px; margin:1px 2px;color:black;}
        input.button:hover{background:#797979; border:1px solid #003c74; padding:1px 5px; margin:1px 2px ; color:white;}
        a.button{background:#e3e5f0; border:1px solid #003c74; padding:2px 5px; margin:1px 2px ;color:black;text-decoration:none;}
        a.button:hover{background:#797979; border:1px solid #003c74; padding:2px 5px ; margin:1px 2px ; color:white;text-decoration:none;}
        input { background : #d4dce1; color : #000; font-family : Verdana,Arial,Helvetica,sans-serif; font-size : 1em; border-width : 1px; }
        .alert{ position:fixed; color:red; background:white; border:1px solid red; padding:5px 20px; top:15%; width:300px; margin:0 auto 0 -90px }
    </style>
</head>
<body>
<div id="page">
  <h1>osCSS</h1>
<div id="content">
  <?php echo tep_draw_form('login', FILENAME_PASSWORD_FORGOTTEN, 'action=process'); ?>
  <h2><?php echo HEADING_PASSWORD_FORGOTTEN; ?></h2>



  <?php
    if (isset($_GET['login']) && $_GET['login'] == 'success') {
      $success_message = TEXT_FORGOTTEN_SUCCESS;
    } elseif (isset($_GET['login']) && $_GET['login'] == 'fail') {
      $info_message = TEXT_FORGOTTEN_ERROR;
    }
    if (tep_session_is_registered('password_forgotten')) {
  ?>
      <p>
        <?php echo TEXT_FORGOTTEN_FAIL; ?>
        <br />
        <?php echo '<a class="button" href="' . tep_href_link(FILENAME_LOGIN, '' , 'SSL') . '">' .  IMAGE_BACK . '</a>'; ?>
      </p>

  <?php } elseif (isset($success_message)) { ?>
          <p>
              <?php echo $success_message; ?>
            <br />
            <?php echo '<a class="button" href="' . tep_href_link(FILENAME_LOGIN, '' , 'SSL') . '">' .  IMAGE_BACK . '</a>'; ?>
          </p>
  <?php
    } else {
        if (isset($info_message)) {
  ?>
        <div class="alert">
          <p><?php echo $info_message; ?><?php echo tep_draw_hidden_field('log_times', '', $log_times); ?></p>
        </div>
      <?php } ?>
      <p>
        <label for="firstname"><?php echo ENTRY_FIRSTNAME; ?></label><br />
        <?php echo tep_draw_input_field('firstname'); ?>
      </p>
        <p>
        <label for="email_address"><?php echo ENTRY_EMAIL_ADDRESS; ?></label><br />
        <?php echo tep_draw_input_field('email_address'); ?>
      </p>

      <div class="button_nav"><?php echo '<a class="button" href="' . tep_href_link(FILENAME_LOGIN, '' , 'SSL') . '">' .  IMAGE_BACK . '</a> ' . tep_image_submit('button_confirm.gif', IMAGE_BUTTON_LOGIN); ?>
      </div>
  <?php } ?>
  </form>
  </div>
</div>

</body>
</html>