<?php
/**
* \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
* \package osCSS-2 <www http://www.oscss.org>
* \version 2.1.0
* \date  01/06/10, 22:16
* \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
* \encode UTF-8
*
* \file 
* \brief Page de Recherche avancé
*
*/

  require('includes/application_top.php');
  require(DIR_WS_FUNCTIONS.'search.php');

  $page->init(basename(__FILE__),$language);
  $error = false;

//   if ( (isset($_GET['keywords']) && empty($_GET['keywords'])) &&
//         (isset($_GET['dfrom']) && (empty($_GET['dfrom']) || ($_GET['dfrom'] == DOB_FORMAT_STRING))) &&
//         (isset($_GET['dto']) && (empty($_GET['dto']) || ($_GET['dto'] == DOB_FORMAT_STRING))) &&
//         (isset($_GET['pfrom']) && !is_numeric($_GET['pfrom'])) &&
//         (isset($_GET['pto']) && !is_numeric($_GET['pto'])) ) {
//     $error = true;
//
//     $page->messageStack->add('search', ERROR_AT_LEAST_ONE_INPUT);
//   } else {
          $dfrom = '';
          $dto = '';
          $pfrom = '';
          $pto = '';
          $keywords = '';

          if (isset($_GET['dfrom']))  $dfrom = (($_GET['dfrom'] == DOB_FORMAT_STRING) ? '' : $_GET['dfrom']);
          if (isset($_GET['dto']))   $dto = (($_GET['dto'] == DOB_FORMAT_STRING) ? '' : $_GET['dto']);
          if (isset($_GET['pfrom'])) $pfrom = $_GET['pfrom'];
          if (isset($_GET['pto']))  $pto = $_GET['pto'];
          if (isset($_GET['keywords']))  $keywords = $_GET['keywords'];

          $date_check_error = false;
          if (tep_not_null($dfrom)) {
            if (!tep_checkdate($dfrom, DOB_FORMAT_STRING, $dfrom_array)) {
              $error = true;
              $date_check_error = true;

              $page->messageStack->add_session('search', ERROR_INVALID_FROM_DATE);
            }
          }

          if (tep_not_null($dto)) {
            if (!tep_checkdate($dto, DOB_FORMAT_STRING, $dto_array)) {
              $error = true;
              $date_check_error = true;

              $page->messageStack->add_session('search', ERROR_INVALID_TO_DATE);
            }
          }

          if (($date_check_error == false) && tep_not_null($dfrom) && tep_not_null($dto)) {
            if (mktime(0, 0, 0, $dfrom_array[1], $dfrom_array[2], $dfrom_array[0]) > mktime(0, 0, 0, $dto_array[1], $dto_array[2], $dto_array[0])) {
              $error = true;

              $page->messageStack->add_session('search', ERROR_TO_DATE_LESS_THAN_FROM_DATE);
            }
          }

          $price_check_error = false;
          if (tep_not_null($pfrom)) {
            if (!settype($pfrom, 'double')) {
              $error = true;
              $price_check_error = true;

              $page->messageStack->add_session('search', ERROR_PRICE_FROM_MUST_BE_NUM);
            }
          }

          if (tep_not_null($pto)) {
            if (!settype($pto, 'double')) {
              $error = true;
              $price_check_error = true;

              $page->messageStack->add_session('search', ERROR_PRICE_TO_MUST_BE_NUM);
            }
          }

          if (($price_check_error == false) && is_float($pfrom) && is_float($pto)) {
            if ($pfrom >= $pto) {
              $error = true;

              $page->messageStack->add_session('search', ERROR_PRICE_TO_LESS_THAN_PRICE_FROM);
            }
          }

          if (tep_not_null($keywords)) {
            if (!tep_parse_search_string($keywords, $search_keywords)) {
              $error = true;

              $page->messageStack->add_session('search', ERROR_INVALID_KEYWORDS);
            }
          }
//         }
// var_dump($error);
        if ($error != true) {

      // create column list
          $define_list = array('PRODUCT_LIST_MODEL' => _cst_bool('PRODUCT_LIST_MODEL'),
                              'PRODUCT_LIST_NAME' => _cst_bool('PRODUCT_LIST_NAME'),
                              'PRODUCT_LIST_MANUFACTURER' => _cst_bool('PRODUCT_LIST_MANUFACTURER'),
                              'PRODUCT_LIST_PRICE' =>_cst_bool(' PRODUCT_LIST_PRICE'),
                              'PRODUCT_LIST_QUANTITY' => _cst_bool('PRODUCT_LIST_QUANTITY'),
                              'PRODUCT_LIST_WEIGHT' => _cst_bool('PRODUCT_LIST_WEIGHT'),
                              'PRODUCT_LIST_IMAGE' => _cst_bool('PRODUCT_LIST_IMAGE'),
                              'PRODUCT_LIST_BUY_NOW' => _cst_bool('PRODUCT_LIST_BUY_NOW') );

        asort($define_list);

        $column_list = array();
        reset($define_list);
        while (list($key, $value) = each($define_list)) {
          if (_test_bool($value)) $column_list[] = $key;
        }

        $select_column_list = '';

        for ($i=0, $n=sizeof($column_list); $i<$n; $i++) {
          switch ($column_list[$i]) {
            case 'PRODUCT_LIST_MODEL': $select_column_list .= 'p.products_model, '; break;
            case 'PRODUCT_LIST_MANUFACTURER': $select_column_list .= 'm.manufacturers_name, '; break;
            case 'PRODUCT_LIST_QUANTITY': $select_column_list .= 'p.products_quantity, '; break;
            case 'PRODUCT_LIST_IMAGE': $select_column_list .= 'p.products_image, '; break;
            case 'PRODUCT_LIST_WEIGHT': $select_column_list .= 'p.products_weight, '; break;
          }
        }

//         $select_str = "select distinct " . $select_column_list . " m.manufacturers_id, p.products_id, pd.products_name, p.products_price,p.products_quantity, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price ";
        $select_str = "SELECT DISTINCT " . $select_column_list . " m.manufacturers_id, p.products_id, pd.products_name, p.products_price,p.products_quantity, p.products_tax_class_id, p.specials_new_products_price , p.final_price ,p.products_tax_class_id ";

        if ( (_cst_bool('DISPLAY_PRICE_WITH_TAX')) && (tep_not_null($pfrom) || tep_not_null($pto)) ) {
          $select_str .= ", SUM(tr.tax_rate) as tax_rate ";
        }

//         $from_str = "from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id) left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id";
        $from_str = "from " . TABLE_V_PRODUCTS . " p ";
	$from_str .=" left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id) ";
	$from_str .=" left join " . TABLE_PRODUCTS_DESCRIPTION . " pd using(products_id) ";
// 	$from_str .=" left join " . TABLE_CATEGORIES . " c using(manufacturers_id) ";
	$from_str .=" left join " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c using(products_id) ";
	$from_str .=" left join " . TABLE_PRODUCTS_ATTRIBUTES . " pa using(products_id) ";
//         $from_str .= ", " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c ," . TABLE_PRODUCTS_ATTRIBUTES . ' pa ';


	  if ( /*(_cst_bool('DISPLAY_PRICE_WITH_TAX')) &&*/ (tep_not_null($pfrom) || tep_not_null($pto)) ) {
	    if (!tep_session_is_registered('customer_country_id')) {
	      $customer_country_id = STORE_COUNTRY;
	      $customer_zone_id = STORE_ZONE;
	    }
	    $from_str .= " left join " . TABLE_TAX_RATES . " tr on p.products_tax_class_id = tr.tax_class_id left join " . TABLE_ZONES_TO_GEO_ZONES . " gz on tr.tax_zone_id = gz.geo_zone_id and (gz.zone_country_id is null or gz.zone_country_id = '0' or gz.zone_country_id = '" . (int)$customer_country_id . "') and (gz.zone_id is null or gz.zone_id = '0' or gz.zone_id = '" . (int)$customer_zone_id . "')";
	  }
        $from_str .= ",  " . TABLE_CATEGORIES . " c ";
//         $from_str .= ", " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c ," . TABLE_PRODUCTS_ATTRIBUTES . ' pa';

//         $where_str = " WHERE  p.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id  and c.categories_status='1'";
  $where_str = " WHERE  pd.language_id = '" . (int)$languages_id . "' and  p2c.categories_id = c.categories_id  and c.categories_status='1'";

        if (isset($_GET['categories_id']) && tep_not_null($_GET['categories_id'])) {
          if (isset($_GET['inc_subcat']) && ($_GET['inc_subcat'] == '1')) {
            $subcategories_array = array();
            tep_get_subcategories($subcategories_array, $_GET['categories_id']);

            $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and (p2c.categories_id = '" . (int)$_GET['categories_id'] . "'";

            for ($i=0, $n=sizeof($subcategories_array); $i<$n; $i++ ) {
              $where_str .= " or p2c.categories_id = '" . (int)$subcategories_array[$i] . "'";
            }

            $where_str .= ")";
          } else {
            $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' and p2c.categories_id = '" . (int)$_GET['categories_id'] . "'";
          }
        }

        if (isset($_GET['manufacturers_id']) && tep_not_null($_GET['manufacturers_id'])) {
          $where_str .= " and m.manufacturers_id = '" . (int)$_GET['manufacturers_id'] . "'";
        }

        if (isset($search_keywords) && (sizeof($search_keywords) > 0)) {
          $where_str .= " and (";
          for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
            switch ($search_keywords[$i]) {
              case '(':
              case ')':
              case 'and':
              case 'or':
                $where_str .= " " . $search_keywords[$i] . " ";
                break;
              default:
                $keyword = tep_db_prepare_input($search_keywords[$i]);
                $where_str .= "(pd.products_name like '%" . tep_db_input($keyword) . "%'  or p.products_model like '%" . tep_db_input($keyword) . "%' or p.manufacturers_name like '%" . tep_db_input($keyword) . "%'";
                if (isset($_GET['search_in_description']) && ($_GET['search_in_description'] == '1')) $where_str .= " or pd.products_description like '%" . tep_db_input($keyword) . "%'";
                $where_str .= ')';
                break;
            }
          }
          $where_str .= " )";
        }

        if (tep_not_null($dfrom))  $where_str .= " and p.products_date_added >= '" . tep_date_raw($dfrom) . "'";

        if (tep_not_null($dto)) $where_str .= " and p.products_date_added <= '" . tep_date_raw($dto) . "'";

        if (tep_not_null($pfrom)) {
          if ($currencies->is_set($currency)) {
            $rate = $currencies->get_value($currency);

            $pfrom = $pfrom / $rate;
          }
        }

        if (tep_not_null($pto)) {
          if (isset($rate)) {
            $pto = $pto / $rate;
          }
        }

//         if (_cst_bool('DISPLAY_PRICE_WITH_TAX')) {
          if ($pfrom > 0) $where_str .= " and (p.final_price * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) >= " . (double)$pfrom . ")";
          if ($pto > 0) $where_str .= " and (p.final_price * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) <= " . (double)$pto . ")";
//         } else {
//           if ($pfrom > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) >= " . (double)$pfrom . ")";
//           if ($pto > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) <= " . (double)$pto . ")";
//         }
  $attributes_query = tep_db_query("select * from " . TABLE_PRODUCTS_OPTIONS . " where language_id = '" . (int)$languages_id . "'");
  $option_value_selected = false;
  $products_stock_attributes_array = array();
  while ($attributes = tep_db_fetch_array($attributes_query)) {
  	if (isset($_GET[$attributes["products_options_name"]]) && !empty($_GET[$attributes["products_options_name"]]))
      	$option_value_selected = true;
  }
  // the above while loop is to check to see if any values were selected
  if ($option_value_selected == true){
  	$attributes_query2 = tep_db_query("select * from " . TABLE_PRODUCTS_OPTIONS . " where language_id = '" . (int)$languages_id . "'");
  	while ($attributes2 = tep_db_fetch_array($attributes_query2)) {
  		if (isset($_GET[$attributes2["products_options_name"]]) && !empty($_GET[$attributes2["products_options_name"]])) {
			$str_selected_values = $str_selected_values . $_GET[$attributes2["products_options_name"]] . ',';
    	}
  	}
  	$str_selected_values = substr($str_selected_values,0,strlen($str_selected_values) - 1);
  	$where_str .= "and pa.products_id = p.products_id and pa.options_values_id in (".$str_selected_values.")";
  	// end of accompanying code to advanced_search_result.php that accompanies advanced_search.php
  	// that will include all options_values_id that were selected
	// *********************************************************************************************************
  	// *********************************************************************************************************
  }
        if ( (_cst_bool('DISPLAY_PRICE_WITH_TAX')) && (tep_not_null($pfrom) || tep_not_null($pto)) ) {
          $where_str .= " group by p.products_id, tr.tax_priority";
        }

        if ( (!isset($_GET['sort'])) || (!preg_match('/[1-8][ad]/', $_GET['sort'])) || (substr($_GET['sort'], 0, 1) > sizeof($column_list)) ) {
          for ($i=0, $n=sizeof($column_list); $i<$n; $i++) {
            if ($column_list[$i] == 'PRODUCT_LIST_NAME') {
              $_GET['sort'] = $i+1 . 'a';
              $order_str = ' order by pd.products_name';
              break;
            }
          }
        } else {
          $sort_col = substr($_GET['sort'], 0 , 1);
          $sort_order = substr($_GET['sort'], 1);
          $order_str = ' order by ';
          switch ($column_list[$sort_col-1]) {
            case 'PRODUCT_LIST_MODEL': $order_str .= "p.products_model " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name"; break;
            case 'PRODUCT_LIST_NAME': $order_str .= "pd.products_name " . ($sort_order == 'd' ? "desc" : ""); break;
            case 'PRODUCT_LIST_MANUFACTURER': $order_str .= "m.manufacturers_name " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name"; break;
            case 'PRODUCT_LIST_QUANTITY': $order_str .= "p.products_quantity " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name"; break;
            case 'PRODUCT_LIST_IMAGE': $order_str .= "pd.products_name"; break;
            case 'PRODUCT_LIST_WEIGHT': $order_str .= "p.products_weight " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name"; break;
            case 'PRODUCT_LIST_PRICE': $order_str .= "final_price " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name"; break;
          }
        }

        if(!isset($order_str))$order_str = 'order by  p.products_id DESC';
        $listing_sql = $select_str . $from_str . $where_str . $order_str;
  }


  $page->post_init();

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>