<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\brief page pre-process order
*/
  require('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $page->is_registered();

  //! if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1)  tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

  //! avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID)  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

  //! if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping') && (tep_count_shipping_modules() > 0)) tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));

  /// Stock Check
  if (! Stock::check_cart() ) tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

  if (!tep_session_is_registered('payment')) tep_session_register('payment');
  if (isset($_POST['payment'])) $payment = $_POST['payment'];

  if (!tep_session_is_registered('comments')) tep_session_register('comments');
  if (isset($_POST['comments']) && tep_not_null($_POST['comments'])) $comments = tep_db_prepare_input($_POST['comments']);


  //this needs to be set before the order object is created, but we must process it after
  $coupon_sav = (isset($_POST['coupon'])) ? tep_db_prepare_input($_POST['coupon']) : '';
  if (!tep_session_is_registered('coupon_sav')) tep_session_register('coupon_sav');

//! chargement payment
  $payment_modules = payment::getInstance($payment);

//! chargement order
  $order = new order;
  $page->add_object('order',$order);

//! mise a jour status payment
  $tt=$payment_modules->update_status();

  if ( ( is_array($payment_modules->modules) && (sizeof($payment_modules->modules) > 1) && !is_object($$payment) ) || (is_object($$payment) && ($$payment->enabled == false)) ) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
  }

  if (is_array($payment_modules->modules)) {
    $payment_modules->pre_confirmation_check();
  }

//! chargement payment
  $shipping_modules = shipping::getInstance();

  //kgt - discount coupons
  if( isset( $coupon_sav ) && is_object( $order->coupon ) ) {
    $order->coupon->verify_code();
    if( $order->coupon->is_errors() ) {
	if( tep_session_is_registered('coupon_sav') ) tep_session_unregister('coupon_sav');
	//!remove the coupon from the session
	tep_redirect( tep_href_link( FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode( implode( ' ', $order->coupon->get_messages() ) ), 'SSL' ) );
    } else {

      //!if the coupon field is empty, unregister the coupon from the session
      if( tep_session_is_registered('coupon_sav') ) {

	//!we had a coupon entered before, so we need to unregister it
//           tep_session_unregister('coupon');
	//!now check to see if we need to recalculate shipping:
	require_once( DIR_WS_CLASSES.'discount_coupon.php' );
	//! redirect to the shipping page to reselect the shipping method
	if( discount_coupon::is_recalc_shipping() ) tep_redirect( tep_href_link( FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode( ENTRY_DISCOUNT_COUPON_SHIPPING_CALC_ERROR ), 'SSL' ) );
      }
      else tep_session_register('coupon_sav');
    }
  }


//! Search or load order total modules
  if( ($order_total_modules=$page->return_object('order_total')) ==false){
    if(!class_exists('order_total')) require(DIR_WS_CLASSES . 'order_total.php');
    $order_total_modules = new order_total;
    $page->add_object('order_total_modules',$order_total_modules);
  }


  $page->breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $page->post_init();

  $order_totals = $order_total_modules->process();

  $page->add_var_page('order_totals',$order_totals);

/**
  Held_process_order
  Enregsitrement pre-commande
*/
  $aca_modules = new checkout_process('', 'holding');

  $res=$aca_modules->process_exe($order_totals);
// print_r($res);
// Array ( [the_order_id] => 37 [customer_notification] => 1 [total_weight] => 0 [total_tax] => 0 [total_cost] => 187.1 )
  $pre_order_id=$res['the_order_id'];
  tep_session_register('pre_order_id');


  require($page->path_gabarit());


  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>