<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file 
 *\brief page process checkout payement
*/
  require('includes/application_top.php');
  $page->init(basename(__FILE__),$language);

  $page->is_registered();
  tep_session_unregister('payment');
  unset($payment);

  //! if there is nothing in the customers cart, redirect them to the shopping cart page
  if (!tep_session_is_registered('cart') || $cart->count_contents() < 1)  tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

  //! avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID)  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }
  elseif(isset($cart->cartID) && !tep_session_is_registered('cartID')) {
    $cartID=$cart->cartID;
    tep_session_register('cartID');
  }


  // if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping') && (tep_count_shipping_modules() > 0))
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));


  // avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }


  /// Stock Check
  if (! Stock::check_cart() ) tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));



  // if no billing destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('billto')) {
    tep_session_register('billto');
    $billto = $customer_default_address_id;
  } else {
  // verify the selected billing address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$billto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $billto = $customer_default_address_id;
      if (tep_session_is_registered('payment')) tep_session_unregister('payment');
    }
  }

  $order = new order;
  $page->add_object('order',$order);

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

  // load all enabled payment modules
  $payment_modules = payment::getInstance($payment);

  $page->add_var_page('payment_modules',$payment_modules);

  $page->breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $page->post_init();


  $page->javascript->add_framework("ext/jquery/jquery.min.js");
  $page->javascript->add_script("ext/jquery/jquery.validate.min.js", array('sort'=>30));

  $selection = $payment_modules->selection();
  $radio_buttons = 0;

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>