<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  29/01/11, 11:46
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
 *\file
 *\brief page choose address payement
*/
  require('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $page->is_registered();

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

// needs to be included earlier to set the success message in the messageStack

  $error = false;
  $process = false;
  if (isset($_POST['action']) && ($_POST['action'] == 'submit')) {
// process a new billing address

    if (tep_not_null($_POST['firstname']) && tep_not_null($_POST['lastname']) && tep_not_null($_POST['street_address'])) {

	$cust=customer::getInstance($customer_id);

    	$res=$cust->userAddAddressBook($_POST);

        if (!tep_session_is_registered('billto')) tep_session_register('billto');
        $billto = tep_db_insert_id($res);

        if (tep_session_is_registered('payment')) tep_session_unregister('payment');

        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

// process the selected billing destination
    } elseif (isset($_POST['address'])) {
      $reset_payment = false;
      if (tep_session_is_registered('billto')) {
        if ($billto != $_POST['address']) {
          if (tep_session_is_registered('payment')) {
            $reset_payment = true;
          }
        }
      } else {
        tep_session_register('billto');
      }

      $billto = $_POST['address'];

      $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "' and address_book_id = '" . $billto . "'");
      $check_address = tep_db_fetch_array($check_address_query);

      if ($check_address['total'] == '1') {
        if ($reset_payment == true) tep_session_unregister('payment');
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
      } else {
        tep_session_unregister('billto');
      }
// no addresses to select from - customer decided to keep the current assigned address
    } else {
      if (!tep_session_is_registered('billto')) tep_session_register('billto');
      $billto = $customer_default_address_id;

      tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
    }
  }

// if no billing destination address was selected, use their own address as default
  if (!tep_session_is_registered('billto')) {
    $billto = $customer_default_address_id;
  }

  /**
    @brief load db value address book customers
    TODO: use class customer
  */
  $addresses_count = tep_count_customer_address_book_entries();

  $addresses_query = tep_db_query("select address_book_id, entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "'");
//   $addresses = tep_db_fetch_array($addresses_query);
  /**
    @brief use session stocked for pre-entry forms
  */
  if($_SESSION['country_id']) $entry['country']=$_SESSION['country_id'];
  if($_SESSION['state_id']) $entry['state']=$_SESSION['state_id'];
//     $entry['lastname']=$_SESSION['customer_lastname'];
    $entry['firstname']=$_SESSION['customer_first_name'];



  $page->breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

  $page->post_init();

  $addresses_count = tep_count_customer_address_book_entries();

  /// script validate js
  $page->javascript->add_framework("ext/jquery/jquery.min.js");
  $page->javascript->add_script("ext/jquery/jquery.validate.min.js", array('sort'=>30));
  /// call js view last time
  $file=DIR_WS_INCLUDES.'js/checkout_address.js.php';
  if( ($file=page::fix_file($file)) && $file !=false ) $page->javascript->add_script($file, array('sort'=>30));
//   $javascripts = 'checkout_payment_address.js';
  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>