<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\brief process checkout , no display  ,
 *    this file have not file child i dir content
*/

  include('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $aca_modules = new checkout_process();

  //! ne prend les redirection liée au elements que si session not null ou  post et get null block
  if (count($_SESSION)==0 || ( count($_POST)==0 && count($_GET)==0 ) ){

    $page->is_registered();

    if (!tep_session_is_registered('sendto'))  tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

    if (tep_not_null(MODULE_PAYMENT_INSTALLED) && (!tep_session_is_registered('payment')) )  tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  //! avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// load selected payment module
  $payment_modules = payment::getInstance($payment);

// load the selected shipping module
  $shipping_modules = shipping::getInstance();

  $order = new order;

  /**
    Before process module ACA
  */
  $aca_modules->before_process();

  /**
    load the before_process function from the payment modules
    Execution ligne suivante si before_process !=false
  */
  if ( ($pay_mod = $payment_modules->before_process()) == false ){

  // Search or load order total modules
    if( ($order_total_modules=$page->return_object('order_total')) ==false){
      $order_total_modules = new order_total;
      $page->add_object('order_total_modules',$order_total_modules);
    }
    /**
      Si la methode contient une redirection, le reste de de process n'est pas executés
    */
    $order_totals = $order_total_modules->process();

    $res=$aca_modules->preventDuplicate( array('order_totals'=>$order_totals,'order'=>$order) );

    $insert_id=$res['the_order_id'];
  } else {
    /**
      Execution apres le before du module
      et traitement des vars
    */
    if (isset($pay_mod) && is_array($pay_mod) ){
       $insert_id = $pay_mod['insert_id'];
       if(isset($pay_mod['order_totals'])) $order_totals= @$pay_mod['order_totals'];
    }

  }

// load the after_process function from the payment modules
  $payment_modules->after_process();
  /**
      Before process module ACA
  */
  $aca_modules->after_process();

  $cart->reset(true);

// unregister session variables used during checkout
  tep_session_unregister('sendto');
  tep_session_unregister('billto');
  tep_session_unregister('shipping');
  tep_session_unregister('comments');
  tep_session_unregister('coupon');
  tep_session_unregister('coupon_sav');

  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>