<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\brief page display choose shipping method
*/

  require('includes/application_top.php');
//   require('includes/classes/http_client.php');

  $page->init(basename(__FILE__),$language);
  $page->is_registered();


// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1)  tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

  /// Stock Check
  if (! Stock::check_cart() ) tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));

  /* reinit shipping*/
  tep_session_unregister('shipping');

  //! if no shipping destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('sendto')) {
    tep_session_register('sendto');
    $sendto = $customer_default_address_id;
  } else {
  //! verify the selected shipping address
    $check_address_query = $DB->query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$sendto . "'");
    $check_address = $check_address_query->fetchAssoc();
    if ($check_address['total'] != '1') {
      $sendto = $customer_default_address_id;
      if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');
    }
  }

  //! load order
  $order = new order;

  //! register a random ID in the session to check throughout the checkout procedure against alterations in the shopping cart contents
  if (!tep_session_is_registered('cartID')) tep_session_register('cartID');
  $cartID = $cart->cartID;

  //! if the order contains only virtual products, forward the customer to the billing page as a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $shipping = false;
    $sendto = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  //! tot cart
  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

  //! load all enabled shipping modules
  $shipping_modules = new shipping;

  //! livraison gratuite
  if (_cst_bool('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING')) {
    $pass = false;
    switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
      case 'national': if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
      case 'international': if ($order->delivery['country_id'] != STORE_COUNTRY)  $pass = true; break;
      case 'both': $pass = true; break;
    }
    $free_shipping = false;
    if ( ($pass == true) && ($order->info['total'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
      $free_shipping = true;
      include(DIR_WS_LANGUAGES . $language . '/modules/order_total/ot_shipping.php');
    }
  }
  else $free_shipping = false;

// process the selected shipping method free
  if ( isset($_POST['action']) && ($_POST['action'] == 'process') ) {
    if (!tep_session_is_registered('comments')) tep_session_register('comments');
    if (tep_not_null($_POST['comments']))  $comments = tep_db_prepare_input($_POST['comments']);

    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');

    if ( (tep_count_shipping_modules() > 0) || ($free_shipping) ) {
      if ( (isset($_POST['shipping'])) && (strpos($_POST['shipping'], '_')) ) {
        $shipping = $_POST['shipping'];
        list($module, $method) = explode('_', $shipping);
        if ( (isset($$module)&& is_object($$module))  || ($shipping == 'free_free') ) {
          if ($shipping == 'free_free') {
            $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
            $quote[0]['methods'][0]['cost'] = '0';
          } else {
            $quote = $shipping_modules->quote($method, $module);
          }
          if (isset($quote['error']))   tep_session_unregister('shipping');
          else {
            if ( (isset($quote[0]['methods'][0]['title'])) && (isset($quote[0]['methods'][0]['cost'])) ) {
              $shipping = array('id' => $shipping,
                                'title' => (($free_shipping == true) ?  $quote[0]['methods'][0]['title'] : $quote[0]['module'] . ' (' . $quote[0]['methods'][0]['title'] . ')'),
				'cost_ht' => $quote[0]['methods'][0]['cost_ht'],
                                'cost' => $quote[0]['methods'][0]['cost']);
              tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
            }
          }
        }
        else  tep_session_unregister('shipping');
        unset($shipping);
      }
    } else {

      tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
    }
  }

// get all available shipping quotes
  $quotes = $shipping_modules->quote();

// if no shipping method has been selected, automatically select the cheapest method. if the modules status was changed when none were available, to save on implementing a javascript force-selection method, also automatically select the cheapest shipping method if more than one module is now enabled
  if ( !tep_session_is_registered('shipping') || ( tep_session_is_registered('shipping') && ($shipping == false) && (tep_count_shipping_modules() > 1) ) ){
    $shipping = $shipping_modules->cheapest();
    tep_session_register('shipping');
  }

  //! bascule choose payement, si aucun module shipping dispo Et cart no physique product
  if (tep_count_shipping_modules() < 1 && $cart->get_content_type() =='virtual') tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

  $page->post_init();

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>