<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  22/01/11, 20:24
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
 *\file
 *\brief page display shipping choose and/or add address
*/

  require('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $page->is_registered();

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $shipping = false;
    if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
    $sendto = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  $error = false;
  $process = false;
  if (isset($_POST['action']) && ($_POST['action'] == 'submit')) {


    // process a new shipping address
    if (tep_not_null($_POST['firstname']) && tep_not_null($_POST['lastname']) && tep_not_null($_POST['street_address'])) {

	$cust=customer::getInstance($customer_id);
	$res=$cust->the_customer();
	$addBook=$cust->userLoadAddress($res['customers_default_address_id']);

	/// if address book not completed, update
	if(empty($addBook['entry_gender']) &&  empty($addBook['entry_street_address']) )
	  $res=$cust->userAddAddressBook($_POST, $addBook['address_book_id']);
	/// add new adress
	else
	  $res=$cust->userAddAddressBook($_POST);

        if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
        $sendto = tep_db_insert_id($res);

        if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');

        tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));

    // process the selected shipping destination
    } elseif (isset($_POST['address'])) {
      $reset_shipping = false;
      if (tep_session_is_registered('sendto')) {
        if ($sendto != $_POST['address']) {
          if (tep_session_is_registered('shipping')) {
            $reset_shipping = true;
          }
        }
      } else {
        tep_session_register('sendto');
      }

      $sendto = $_POST['address'];

      $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$sendto . "'");
      $check_address = tep_db_fetch_array($check_address_query);

      if ($check_address['total'] == '1') {
        if ($reset_shipping == true) tep_session_unregister('shipping');
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
      } else {
        tep_session_unregister('sendto');
      }
    } else {
      if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
      $sendto = $customer_default_address_id;

      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping destination address was selected, use their own address as default
  if (!tep_session_is_registered('sendto'))  $sendto = $customer_default_address_id;

  /**
    @brief load db value address book customers
    TODO: use class customer
  */
  $addresses_count = tep_count_customer_address_book_entries();

  $addresses_query = tep_db_query("select address_book_id, entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "'");

  /**
    @brief use session stocked for pre-entry forms
  */
  if(isset($_SESSION['country_id'])) $entry['country']=$_SESSION['country_id'];
  if(isset($_SESSION['state_id'])) $entry['state']=$_SESSION['state_id'];
//     $entry['lastname']=$_SESSION['customer_lastname'];
    $entry['firstname']=$_SESSION['customer_first_name'];


  $page->breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $page->post_init();

  /// script validate js
  $page->javascript->add_framework("ext/jquery/jquery.min.js");
  $page->javascript->add_script("ext/jquery/jquery.validate.min.js", array('sort'=>30));
  /// call js view last time
  $file=DIR_WS_INCLUDES.'js/checkout_address.js.php';
  if( ($file=page::fix_file($file)) && $file !=false ) $page->javascript->add_script($file, array('sort'=>30));
  //$page->add_file_header(DIR_WS_INCLUDES .  'checkout_shipping_address.js');

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>