<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/11/10, 14:33
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class common_header_tags
  Class de centralisation des modules header_tags


  NOTE:
    Centralisation des header_tag dans la table TABLE_FULL_TAG_DESCRIPTION
    Ordanceur table TABLE_FULL_TAG

    la table TABLE_FULL_TAG contient tous les tag, par type
    List type:
      content :: page cms
      product :: produits
      cat :: categories

*/


abstract class AbstractHeader_tags {

  public static $test_cache = array();
  /** Force Extending class to define this method */
  abstract protected function display_edit(&$contents);
  abstract protected function after_update($id);
  abstract protected function after_update_lang($language_id,$id);

  /**
    constrcuteur
  */
  public static function load_lang(){
    global $language,$oscss;
    if(is_object($oscss))
      $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/aca_header_tags.txt');
  }

  /**
    Attribution priorité tag / page cms surclass page fixe
    Cherche Id:  Page_xxx
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @param string $id
    @return boolean
  */
  public static function get_prio_cms($id){
    if(isset(self::$test_cache[$id])) return self::$test_cache[$id];

    $content_query = tep_db_query("select content_id from " . TABLE_CONTENT . " c where c.content_status = '1'  and c.content_name='Page_" . $id . "'   order by sort_order,content_name ASC Limit 1");
    $cnt=tep_db_fetch_array($content_query);
    $res =(tep_db_num_rows($content_query)>0)? (int)$cnt['content_id'] : false;

    return self::$test_cache[$id] = $res;
  }

  /**
    Recuperation complete db pour un type
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @param string $type
    @return object
  */
  public static function load_db_full_byType($type){
    $query = tep_db_query("SELECT * FROM " . TABLE_FULL_TAG . " ft WHERE ft.page_type='".$type."'  ");

    $array =(tep_db_num_rows($query)>0)? tep_db_fetch_array($query) : array();

    return new objectInfo($product);
  }


  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    Recup db base
  */
  public static function load_db_base($id, $type){
    $product_query = tep_db_query("SELECT * FROM " . TABLE_FULL_TAG . " ft WHERE ft.page_type='".$type."' and  ft.page_id = '" . $id . "' ");

    if(tep_db_num_rows($product_query)>0)$product = tep_db_fetch_array($product_query);
    else $product=array();

    return new objectInfo($product);
  }

  /**
    test db presence description
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @param
      @a int $tag_id
      @a int $language_id
    @return  boolean
  */
  public static function load_db_descr_check($tag_id, $language_id){
    $query = tep_db_query($sql="SELECT * FROM " . TABLE_FULL_TAG_DESCRIPTION . " ft WHERE tag_id= '" .$tag_id . "' and language_id='".$language_id."' ");
    if(tep_db_num_rows($query)>0)return true;
    else return false;
  }

  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    Recup db global
  */
  public static function load_db_values ($id, $type) {
    $languages = tep_get_languages();

    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
      $languages_id = $languages[$i]['id'];
        $product_query = tep_db_query($sql="SELECT head_title_tag, head_desc_tag, head_keywords_tag FROM " . TABLE_FULL_TAG . " ft, " . TABLE_FULL_TAG_DESCRIPTION . " ftd WHERE ft.tag_id=ftd.tag_id and ft.page_type='".$type."' and  ft.page_id = '" . $id . "' and ftd.language_id = '" . (int)$languages_id . "'");
      if(tep_db_num_rows($product_query)>0){
        $product = tep_db_fetch_array($product_query);
        $arr ['head_title_tag'][$languages_id]=$product['head_title_tag'];
        $arr ['head_desc_tag'][$languages_id]=$product['head_desc_tag'];
        $arr ['head_keywords_tag'][$languages_id]=$product['head_keywords_tag'];
      } else $arr=array();
    }

    return $arr;
  }

  /**
    Insertion d'une valeur dans la table header_tag
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @param
      @a string $action (insert|upadte)
      @a object	$pInfo
      @a int  $language_id
      @a int (int)$tag_id
  */
  public static function insert_db_values ($tag_id,$action,$pInfo,$language_id) {
    $myarray=array( 'head_title_tag' => $pInfo->header_tags['head_title_tag'][$language_id],
		    'head_desc_tag' => strip_tags(@$pInfo->header_tags['head_desc_tag'][$language_id]),
		    'head_keywords_tag' =>strip_tags(@$pInfo->header_tags['head_keywords_tag'][$language_id]));

    if($action=='update')
      tep_db_perform(TABLE_FULL_TAG_DESCRIPTION, $myarray, 'update', " tag_id='".(int)$tag_id."' and language_id='".$language_id."' " );
    else{
      $myarray['tag_id']=(int)$tag_id;
      $myarray['language_id']=$language_id;
      tep_db_perform(TABLE_FULL_TAG_DESCRIPTION, $myarray);
    }
  }

  public static function load_post_values ($post) {
  // The $post contains only post values for this module
  // pInfo is an array: [field name][language id]=value
    return new objectInfo ($post);
  }
}


?>