<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  06/02/11, 20:14
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class formUtility
*/
class formUtility {

  /**

  */
  protected static $format=array(
'image_submit'=>'<input type="submit" value="%s" title="%s"  class="%s" %s />'
		);

  static protected $id_check=array();

  private static function gener_id($id_propose){
    if(!isset(self::$id_check[$id_propose])) return self::$id_check[$id_propose]=$id_propose;
    else {
      $id=$id_propose.rand(1,3);

     return self::gener_id($id);
    }
  }

  /**
    @fn HtmlAddId($id,$name)
    @brief this function creat new id , if is exist, for W3C and id css check
    @param $id string
    @param $name string
    @return string id for css balise
  */
  private static function HtmlAddId($id,$name){
    return (!empty($id))
	    ? ' ' . 'id="' . str_replace(array('[',']'),array(''),tep_output_string(self::gener_id($id))) . '"'
	    : ' ' . 'id="' . str_replace(array('[',']'),array(''),tep_output_string(self::gener_id($name))) . '"';
  }

  /**
    @fn UpFormat($key, $format)
    @brief for update format sprintf for key , this var self::$format
    @param $key string this name function call
    @param $format new string for printf
  */
  public static function UpFormat($key, $format){
    if(isset(self::$format[$key])) self::$format[$key]=$format;
  }

  /**
    @fn image_submit($image, $alt = '', $parameters = '',$classCss='')
    @brief The HTML form submit button wrapper function
    @param $image path url image Ou texte
    @param $alt
    @param $parameters string for inline html
    @param $classCss string for css class additional
    @return string <input type="submit" title=" Mettre à jour " value="Mettre à jour" class="button" />
  */
  public static function image_submit($image='', $text = '', $parameters = '',$classCss='') {
    return sprintf(self::$format[__function__],
		    tep_output_string($text),
		    tep_output_string($text) ,
		    'button '.$classCss,
		      ' '.(tep_not_null($image)? 'src="'.$image.'" ' : '').
		      ' '.$parameters
		    );
  }


  /**
    @fn ($image, $alt = '', $params = '')
    @brief Output a function button in the selected language
    NOTE: this obsolete function
  */
  public static function image_button($image, $alt = '', $params = '') {
    global $language;
    return tep_image(DIR_WS_LANGUAGES . $language . '/images/buttons/' . $image, $alt, '', '', $params);
  }


  /**
    @brief Output a form
    @param $name name html form
    @param $action url or file
    @param $parameters param GET for file or null
    @param $method post/get
    @param $params param html
  */
  public static function draw_form($name, $action, $parameters = '', $method = 'post', $params = '') {
    $form = '<form id="' . tep_output_string($name) . '" action="';

    if( (substr($action, 0, 4 ) !='http')  ){
      if (tep_not_null($parameters))$form .= tep_href_link($action, $parameters);
      else $form .= tep_href_link($action);
    }
    else $form .=$action;

    $form .= '" method="' . tep_output_string($method) . '"';
    if (tep_not_null($params)) {
      $form .= ' ' . $params;
    }
    $form .= '>';

    return $form;
  }

  ////
  // Output a form input field
  public static function draw_input_field($name, $id='', $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true) {
    $field = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"'
	    .self::HtmlAddId($id,$name);

    if (isset($GLOBALS[$name]) && ($reinsert_value == true) && is_string($GLOBALS[$name]))   $field .= ' value="' . tep_output_string(stripslashes($GLOBALS[$name])) . '"';
    elseif (tep_not_null($value))  $field .= ' value="' . tep_output_string($value) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= ' />';

    if ($required == true) $field .= '<span class="nobr">'.TEXT_FIELD_REQUIRED.'</span>';

    return $field;
  }


  /**
    Output a selection field - alias function for tep_draw_checkbox_field() and tep_draw_radio_field()
  */
  public static function draw_selection_field($name, $id='', $type, $value = '', $checked = false, $compare = '', $parameters = '') {
    $selection = '<input type="' . tep_output_string($type) . '" name="' . tep_output_string($name) . '"'
		.self::HtmlAddId($id,$name);

    if (tep_not_null($value)) $selection .= ' value="' . tep_output_string($value) . '"';
    if ( ($checked == true) || (@$GLOBALS[$name] == 'on') || ($value && (@$GLOBALS[$name] == $value)) || ($value && ($value == $compare)) )  $selection .= ' checked="checked"';
    if (tep_not_null($parameters)) $selection .= ' ' . $parameters;
    $selection .= ' />';

    return $selection;
  }

  /**
    Output a form textarea field
  */
  public static function draw_textarea_field($name, $id = '', $width, $height, $text = '', $parameters = '', $reinsert_value = true) {
    $field = '<textarea name="' . tep_output_string($name) . '" cols="' . tep_output_string($width) . '" rows="' . tep_output_string($height) . '"'
	    .self::HtmlAddId($id,$name);

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>';
    if ( (isset($GLOBALS[$name])) && ($reinsert_value == true) )   $field .= tep_output_string_protected(stripslashes($GLOBALS[$name]));
    elseif (tep_not_null($text))$field .= tep_output_string_protected($text);
    $field .= '</textarea>';
    return $field;
  }


  /**
    Output a form hidden field
  */
  public static function draw_hidden_field($name, $id = '', $value = '', $parameters = '') {
    $field = '<input type="hidden" name="' . tep_output_string($name) . '"'
	    .self::HtmlAddId($id,$name);

    if (tep_not_null($value))  $field .= ' value="' . tep_output_string($value) . '"';
    elseif (isset($GLOBALS[$name]) && is_string($GLOBALS[$name]))  $field .= ' value="' . tep_output_string(stripslashes($GLOBALS[$name])) . '"';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= ' />';
    return $field;
  }

  /**
    Output a form pull down menu
  */
  public static function draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
    if (!preg_match('/id=/i',$parameters)) $field = '<select id="' . str_replace(array('[',']'),array(''),tep_output_string($name)) . '" name="' . tep_output_string($name) . '" ';
    else $field = '<select  name="' . tep_output_string($name) . '" ';

    if (tep_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>';
    if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes((string)$GLOBALS[$name]);

    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id'])  $field .= ' selected="selected"';
      $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
    $field .= '</select>';

    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

  /**
    Output a form pull down menu on radio set
  */
  public static function draw_pull_down_radio($name, $id= '',$values, $default = '', $parameters = '', $required = false) {
    $field = '<ul>'."\n";
    if (!tep_not_null($id))  $id=tep_output_string($name);
    if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);
    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .=tep_draw_radio_field($name, $id.$i, tep_output_string($values[$i]['id']),( ($default == $values[$i]['id'])? true:false), $parameters);
      $field .= $values[$i]['text'] . '&nbsp;';
    }
    $field .= '</ul>';
    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }

  /**
    Output a form pull down menu on radio set
  */
  public static function draw_pull_down_checkbox($name, $id= '',$values, $default = '', $parameters = '', $required = false) {
    $field = '<ul>'."\n";
    if (!tep_not_null($id))  $id=tep_output_string($name);
    if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);
    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .=tep_draw_checkbox_field($name, $id.$i, tep_output_string($values[$i]['id']),( ($default == $values[$i]['id'])? true:false), $parameters);
      $field .= $values[$i]['text'] . '&nbsp;';
    }
    $field .= '</ul>';
    if ($required == true) $field .= TEXT_FIELD_REQUIRED;

    return $field;
  }


}
?>