<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  03/03/11, 15:51
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class language
  @brief load langue
*/

class language {
  public $languages;
  public $catalog_languages;
  public $browser_languages;
  public $language;

  /**
    @var $languages_selected string code langue sleectionné
  */
  public static $languages_selected;
  /**
    @var $languages_array array tableau des langue dipspo mise en cache
  */
  private static $languages_array=array();

  /**
    @brief construct
  */
  function __construct($lng = '') {
    $this->languages = array('ar' => 'ar([-_][[:alpha:]]{2})?|arabic',
			      'bg' => 'bg|bulgarian',
			      'br' => 'pt[-_]br|brazilian portuguese',
			      'ca' => 'ca|catalan',
			      'cs' => 'cs|czech',
			      'da' => 'da|danish',
			      'de' => 'de([-_][[:alpha:]]{2})?|german',
			      'el' => 'el|greek',
			      'en' => 'en([-_][[:alpha:]]{2})?|english',
			      'es' => 'es([-_][[:alpha:]]{2})?|spanish',
			      'et' => 'et|estonian',
			      'fi' => 'fi|finnish',
			      'fr' => 'fr([-_][[:alpha:]]{2})?|french',
			      'gl' => 'gl|galician',
			      'he' => 'he|hebrew',
			      'hu' => 'hu|hungarian',
			      'id' => 'id|indonesian',
			      'it' => 'it|italian',
			      'ja' => 'ja|japanese',
			      'ko' => 'ko|korean',
			      'ka' => 'ka|georgian',
			      'lt' => 'lt|lithuanian',
			      'lv' => 'lv|latvian',
			      'nl' => 'nl([-_][[:alpha:]]{2})?|dutch',
			      'no' => 'no|norwegian',
			      'pl' => 'pl|polish',
			      'pt' => 'pt([-_][[:alpha:]]{2})?|portuguese',
			      'ro' => 'ro|romanian',
			      'ru' => 'ru|russian',
			      'sk' => 'sk|slovak',
			      'sr' => 'sr|serbian',
			      'sv' => 'sv|swedish',
			      'th' => 'th|thai',
			      'tr' => 'tr|turkish',
			      'uk' => 'uk|ukrainian',
			      'tw' => 'zh[-_]tw|chinese traditional',
			      'zh' => 'zh|chinese simplified');

    $this->catalog_languages = self::get_languages(true);
    $this->browser_languages = '';
    $this->language = '';

    $this->set_language($lng);
  }

  /**
    @fn set_language($lng)
    @brief defini la lanque choisie
    @param $lng string code iso 2
  */
  public function set_language($lng) {
    if ( (tep_not_null($lng)) && (isset($this->catalog_languages[$lng])) ) $language = $lng;
    else $language = DEFAULT_LANGUAGE;

    $this->language = $this->catalog_languages[$language];
    self::$languages_selected = $this->language['code'];
  }

  /**
    @fn get_browser_language()
    @brief Recuperation de la langue do broswer
  */
  public function get_browser_language() {
    $this->browser_languages = explode(',', getenv('HTTP_ACCEPT_LANGUAGE'));

    for ($i=0, $n=sizeof($this->browser_languages); $i<$n; $i++) {
      reset($this->languages);
      while (list($key, $value) = each($this->languages)) {
	if (preg_match('/^(' . $value . ')(;q=[0-9]\\.[0-9])?$/i', $this->browser_languages[$i]) && isset($this->catalog_languages[$key])) {
	  $this->set_language($key);
	  break 2;
	}
      }
    }
  }

  /**
    @fn LangueSelected()
    @return langue code
  */
  public static function LangueSelected(){
    return (isset($_SESSION['language_iso'])? $_SESSION['language_iso'] : self::$languages_selected);
  }

  /**
    @fn ArrayPullDown($byindex=false, $public=true)
    @brief gestiné au pulldown
    @param $byindex
    @param $public
  */
  public static function ArrayPullDown($byindex=false, $public=true){
    global $language;
    $languages=self::get_languages($byindex,$public);
    $languages_array=array();
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
	$languages_array[] = array('id' => $languages[$i]['code'], 'text' => $languages[$i]['name']);
	if ($languages[$i]['code'] == $language ) self::$languages_selected = $languages[$i]['code'];
    }

    return $languages_array;
  }

  /**
    @fn get_languages($byindex=false, $public=true)
    @param $byindex bool precise l'Id dans la clef de colonne
    @param $public bool precise check public / prive
  */
  public static function get_languages($byindex=false, $public=true) {
    $CORE=(!$public)? 'BO' : 'FO';
    $ind=(($byindex)?'index':'noindex');
    if(!isset(self::$languages_array[$CORE][$ind]) || count(self::$languages_array[$CORE][$ind])==0) {
      $DB=Database::getInstance();
      $i=0;
      $lg_array=array();
      $languages_query = $DB->query("select languages_id, name, code, image, directory from " . TABLE_LANGUAGES . " order by sort_order");
      while ($languages = $languages_query->fetchAssoc() ) {
	if(self::check_langue($languages['directory'],$public) )
	  $lg_array[(($byindex)?$languages['code']:$i++)] = array('id' => $languages['languages_id'],
								'name' => $languages['name'],
								'code' => $languages['code'],
								'image' => $languages['image'],
								'directory' => $languages['directory'],
								'directory_code2'=>$languages['code'].'_'.strtoupper($languages['code'])
								  );
      }
      self::$languages_array[$CORE][$ind]=$lg_array;
    }
    else
      $lg_array = self::$languages_array[$CORE][$ind];

    return $lg_array;
  }

  /**
    @fn check_langue($directory,$public)
    @brief Verifié si le repertoire est présent
    @param $directory string path
    @param $public boolean false =admin
    @return boolean
  */
  private static function check_langue($directory,$public){
    $base=(!$public)? DIR_FS_ADMIN : DIR_FS_CATALOG ;
    if(is_dir($base.DIR_WS_LANGUAGES.$directory)) return true;
    return false;
  }
}
?>