<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  07/02/11, 13:07
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
 *\class notification
  @brief cette class est a cheval entre front et backoffice.
    UTilise les class des admins
*/



class notification {

  const TABLE = TABLE_NOTIFICATION;

  const ADMIN_TABLE_NOTIF = TABLE_ADMIN_NOTIFICATION;

  /**
    @var conf array des alert de key
  */
  protected static $conf;

  /**
    @var key de notification string
  */
  protected static $key;

  /**
    @brief load conf key
    @param key string
  */
  protected static function loadConf($key){
    $DB=Database::getInstance();
    $r=$DB->query("select * from ".self::TABLE." where chknotif_key='".(string)$key."' " );

    self::$conf=$r->fetchAllAssoc();
  }


  /**
    @fn methode($subjet,$myarray,$data)
    @brief exe notif
    @param $subjet string
    @param $myarray array for email array
    @param $data string (GET) info supp for trace and link
    @param $message_final string
  */
  protected static function methode($subjet,$myarray='',$data,$message_final=''){
    global $language;

    $DB=Database::getInstance();

    if(empty($message_final)) $message_final=tep_post_prepare_email(self::$key.'.tpl',$language,$myarray);

    foreach(self::$conf as $item){
      switch($item['chknotif_method']) {
	case 'sql' :

	  $DB->query($sql="INSERT INTO  ".self::ADMIN_TABLE_NOTIF." (notif_id,notif_type,user_id,notif_key,notif_data,notif_text, notif_date) VALUES ('',0,'".(int)$item['chknotif_user']."', '".self::$key."','".tep_db_input($data)."','".tep_db_input($message_final['html'])."' ,now() )  " );

	break;

	case 'email':
	default:
	  $r=$DB->query("select admin_firstname as firstname, admin_lastname as lastname, admin_email_address as email from ".TABLE_ADMIN." where admin_id='".(int)$item['chknotif_user']."' " );

	  $admin=$r->fetchAssoc();
	  tep_mail($admin['firstname'].'  '.$admin['lastname'], $admin['email'], $subjet, $message_final, STORE_OWNER, EMAIL_FROM);
      }
    }
  }

  /**
    @brief public call notif
      notification::notif($key,$subjet,$myarray,$data)
    @param $key string
    @param $subjet string
    @param $myarray array
    @param $data string GET
  */
  public static function notif($key,$subjet,$myarray,$data){
    self::$key=$key;

    self::loadConf($key);


    if(function_exists('tep_get_ip_address'))$data .='&ip='.tep_get_ip_address();

    self::methode($subjet,$myarray,$data);
  }

  /**
    @brief public call notif and pass direct message
      notification::notif($key,$subjet,$myarray,$data)
    @param $key string
    @param $subjet string
    @param $message_final string
    @param $data string GET
  */
  public static function notifInMess($key,$subjet,$message_final,$data){
    self::$key=$key;

    self::loadConf($key);

    if(function_exists('tep_get_ip_address'))$data .='&ip='.tep_get_ip_address();

    self::methode($subjet,'',$data, array('html'=>(is_array($message_final) ? $message_final['html']: $message_final)));
  }
}


/**
CREATE TABLE IF NOT EXISTS osc_admin_notification (
  notif_id int(11) NOT NULL auto_increment,
  notif_type varchar(10) NOT NULL COMMENT 'user/group',
  user_id int(11) NOT NULL,
  notif_key varchar(100) NOT NULL,
  notif_data varchar(250) NOT NULL,
  notif_text text NOT NULL,
  PRIMARY KEY  (notif_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS osc_checknotif (
  chknotif_id int(11) NOT NULL auto_increment,
  chknotif_key varchar(100) NOT NULL,
  chknotif_uniq int(1) NOT NULL COMMENT 'user=0/grp=1',
  chknotif_user int(11) NOT NULL COMMENT 'if chknotif_uniq this = grp_id',
  chknotif_status int(1) NOT NULL,
  chknotif_method varchar(15) NOT NULL default 'email',
  PRIMARY KEY  (chknotif_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table osc_checknotif
--

INSERT INTO osc_checknotif (chknotif_id, chknotif_key, chknotif_uniq, chknotif_user, chknotif_status) VALUES
(1, 'create_account', 0, 1, 1);
*/

?>