<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  29/11/10, 11:33
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class osCSS_Cache
  \brief Class usage examples:

  \example Caching HTML:
    if ($osCSS_Cache->read('key', 60) === false) {
      $osCSS_Cache->startBuffer();
      ------ PHP/HTML LOGIC HERE ------
      $osCSS_Cache->stopBuffer();
    }

    echo $osCSS_Cache->getCache();

  \example Caching data (in memory):
    if ($osCSS_Cache->read('key', 60)) {
      $variable = $osCSS_Cache->getCache();
    } else {
      $variable = array('some', 'data');

      $osCSS_Cache->writeBuffer($variable);
    }
*/

class osCSS_Cache {
  protected $cached_data;

  protected $cache_key;

  protected static $_instance;

  protected static $_folder;

  function __construct(){
    $this->cached_data=null;
    $this->cache_key=null;
    self::$_folder=(defined('DIR_WS_ADMIN')? DIR_FS_ADMIN.DIR_WS_INCLUDES.'tmp/cache/' : DIR_FS_WORK);
  }

  private static function write($key, $data, $force=false) {

    if(!$force && OSCSS_DEBUG ===true) return false;

    $filename = self::$_folder . $key . '.cache';

    if ($fp = @fopen($filename, 'w')) {
      flock($fp, 2); // LOCK_EX
      fputs($fp, serialize($data));
      flock($fp, 3); // LOCK_UN
      fclose($fp);

      return true;
    }

    return false;
  }

  public function read($key, $expire = 0, $force=false) {
    self::$_instance = new self();

    if(!$force && OSCSS_DEBUG ===true) return false;

    $this->cache_key = $key;

    $filename = self::$_folder . $key . '.cache';

    if (file_exists($filename)) {
      $difference = floor((time() - filemtime($filename)) / 60);

      if ( ($expire == '0') || ($difference < $expire) ) {
	if ($fp = @fopen($filename, 'r')) {
	  $this->cached_data = @unserialize(fread($fp, filesize($filename)));

	  fclose($fp);

	  return true;
	}
      }
    }

    return false;
  }

  public function getCache() {
    return $this->cached_data;
  }

  public function startBuffer() {
    ob_start();
  }

  public function stopBuffer() {
    $this->cached_data = ob_get_contents();

    ob_end_clean();

    self::write($this->cache_key, $this->cached_data);
    self::$_instance = null;
  }

  public function writeBuffer($data, $force=false) {
    $this->cached_data = $data;

    self::write($this->cache_key, $this->cached_data,$force);
  }

  /**
    @param $key string key base du nom des fichier a supprimer
    @param $core bool core false = public, true = admin
  */
  public static function clear($key, $core=false) {
    $key_length = strlen($key);

    $folder=(($core)? DIR_FS_ADMIN.DIR_WS_INCLUDES.'tmp/cache/' : DIR_FS_WORK);

    $d = dir($folder);
    if(is_object($d)){
      while ($entry = $d->read()) {
	if ((strlen($entry) >= $key_length) && (substr($entry, 0, $key_length) == $key)) {
	  unlink($folder . $entry);
	}
      }

      $d->close();
    }
  }
}
?>