<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  26/09/10, 21:31
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class CacheLib

  Mise en cache de libraririe et class
*/

class CacheLib {

  protected static $cache_key;

  protected static $_instance;

  protected static  $folder;

  protected function __construct(){
    self::$cache_key = null;
    self::$folder=(defined('DIR_WS_ADMIN')? DIR_FS_ADMIN.DIR_WS_INCLUDES.'tmp/cache/' : DIR_FS_WORK);
  }

  public static function read($key, $expire = 0) {
    self::$_instance = new self();

    self::$cache_key = $key;

    $filename = self::$folder . $key . '.cache';

    if (file_exists($filename) && (OSCSS_DEBUG == false) ) {
      $difference = floor((time() - filemtime($filename)) / 60);

      if ( ($expire == '0') || ($difference < $expire) ) {
	return true;
      }
    }

    return false;
  }

  public static function addfiles($file=array()){
    $filename = self::$folder . self::$cache_key . '.cache';

    $fp=fopen($filename,'w');
    flock($fp, 2); // LOCK_EX
    foreach($file as $item) {
      if(file_exists($item))fputs($fp, file_get_contents($item));
    }
    flock($fp, 3); // LOCK_UN
    fclose($fp);
  }

  public static function getfilecache(){
    return  self::$folder . self::$cache_key . '.cache';
  }
}
?>