<?php  if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  13/03/11, 08:54
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class osCSS_pdf
*/
class osCSS_pdf {

  protected static $_instance;

  /**
    @var string result pull down choose modele pdf_output
  */
  public static $type;

  /**
    @var num page
  */
  public static $numPage=0;

  /**
    @var object instante class fpdf
  */
  public static $pdf;

  /**
    PHP 5 Constructor
  */
  private function __construct(){

    define('BATCH_PRINT_INC', DIR_WS_MODULES . 'template_pdf/');
    define('BATCH_PDF_DIR', DIR_WS_INCLUDES . 'tmp/');
    define('FPDF_FONTPATH',DIR_FS_CATALOG.DIR_WS_COMMON_FONTS);


    require_once(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES.'fpdf.php');
    require_once(DIR_FS_CATALOG.DIR_WS_COMMON_FUNCTIONS.'pdf_output.php');

    define('LOGO_SHOP_FOR_PRINT',HTTP_SERVER.str_replace('//','/',STORE_LOGO_PRINT));

//     tep_image(LOGO_SHOP_FOR_PRINT,'',150,150);

  }


  public static function getInstance() {
      if(self::$_instance == null) {
    self::$_instance = new self();
      }
      return self::$_instance;
  }

  public static function resetInstance() {
      self::$_instance = null;
      return self::getInstance();
  }

  /**
    @brief call file lang specific module
  */
  private static function filelang(){
    global $oscss,$language;

    /// BO
    if(is_object($oscss))
      $oscss->pile_file_lang(DIR_FS_ADMIN.DIR_WS_LANGUAGES.$language.'/modules/template_pdf/'.self::$type.'.txt');

    /// FO
    global $page;
    if(is_object($page))
      if(($path=page::fix_file(DIR_WS_LANGUAGES . $language .'/modules/template_pdf/'.self::$type.'.txt',true)) !=false) $this->pile_file_lang($path);
  }


  /**
    @brief init output pdf
    @param type string name of template module pdf s
  */
  public static function OutputInit($type){
    self::$type = $type;

    self::filelang();

    if($type=='labels')self::$pdf=new PDF_label();
    else self::$pdf=new PDF();

    self::$pdf->SetMargins(6,2,6);

    return self::$pdf;
  }

  public static function OutputAddPage(){
    if (self::$numPage > 0) self::$pdf->AddPage();
    self::$numPage++;
    return self::$numPage;
  }

  public static function OutputEnd(){
    $pdf_code = self::$pdf->output();
    exit;
  }

  /**
    @fn getPathModele()
    @brief return path module pdf
  */
  public static function getPathModele(){
    return DIR_WS_MODULES . 'template_pdf/' . self::$type.'.php';
  }


  /**
    @brief call module present for pdf
    @param $pull_down boolean , format for pull down menu, or just array
  */
  public static function get_module($pull_down=true){
    global $messageStack;
    if (!is_dir(BATCH_PRINT_INC)) $messageStack->add_session(sprintf(__("error problem opening directory %s  "),BATCH_PRINT_INC), 'error');

    $file_type_array = array();
    foreach(scan(BATCH_PRINT_INC) as $file) {
	$ext = strrchr($file, ".");
	if ($ext == ".php")
	  if($pull_down) $file_type_array[] = array('id' => substr($file,0,-4),'text' => __('BP template '.str_replace(array('-'),array("_"),substr($file,0,-4))));
	  else $file_type_array[] = substr($file,0,-4);
    }
    return $file_type_array;
  }

}
?>