<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  13/06/10, 11:26
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/



class DB_Mysql extends database{

  /**
    * List tables query
    * @var string
    */
  protected $strListTables = "SHOW TABLES FROM `%s`";

  /**
    * List fields query
    * @var string
    */
  protected $strListFields = "SHOW COLUMNS FROM `%s`";

  /**
    Connection ID
    @var resource
  */
  protected $resConnection;

  /**
    * Connect to database server and select database
    */
  protected function connect() {
    $strHost = parent::HOST;

    if (parent::PORT) $strHost .= ':' . parent::PORT;

    if (parent::PCONNECT =='true')$this->resConnection = @mysql_pconnect($strHost, parent::USER, parent::PASS);
    else $this->resConnection = @mysql_connect($strHost, parent::USER, parent::PASS);

    if (is_resource($this->resConnection))
    {
	    @mysql_query("SET sql_mode=''", $this->resConnection);
	    @mysql_query("SET NAMES " . parent::CHARSET, $this->resConnection);
	    @mysql_select_db(parent::DB, $this->resConnection);
    }
  }


  /**
    Disconnect from database
  */
  protected function disconnect() {
    @mysql_close($this->resConnection);
  }


  /**
    * Return the last error message
    * @return string
    */
  protected function get_error() {
    if (is_resource($this->resConnection)) return mysql_error($this->resConnection);

    return mysql_error();
  }


	/**
	 * Return a standardized array with field information
	 *
	 * Standardized format:
	 * - name:       field name (e.g. my_field)
	 * - type:       field type (e.g. "int" or "number")
	 * - length:     field length (e.g. 20)
	 * - precision:  precision of a float number (e.g. 5)
	 * - null:       NULL or NOT NULL
	 * - default:    default value (e.g. "default_value")
	 * - attributes: attributes (e.g. "unsigned")
	 * - index:      PRIMARY, UNIQUE or INDEX
	 * - extra:      extra information (e.g. auto_increment)
	 * @param string
	 * @return string
	 * @todo Support all kind of keys (e.g. FULLTEXT or FOREIGN).
	 */
	protected function list_fields($strTable)
	{
		$arrReturn = array();
		$arrFields_query = mysql_query(sprintf($this->strListFields, $strTable), $this->resConnection) ; /*->fetchAllAssoc() ;*/

		while ($arrF = mysql_fetch_assoc($arrFields_query))
		  $arrFields[]=$arrF;


		foreach ($arrFields as $k=>$v)
		{
			$arrChunks = preg_split('/(\([^\)]+\))/', $v['Type'], -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY);
// print_r($arrChunks);
			$arrReturn[$k]['name'] = $v['Field'];
			$arrReturn[$k]['type'] = $arrChunks[0];

			if (isset($arrChunks[1]) &&  strlen($arrChunks[1]))
			{
				$arrChunks[1] = str_replace(array('(', ')'), array('', ''), $arrChunks[1]);
				$arrSubChunks = explode(',', $arrChunks[1]);

				$arrReturn[$k]['length'] = trim($arrSubChunks[0]);

				if (isset($arrSubChunks[1]) && strlen($arrSubChunks[1]))
				{
					$arrReturn[$k]['precision'] = trim($arrSubChunks[1]);
				}
			}

			if (isset($arrSubChunks[2]) && strlen($arrChunks[2]))
			{
				$arrReturn[$k]['attributes'] = trim($arrChunks[2]);
			}

			if (strlen($v['Key']))
			{
				switch ($v['Key'])
				{
					case 'PRI':
						$arrReturn[$k]['index'] = 'PRIMARY';
						break;

					case 'UNI':
						$arrReturn[$k]['index'] = 'UNIQUE';
						break;

					default:
						$arrReturn[$k]['index'] = 'KEY';
						break;
				}
			}

			$arrReturn[$k]['null'] = ($v['Null'] == 'YES') ? 'NULL' : 'NOT NULL';
			$arrReturn[$k]['default'] = $v['Default'];
			$arrReturn[$k]['extra'] = $v['Extra'];
		}

		return $arrReturn;
	}


	/**
	 * Change the current database
	 * @param  string
	 * @return boolean
	 */
	protected function set_database($strDatabase)
	{
		return @mysql_select_db($strDatabase, $this->resConnection);
	}


	/**
	 * Begin a transaction
	 */
	protected function begin_transaction()
	{
		@mysql_query("SET AUTOCOMMIT=0", $this->resConnection);
		@mysql_query("BEGIN", $this->resConnection);
	}


	/**
	 * Commit a transaction
	 */
	protected function commit_transaction()
	{
		@mysql_query("COMMIT", $this->resConnection);
		@mysql_query("SET AUTOCOMMIT=1", $this->resConnection);
	}


	/**
	 * Rollback a transaction
	 */
	protected function rollback_transaction()
	{
		@mysql_query("ROLLBACK", $this->resConnection);
		@mysql_query("SET AUTOCOMMIT=1", $this->resConnection);
	}

	/**
	  Alias retro-compatibilité
	*/
	public function db_input($strString)
	{
		return  mysql_real_escape_string($strString, $this->resConnection) ;
	}
}


/**
 * Class DB_Mysql_Statement
 *
 * Driver class for MySQL databases.
 * @copyright  Leo Feyer 2005-2010
 * @author     Leo Feyer <http://www.typolight.org>
 * @package    Driver
 */
class DB_Mysql_Statement extends Database_Statement
{

	/**
	 * Prepare a query and return it
	 * @param string
	 * @return string
	 */
	protected function prepare_query($strQuery)
	{
		return $strQuery;
	}

	/**
	 * Escape a string
	 * @param  string
	 * @return string
	 */
	protected function string_escape($strString)
	{
		return "'" . mysql_real_escape_string($strString, $this->resConnection) . "'";
	}


	/**
	 * Limit the current query
	 * @param int
	 * @param int
	 */
	protected function limit_query($intRows, $intOffset)
	{
		$strType = strtoupper(preg_replace('/\s+.*$/is', '', trim($this->strQuery)));

		switch ($strType)
		{
			case 'SELECT':
				$this->strQuery .= sprintf(' LIMIT %d,%d', $intOffset, $intRows);
				break;

			default:
				$this->strQuery .= sprintf(' LIMIT %d', $intRows);
				break;
		}
	}


	/**
	 * Execute the current query
	 * @return resource
	 */
	protected function execute_query()
	{
		return @mysql_query($this->strQuery, $this->resConnection);
	}


	/**
	 * Return the last error message
	 * @return string
	 */
	protected function get_error()
	{
// 	    throw new Exception(sprintf("Mysql Error n°::%s  \nRessource:: (%s)  \ndetail::%s".mysql_errno().mysql_error(),$this->resConnection));
// 		return mysql_error($this->resConnection);
	    oscss_db_error($this->strQuery, mysql_errno(), mysql_error());
	}


	/**
	 * Return the number of affected rows
	 * @return int
	 */
	protected function affected_rows()
	{
		return @mysql_affected_rows($this->resConnection);
	}


	/**
	 * Return the last insert ID
	 * @return int
	 */
	protected function insert_id()
	{
		return @mysql_insert_id($this->resConnection);
	}


	/**
	 * Explain the current query
	 * @return array
	 */
	protected function explain_query()
	{
		return @mysql_fetch_assoc(@mysql_query('EXPLAIN ' . $this->strQuery, $this->resConnection));
	}
}


/**
 * Class DB_Mysql_Result
 *
 * Driver class for MySQL databases.
 * @copyright  Leo Feyer 2005-2010
 * @author     Leo Feyer <http://www.typolight.org>
 * @package    Driver
 */
class DB_Mysql_Result extends Database_Result
{

	/**
	 * Fetch the current row as enumerated array
	 * @return array
	 */
	protected function fetch_row()
	{
		return @mysql_fetch_row($this->resResult);
	}


	/**
	 * Fetch the current row as associative array
	 * @return array
	 */
	protected function fetch_assoc()
	{
		return @mysql_fetch_assoc($this->resResult);
	}


	/**
	 * Return the number of rows of the current result
	 * @return int
	 */
	protected function num_rows()
	{
		return @mysql_num_rows($this->resResult);
	}


	/**
	 * Return the number of fields of the current result
	 * @return int
	 */
	protected function num_fields()
	{
		return @mysql_num_fields($this->resResult);
	}


	/**
	 * Get column information
	 * @param  int
	 * @return object
	 */
	protected function fetch_field($intOffset)
	{
		return @mysql_fetch_field($this->resResult, $intOffset);
	}


	/**
	 * Free the current result
	 */
	public function free()
	{
		if (is_resource($this->resResult))
		{
			@mysql_free_result($this->resResult);
		}
	}
}

?>