<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/11/10, 13:29
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  Retro_compatibilité
*/

function tep_db_output($string) {
  return htmlspecialchars($string);
}




function tep_db_prepare_input($string) {
  if (is_string($string)) {
    return trim(stripslashes($string));
  } elseif (is_array($string)) {
    reset($string);
    while (list($key, $value) = each($string)) {
      $string[$key] = tep_db_prepare_input($value);
    }
    return $string;
  } else {
    return $string;
  }
}


function oscss_db_error($query, $errno, $error) {

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html dir="ltr">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET ?>" />
<title>Error</title>
<style type="text/css">
<!--
BODY {margin: 10% 20% auto 20%; font: 10px verdana, arial, helvetica, sans-serif}
#errorbox {border: 1px solid #b84623}
H2 {margin: 0; color: #ffffff; background-color: #b84623; font-size: 1.1em; padding: 5px 4px}
#errorbox DIV {padding: 6px 5px; background-color: #FFEFCE}
-->
</style>
</head>
<body>

<div id="errorbox">
	<h2>Error</h2>
	<div>
	<?php echo "\t\t".'<br /><br /><strong>Database reported:</strong> '.htmlspecialchars($error).(($errno) ? ' (Errno: '.$errno.')' : '')."\n";
	      if ( OSCSS_SHOW_QUERIES == true ) { echo "\t\t".'<br /><br /><strong>Failed query:</strong> '.htmlspecialchars($query)."\n"; } ?>
	</div>
</div>

</body>
</html>
<?php
	die;
}


/** Log appel element obsolété */
function tep_db_connect() { trigger_error(sprintf(__FUNCTION__.' obsolete %s', ''), E_USER_ERROR); }
function tep_db_close($link = 'db_link') { trigger_error(sprintf(__FUNCTION__.' obsolete %s', ''), E_USER_ERROR); }
function tep_db_data_seek($db_query, $row_number) {trigger_error(sprintf(__FUNCTION__.' obsolete %s', ''), E_USER_ERROR); }

 /** Retro-compatibilité */
function tep_db_query($query, $link = 'db_link') {
  $DB=Database::getInstance();
  if(_cst_bool('STORE_DB_TRANSACTIONS')){
    $time_start = explode(' ', microtime());
    $RESULT=$DB->query($query);
    $time_end = explode(' ', microtime());
    $parse_time = number_format(($time_end[1] + $time_end[0] - ($time_start[1] + $time_start[0])), 6);
    trigger_error(sprintf(__FUNCTION__.' [Sql] '.$parse_time.' %s', $query), E_USER_ERROR);
    return $RESULT;
  }
  else
    return $DB->query($query);
}
function tep_db_perform($table, $data, $action = 'insert', $parameters = '') {
  $DB=Database::getInstance();

  reset($data);
  if ($action == 'insert') {
    $query = 'INSERT INTO `' . $table . '` (';
    while (list($columns, ) = each($data)) {
	  $query .= '`' . $columns . '`, ';
    }
    $query = substr($query, 0, -2) . ') values (';
    reset($data);
    while (list(, $value) = each($data)) {
	  switch ((string)$value) {
	    case 'now()':
		  $query .= 'now(), ';
		  break;
	    case 'null':
		  $query .= 'null, ';
		  break;
	    default:
		  $query .= "'" . tep_db_input($value) . "', ";
		  break;
	  }
    }
    $query = substr($query, 0, -2) . ')';
  } elseif ($action == 'update') {
    $query = 'UPDATE `' . $table . '` SET ';
    while (list($columns, $value) = each($data)) {
	  switch ((string)$value) {
	    case 'now()':
		  $query .= '`' .$columns . '`=now(), ';
		  break;
	    case 'null':
		  $query .= '`' .$columns .= '`=null, ';
		  break;
	    default:
		  $query .= '`' .$columns . "`='" . tep_db_input($value) . "', ";
		  break;
	  }
    }
    $query = substr($query, 0, -2) . ' WHERE ' . $parameters . ';';
  }
  if(_cst_bool('STORE_DB_TRANSACTIONS')){
    $time_start = explode(' ', microtime());
    $RESULT=$DB->query($query);
    $time_end = explode(' ', microtime());
    $parse_time = number_format(($time_end[1] + $time_end[0] - ($time_start[1] + $time_start[0])), 3);
    trigger_error(sprintf(__FUNCTION__.' [Sql] '.$parse_time.' %s', $query), E_USER_ERROR);
    return $RESULT;
  }
  else
    return $DB->query($query);
}
function tep_db_input($string) { $DB=Database::getInstance(); return $DB->db_input($string); }
function tep_db_free_result($rId) {  return $rId->__destruct(); }
function tep_db_fetch_fields($rId) { return $rId->fetch_field(); }
function tep_db_fetch_array($rId) { return $rId->fetchAssoc(); }
function tep_db_num_rows($rId) { return $rId->__get('numRows'); }
function tep_db_insert_id($rId) { return $rId->__get('insertId'); }

?>