<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  30/05/10, 19:28
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/


/**
  @package oscss-Codev <www http://www.oscss.org>
  @author oscim - <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  Generation des element d'entete et footer pour les BL et facture
*/
class PDF extends FPDF {
//Page header
  function RoundedRect($x, $y, $w, $h,$r, $style = '') {
    $k = $this->k;
    $hp = $this->h;
    if($style=='F')
        $op='f';
    elseif($style=='FD' or $style=='DF')
        $op='B';
    else
        $op='S';
    $MyArc = 4/3 * (sqrt(2) - 1);
    $this->_out(sprintf('%.2f %.2f m',($x+$r)*$k,($hp-$y)*$k ));
    $xc = $x+$w-$r ;
    $yc = $y+$r;
    $this->_out(sprintf('%.2f %.2f l', $xc*$k,($hp-$y)*$k ));

    $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
    $xc = $x+$w-$r ;
    $yc = $y+$h-$r;
    $this->_out(sprintf('%.2f %.2f l',($x+$w)*$k,($hp-$yc)*$k));
    $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
    $xc = $x+$r ;
    $yc = $y+$h-$r;
    $this->_out(sprintf('%.2f %.2f l',$xc*$k,($hp-($y+$h))*$k));
    $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
    $xc = $x+$r ;
    $yc = $y+$r;
    $this->_out(sprintf('%.2f %.2f l',($x)*$k,($hp-$yc)*$k ));
    $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
    $this->_out($op);
  }

  function _Arc($x1, $y1, $x2, $y2, $x3, $y3){
    $h = $this->h;
    $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c ', $x1*$this->k, ($h-$y1)*$this->k,
    $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
  }


  function Header(){
    global $oID;
      $date = strftime('%A, %d %B %Y');
    //Logo + link shop
      $this->Image(HTTP_SERVER.STORE_LOGO_PRINT,5,10,50,0,'',HTTP_SERVER.DIR_WS_CATALOG);

    // Company Address
      $this->SetX(0);
      $this->SetY(10);
      $this->SetFont('Arial','B',10);
      $this->SetTextColor(158,11,14);
      $this->Ln(0);
      $this->Cell(123);
      $this->MultiCell(100, 3.5, tep_correct_entitie_put_pdf(STORE_NAME_ADDRESS),0,'L');

    //email
      $this->SetX(0);
      $this->SetY(35);
      $this->SetFont('Arial','B',10);
      $this->SetTextColor(158,11,14);
      $this->Ln(0);
      $this->Cell(123);
      $this->Cell(100, 6, "E-mail: " . STORE_OWNER_EMAIL_ADDRESS,0,'L');

    //website url
      $this->SetX(0);
      $this->SetY(42);
      $this->SetFont('Arial','B',10);
      $this->SetTextColor(158,11,14);
      $this->Ln(0);
      $this->Cell(123);
      $this->Cell(100, 6, "Web: " . HTTP_SERVER,0,'L');

  }

  function Footer()  {
    $y=-17;
    $this->SetX(0);
    //Arial italic 8
    $this->SetFont('Arial','',6);
    $this->SetFillColor(255);
    foreach(explode("\n",STORE_LEGAL_INFO) as $lg){
      $this->SetY($y);
      $this->Cell(0,3,tep_correct_entitie_put_pdf($lg),0,0,'C');
      $y = $y +3;
    }
  }

  function WriteHTML($html) {
    //Parseur HTML
    $html=str_replace("\n",' ',$html);
    $a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
    foreach($a as $i=>$e) {
      if($i%2==0) {
          if(isset($this->HREF))  $this->PutLink($this->HREF,$e);
          else $this->Write(5,$e);
      }
      else {
        //Balise
        if($e[0]=='/') $this->CloseTag(strtoupper(substr($e,1)));
        else {
          //Extraction des attributs
          $a2=explode(' ',$e);
          $tag=strtoupper(array_shift($a2));
          $attr=array();
          foreach($a2 as $v)
              if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3)) $attr[strtoupper($a3[1])]=$a3[2];

          $this->OpenTag($tag,$attr);
        }
      }
    }
  }

  function OpenTag($tag,$attr){
    //Balise ouvrante
    if($tag=='B' || $tag=='I' || $tag=='U') $this->SetStyle($tag,true);
    if($tag=='A') $this->HREF=$attr['HREF'];
    if($tag=='BR') $this->Ln(5);
  }

  function CloseTag($tag){
    //Balise fermante
    if($tag=='B' || $tag=='I' || $tag=='U') $this->SetStyle($tag,false);
    if($tag=='A') $this->HREF='';
  }

  function SetStyle($tag,$enable){
    //Modifie le style et sélectionne la police correspondante
    $this->$tag+=($enable ? 1 : -1);
    $style='';
    foreach(array('B','I','U') as $s)
      if(isset($this->$s) && $this->$s >0) $style.=$s;

    $this->SetFont('',$style);
  }

  function PutLink($URL,$txt){
    //Place un hyperlien
    $this->SetTextColor(0,0,255);
    $this->SetStyle('U',true);
    $this->Write(5,$txt,$URL);
    $this->SetStyle('U',false);
    $this->SetTextColor(0);
  }

}

/**
  @package oscss-Codev <www http://www.oscss.org>
  @author oscim - <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  Formatage html, suppression element html, decode utf8
*/
class PDF_label extends FPDF {
  //Page header
  function RoundedRect($x, $y, $w, $h,$r, $style = '')
  {
      $k = $this->k;
      $hp = $this->h;
      if($style=='F')
          $op='f';
      elseif($style=='FD' or $style=='DF')
          $op='B';
      else
          $op='S';
      $MyArc = 4/3 * (sqrt(2) - 1);
      $this->_out(sprintf('%.2f %.2f m',($x+$r)*$k,($hp-$y)*$k ));
      $xc = $x+$w-$r ;
      $yc = $y+$r;
      $this->_out(sprintf('%.2f %.2f l', $xc*$k,($hp-$y)*$k ));

      $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
      $xc = $x+$w-$r ;
      $yc = $y+$h-$r;
      $this->_out(sprintf('%.2f %.2f l',($x+$w)*$k,($hp-$yc)*$k));
      $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
      $xc = $x+$r ;
      $yc = $y+$h-$r;
      $this->_out(sprintf('%.2f %.2f l',$xc*$k,($hp-($y+$h))*$k));
      $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
      $xc = $x+$r ;
      $yc = $y+$r;
      $this->_out(sprintf('%.2f %.2f l',($x)*$k,($hp-$yc)*$k ));
      $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
      $this->_out($op);
  }

      function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
  {
      $h = $this->h;
      $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c ', $x1*$this->k, ($h-$y1)*$this->k,
                  $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
  }

  /**
  * @author oscim - OscssTeam
  * @version 1.3
  * @note
  */
  function Header()
  {
  //    //Logo
        $this->Image(HTTP_SERVER.STORE_LOGO_PRINT,5,10,50,0,'',HTTP_SERVER.DIR_WS_CATALOG);
  }

  function Footer()  {
    $y=-17;
    $this->SetX(0);
    //Arial italic 8
    $this->SetFont('Arial','',6);
    $this->SetFillColor(255);
    foreach(explode("\n",STORE_LEGAL_INFO) as $lg){
      $this->SetY($y);
      $this->Cell(0,3,tep_correct_entitie_put_pdf($lg),0,0,'C');
      $y = $y +3;
    }
  }
}

/**
  Entete de tableau , pour facture , avec prix, ttc et ht , et total ttc / ht par ligne
*/
function output_table_heading($Y_Fields_Name_position){
  global $pdf;
  //First create each Field Name
  //Gray color filling each Field Name box
  $pdf->SetFillColor(245);
  //Bold Font for Field Name
  $pdf->SetFont('Arial','B',10);
  $pdf->SetY($Y_Fields_Name_position);
  $pdf->SetX(6);
  $pdf->Cell(9,6,'Qty',1,0,'C',1);
  $pdf->SetX(15);
  $pdf->Cell(27,6,tep_correct_entitie_put_pdf(TABLE_HEADING_PRODUCTS_MODEL),1,0,'C',1);
  $pdf->SetX(40);
  $pdf->Cell(78,6,TABLE_HEADING_PRODUCTS,1,0,'C',1);
  //$pdf->SetX(105);
  //$pdf->Cell(15,6,TABLE_HEADING_TAX,1,0,'C',1);
  $pdf->SetX(118);
  $pdf->Cell(20,6,TABLE_HEADING_PRICE_EXCLUDING_TAX,1,0,'C',1);
  $pdf->SetX(138);
  $pdf->Cell(20,6,TABLE_HEADING_PRICE_INCLUDING_TAX,1,0,'C',1);
  $pdf->SetX(158);
  $pdf->Cell(20,6,TABLE_HEADING_TOTAL_EXCLUDING_TAX,1,0,'C',1);
  $pdf->SetX(178);
  $pdf->Cell(20,6,TABLE_HEADING_TOTAL_INCLUDING_TAX,1,0,'C',1);
  $pdf->Ln();
}

/**
  Entete de tableau , pour BL , qty, modle + name
*/
function output_table_heading_packingslip($Y_Fields_Name_position){
  global $pdf;
  //First create each Field Name
  //Gray color filling each Field Name box
  $pdf->SetFillColor(245);
  //Bold Font for Field Name
  $pdf->SetFont('Arial','B',10);
  $pdf->SetY($Y_Fields_Name_position);
  $pdf->SetX(6);
  $pdf->Cell(9,6,'Qty',1,0,'C',1);
  $pdf->SetX(15);
  $pdf->Cell(27,6,tep_correct_entitie_put_pdf(TABLE_HEADING_PRODUCTS_MODEL),1,0,'C',1);
  $pdf->SetX(40);
  $pdf->Cell(158,6,TABLE_HEADING_PRODUCTS,1,0,'C',1);
}

/**
  @package osCSS-2 <www http://www.oscss.org>
  @author oscim - <mail aurelien@oscim.fr> <www http://www.oscim.fr>

  Formatage html, suppression element html, decode utf8
*/
function tep_correct_entitie_put_pdf($chaine,$utf8=true){
  $array=array('&euro;','€');
  $array2=array(chr(128),chr(128));
  if($utf8)$chaine=str_replace($array,$array2,utf8_decode($chaine));
  else $chaine=str_replace($array,$array2,$chaine);
  return strip_tags(unhtmlentities($chaine));
}

/**
  Formatage de cesure
  @package osCSS-2 <www http://www.oscss.org>
  @author oscim - <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @param
    @a string txt a decoupé
    @a int max longeur max segment
  @return array()
*/
function tep_wordwrap($txt, $max){
  if (strlen($txt) > $max ) $newtext = wordwrap($txt, $max, "\n");
  return array('txt'=>$newtext,
               'nbr'=>substr_count($newtext,"\n")
              );
}
?>