<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file 
 *\brief
  Page de gestion des contenus . prend en charge les elements modulaires
 *\details 
  Si un _ID est pésent, charge alors les block de cet id, et force le contenu de la page vers cet _ID.
  cherche une class, nommé page._ID.php

  L'_ID est fournit par la page de la racine appelante (ex: contact.php de la racine defini un contact.php)

  *\param
  Option 1
    \a string _ID non du gabarit de prise en charge \
    \a string content id du contenu \
  Option 2
    \a string aca_action l'action aca, soit le non de la methode \
    \a string aca_mod le nom du module aca chargée \
    \a string aca_type le type du module chargée , soit le nom de la class mêre

  Option general
    @a boolean popup true/false block la partie ext des lamise en forme, conserve le block

  NOTE: Tous les fichier n'ayant aucun tratiement specifique complexe sont prise en charga par cette page
*/
  require('includes/application_top.php');

  $p=(isset($_ID)) ? $_ID : (isset($_GET['_ID']) ? $_GET['_ID'] :  basename(__FILE__));
  switch ($p){
    case 'template.php':
      require('templates/'.$template.'/includes/languages/' . $language . '/'.FILENAME_TEMPLATE);
    break;
    default:
  }

  $page->init($p,$language);


  switch ($p){
//     case 'template.php':
//     break;
    case 'form.php':
    case 'contact.php':
      $pp=substr($p, 0, -strlen($page->ext));
      $page->new_class($pp);
      $page->force_content($pp.'_'.$page->_call($pp,'the_form').$page->ext);
      if (isset($_GET['action'])) $page->_call($pp,'action');
    break;
    default:
      if (isset($_GET['content']) && !is_numeric($_GET['content'])){
        $pp=$_GET['content'];
        $page->new_class($pp);
        $page->force_content('page'.$page->ext);
        $page->force_gabarit('content');
        $page->_call($pp,'page');
      }
     /** Module aca */
      elseif (isset($_GET['aca_mod']) && !is_numeric($_GET['aca_mod']) && isset($_GET['aca_type']) &&  isset($_GET['aca_action'])){
        $module=$_GET['aca_mod'];
        $type=$_GET['aca_type'];
        $aca=$page->new_class($type);
        $aca_module=$page->_call($type,'ret_modules');
        /* cf content/page.php */
        $page->force_content('page'.$page->ext);

        if (isset($_GET['action']) ) {
            if ($aca_module[$module]->check_action($_GET['action']) ) {
             /** Exe == true */
              $aca_module[$module]->after_check_action($_GET['action']);
//               tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action'))));
            }
        }

      }
  }




  $page->post_init(false);

  require($page->path_gabarit());

  /** after_check_action */
//   if (isset($_GET['aca_mod']) && !is_numeric($_GET['aca_mod']) && isset($_GET['aca_type']) &&  isset($_GET['aca_action']))
//     $aca->after_check_action($module,$_GET['aca_action']);


  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>