<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  31/10/10, 22:59
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\brief display form creat account and manage confirmed account by email
 *	depend class customer
*/

  require('includes/application_top.php');

  $process = false;

  if(isset($_POST['action']) && ($_POST['action'] == 'process')) {
    $page->init(basename(__FILE__),$language);

    /**
      @brief Creation de compte
    */
    $process = true;

    $cust=customer::getInstance();

    $user=$cust->userInsert($_POST);

    if(!$user || !is_object($user)) tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));

      if (_cst_bool('ACCOUNT_GENDER')) {
         if ($user->gender == 'm') $cod_gender='EMAIL_GREET_MR';
         else  $cod_gender='EMAIL_GREET_MS';
      }
      else $cod_gender='EMAIL_GREET_MS';

      $myarray = array(
                  'from'=>STORE_OWNER,
                  'subject'=>'',
                  'cod_gender'=>$user->gender,
                  'db'=>array('gender'=>$user->gender,'password'=>$_POST['password'],'entry_firstname'=>$user->firstname,'entry_lastname'=>$user->lastname,'customers_email_address'=>$user->email_address),
                  'date_purchased'=>tep_strftime(DATE_FORMAT_LONG),
                  '_oLinks'=>tep_href_link(FILENAME_ACCOUNT, '', 'SSL'),
                  'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
                  'message'=>'',
                  );

      if(_cst_bool('ACCOUNT_FORCE_ACTIV_MAIL')){
	$cust->the_customer($user->id);
	$myarray['_oLinks']= tep_href_link(FILENAME_CREATE_ACCOUNT, 'action=confirm&hash='.$cust->creatValidHash().'&email='.$user->email_address, 'SSL');
	$message_final=tep_post_prepare_email('create_account_confirm.tpl',$language,$myarray);
      }
      else {
	//! init session
	customer::initSession($user);

	$message_final=tep_post_prepare_email('create_account.tpl',$language,$myarray);
      }
      tep_mail($user->firstname . ' ' . $user->lastname, $user->email_address, EMAIL_SUBJECT, $message_final, STORE_OWNER, EMAIL_FROM);


      $myarray = array(
		'from'=>STORE_OWNER,
		'subject'=>'',
		'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
		'message'=>sprintf(__("Please note that %s has created an account.") , $user->firstname . " " . $user->lastname . (isset($user->entry_company) ? __(" of the company: ") . $user->entry_company : '') ),
		);

      notification::notif('create_account',__('Company account created'),$myarray, 'customers_id='.$user->id);

      tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT, 'action=success', 'SSL'));
  }
  elseif(isset($_GET['action']) &&  $_GET['action']=='success')  {
    $navigation=navigation_history::getInstance();
    if (sizeof($navigation->snapshot) > 0) {
      $origin_href = tep_href_link($navigation->snapshot['page'], tep_array_to_string($navigation->snapshot['get'], array(tep_session_name())), $navigation->snapshot['mode']);
      $navigation->clear_snapshot();
    }
    else $origin_href = tep_href_link(FILENAME_DEFAULT);

    $page->init('create_account_success.php',$language);

    $page->force_content('create_account_success.php');
  }
  elseif(_cst_bool('ACCOUNT_FORCE_ACTIV_MAIL')) {
    if(isset($_GET['action']) && ($_GET['action'] == 'newconfirm')){
      /**
	@brief demande d'un noucel email de confirmation
      */
      $page->init('new_sent_email_confirm.php',$language);
      $cust=customer::getInstance();

      $page->force_content('new_sent_email_confirm.php');
    }
    elseif (isset($_GET['action']) && ($_GET['action'] == 'sentconfirm')) {
      /**
	@brief sent email confirmation
      */
      $page->init(basename(__FILE__),$language);

      $cust=customer::getInstance();

      $email_address=tep_db_prepare_input($_POST['email_address']);
      $customers_id=customer::search('customers_email_address', $email_address);

      /// user no found redirect
      if($customers_id==false ){
	$page->messageStack->add_session('create_account', TEXT_ERROR_EMAIL_NO_FOUND);
	tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT, 'action=newconfirm', 'SSL'));
      }

      $u=$cust->the_customer($customers_id);
      $user=$cust->detail_long_cust();

      $myarray = array(
                  'from'=>STORE_OWNER,
                  'subject'=>'',
                  'cod_gender'=>$user['customers_gender'],
                  'db'=>$user,
                  'date_purchased'=>tep_strftime(DATE_FORMAT_LONG),
                  '_oLinks'=>tep_href_link(FILENAME_CREATE_ACCOUNT, 'action=confirm&hash='.$cust->creatValidHash().'&email='.$email_address, 'SSL'),
                  'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
                  'message'=>'',
                  );

      $message_final=tep_post_prepare_email('create_account_confirm.tpl',$language,$myarray);

      tep_mail($user['customers_firstname'] . ' ' . $user['customers_lastname'], $email_address, EMAIL_SUBJECT, $message_final, STORE_OWNER, EMAIL_FROM);

      $page->messageStack->add_session('create_account', TEXT_NEW_SENT_EMAIL, 'success');

      tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));

    }
    elseif (isset($_GET['action']) && ($_GET['action'] == 'confirm')) {
      /**
	@brief confirmation de compte si necessite confirmation compte par email, liens email
      */
      $page->init(basename(__FILE__),$language);

      $cust=customer::getInstance();
    try{
      if(!isset($_GET['email'])) throw new Exception(TEXT_ERROR_LINK_NOT_VALID );
      if(!isset($_GET['hash'])) throw new Exception(TEXT_ERROR_LINK_NOT_VALID );

      $email_address=tep_db_prepare_input($_GET['email']);
      $hash=tep_db_prepare_input($_GET['hash']);

      $customers_id=customer::search('customers_email_address', $email_address);

      /// user no found redirect
      if( $customers_id===false ) throw new Exception( TEXT_ERROR_EMAIL_NO_FOUND);

// 	tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT, 'action=newconfirm', 'SSL'));
//       }

      $user=$cust->the_customer($customers_id);

      if(!$cust->checkHash($hash))  throw new Exception( sprintf(TEXT_ERROR_EMAIL_AND_HASH_NO_FOUND, '<br /><a href="'.tep_href_link(FILENAME_CREATE_ACCOUNT,'action=newconfirm').'">'.TEXT_NEW_SENT_CONFIRM.'</a>') );

      $page->messageStack->add_session('create_account', TEXT_ACCOUNT_CONFRIMED);

      /// init session
      customer::initSession($user);

      tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));

    }
    catch(Exception $e){
      $page->messageStack->add('create_account', $e->getMessage() );
    }


    }
    else
      $page->init(basename(__FILE__),$language);
  }
  else
    $page->init(basename(__FILE__),$language);

  $page->post_init();

  $page->javascript->add_framework("ext/jquery/jquery.min.js");
  $page->javascript->add_script("ext/jquery/jquery.validate.min.js", array('sort'=>30));

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');

?>