<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  21/12/10, 08:18
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file categories_dropdown.php
 *\brief categories menu in liste
*/

  $DB=Database::getInstance();
  $tree = array();
  $languages_id =$page->the_var('languages_id');
  $categories_query = $DB->query($sql="select c.categories_id, cd.categories_name, c.parent_id, c.sort_order from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and c.categories_status='1' and c.categories_hidden='1' and cd.language_id='" . $languages_id ."' order by c.sort_order asc ");
  $last_root = 0;
  $first_root = 0;

  while ($categories = $categories_query->fetchAssoc()) {
    $current_id = $categories['categories_id'];
    $parent_id = $categories['parent_id'];

    if (!isset($tree[$current_id])) {
      $tree[$current_id] = array();
      $tree[$current_id]['children'] = array();
      $tree[$current_id]['next'] = 0;
    }

    $tree[$current_id]['name'] = $categories['categories_name'];
    $tree[$current_id]['parent'] = $parent_id;
    $tree[$current_id]['order'] = $categories['sort_order'];

    if ($parent_id != 0) {
      if (!isset($tree[$parent_id])) {
        $tree[$parent_id] = array();
        $tree[$parent_id]['children'] = array();
      }

      $tree[$parent_id]['children'][] = $current_id;
    } else {
      if ($last_root == 0) {
        $last_root = $current_id;
        $first_root = $current_id;
      } else {
        $tree[$last_root]['next'] = $current_id;
        $last_root = $current_id;
      }
    }
  }

  $categories_string = '<ul>' . "\n";
  if ($first_root != 0) {
    $root = $first_root;
    do {
      $last_member = (isset($tree[$root]['next']) && $tree[$root]['next'] == 0) ? true : false;
      $categories_string =tep_build_tree($tree, $categories_string, $root, $last_member);
      $root = $tree[$root]['next'];
        }
	while ($root != 0);
        $categories_string .= '';
  }
   $categories_string.='</ul>';

  $array=array('title'=>__('categories menu'),'content'=>tep_output_string_protected($categories_string,false,true));
?>