<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  \licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  22/03/2011, 23:18
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \file AbstractAcaModule.php
  \brief
  	Ces classes sont les classes de base de l'appel des structure aca, elle ne sont appelé que par l'intermisiaire de class enfants
*/

/**
  \class AbstractAcaModule
  \brief class d'appel des module aca
 */
class AbstractAcaModule
  extends page{

  /**
   * \fn initialise_type($cst, $folder_base)
   *  \brief init class modules for value config , for type module
   * @param $cst string  la constante de ce type de module
   * @param $cst string
   * @return Ambigous <string, multitype:>
  */
  public static function initialise_type($cst, $folder_base){
    global $page,$language,$messageStack;
    $list_mod=array();
    if(defined($cst)){
      $files_array=explode (';',str_replace(';;',';',constant($cst)));
      if (tep_not_null($files_array[0])) {
	reset ($files_array);
	while (list ($key, $file) = each ($files_array)) {
	  $class=substr($file,0, strlen($file)-4 );
	  $folder=$folder_base;
	  //! module dans leur propre sous rep
	  if(is_dir(DIR_WS_MODULES . $folder.'/'.$class)) {
	    $folder .= '/' . $class;
	  }
	  if (!empty($class)) {
	    if(($path=parent::fix_file(DIR_WS_INCLUDES .'languages/'. $language . '/modules/'. $folder.'/' . $file,true)) !=false) $page->pile_file_lang($path);
	    if(!class_exists($class) && ( ($pathclass=parent::fix_file(DIR_WS_MODULES . $folder.'/' . $file)) != false ) )include($pathclass);
	    if(!class_exists($class)) trigger_error(sprintf(__CLASS__.' Could not load class %s', $class), E_USER_ERROR);
	    else $list_mod[]=$class;
	  }
	}
      }
    }
    return $list_mod;
  }

  /**
    @brief  Appel magic
    @param $method string
    @param $attrs array
  */
  public function __call($method, $attrs) {
    $r=array();
    foreach ($this->modules as $key=>$module) {
      if (method_exists($module, $method )) /// control presence method
	$r[]=$this->modules[$key]->$method($attrs);
    }

    return $r;
  }

  /**
   * \fn ret_modules($class='')
   * \brief retourne la liste des modules actifs ou l'object de l'un d'eux
   * @param $class
   * @return object
  */
  public function ret_modules($class=''){
    if(!empty($class) && isset($this->modules[$class]))  return $this->modules[$class];
    return $this->modules;
  }

  /**
   * \fn get_header_js ($action='')
   * \brief Allows modules to write something in header (javascript for example)
   * @param $action
   */
  public function get_header_js ($action='') {
    $tmp=array();
    if(isset($this->modules) && is_array($this->modules))
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled)  and (method_exists($module, 'get_header_js' ))) {
        $tmp[]= $this->modules[$key]->get_header_js($action);
      }
    }
  }

  /**
    Appel des element dans le block d'appel header du constructeur central
    Ex: header_tags
    @param $action string
  */
  public function get_header($action='') {
    $tmp=array();
    if(!isset($this->modules)) return false;
    foreach ($this->modules as $key=>$module){
      if (($module->enabled)  and (method_exists($module, 'get_header' )))
        $tmp[]= $this->modules[$key]->get_header($action);
    }
    return $tmp;
  }

  /**
   * \fn draw_ele_modules($class='')
   * \brief Affiche module elemnt html
   *    cheche methode draw_html_xxx
   * @param $class
  */
  public function draw_ele_modules($class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled){
        $funct='draw_html_'.$class;
        return $this->modules[$class]->$funct();
      }
    } else {
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'draw_html_'.$key ))) {
          $funct='draw_html_'.$key;
          return $this->modules[$key]->$funct();
        }
      }
    }
  }

  /**
   * \fn check_action ($class='',$actions='')
   * \brief  Execute les actions des modules
   * @param $class string class le nom de la class appelé, ou vide pour toutes les class enfants
   * @param $actions string class le nom de la class appelé, ou vide pour toutes les class enfants
   */
  public function check_action ($class='',$actions=''){
    $s='';
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'check_action' ))){
        return $this->modules[$class]->check_action($actions);
      }
    } else {
      if(isset($this->modules) && is_array($this->modules))
      foreach ($this->modules as $key=>$module) {
        if ($module->enabled && method_exists($module, 'check_action' )) {
          $s.= $this->modules[$key]->check_action($actions);
        }
      }
    }
    return $s;
  }

  /**
   * \fn after_check_action($class='',$actions)
   * \brief Execute les after_check_action des modules
   * @param $class string  le nom de la class appelé, ou vide pour toutes les class enfants
   * @param $actions string  $actions['action']
   */
  public function after_check_action($class='',$actions){
    $s='';
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'after_check_action' ))){
        return $this->modules[$class]->after_check_action($actions);
      }
    } else {
      if(isset($this->modules) && is_array($this->modules))
      foreach ($this->modules as $key=>$module) {
        if ($module->enabled && method_exists($module, 'after_check_action' )) {
          $s.= $this->modules[$key]->after_check_action($class,$actions);
        }
      }
    }
    return $s;
  }

  /**
   * \fn obj_db_values($cID,$class='')
   * \brief return object
   * \return Retourne le resultat sous forme d'objet
   * @param  $cID int
   * @param  $class string
   */
  public function obj_db_values($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'obj_db_values' ))){
        return $this->modules[$class]->obj_db_values($cID);
      }
    } else {
       $c=array();
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'obj_db_values' ))) {
          $c[]=$this->modules[$key]->obj_db_values($cID);
        }
      }
      return new objectInfo($c);
    }
  }

  /**
   * \fn return_db_min($cID,$class='')
   * \brief return_db_min module display_view mini
   * @param $cID  int   le Id du customers
   * @param $class string  le nom de la class appelé, ou vide pour toutes les class enfants
  */
  public function return_db_min($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($module, 'return_db_min' ))){
        $this->modules[$class]->load_db_values($cID);
        return $this->modules[$class]->return_db_min($cID);
      }
    } else {
       $c=array();
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'return_db_min' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c[$key]=$this->modules[$key]->return_db_min($cID);
        }
      }
      return $c;
    }
  }

}

?>