<?php
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  29/11/10, 11:33
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class Stock
  \file
  \dir includes/classes/
  \brief Gestion avancé des Stock, extension des class shopping_cart et chekcout_process
*/

class Stock {
  /**
    @a string
  */
  private static $marck;

  public function __construct(){
  }


  /**
   * \fn check_inline($product)
   * \brief Control d'une ligne de stock, utilisable dans les boucle produits
   * @param $product  \a array (quantity, id, track_stock, attributes)
   * @return bool
    \li false =  ok
    \li true = alert
  */
  public static function check_inline($product){
    $attributes= (is_array($product['attributes']) ? $product['attributes'] : array() );

    switch($product['track_stock']) {
      case 0: /// no check stock
	self::$marck=0;
      break;
      case 2: /// no check stock , product dispo sur commande
	self::$marck=1;
      break;
      case 1: /// check stock
      default:
	self::$marck=( ((tep_get_products_stock($product['id'],$attributes) - $product['quantity'] ) < 0)? 2 : 0);
    }
     return (in_array(self::$marck, array(2,1) ) )? true : false;
  }

  /**
    \fn mark_inline()
    \brief Sortie visuel alert stock / hors stock
    	A utiliser apres l'appel de la methode check_inline
  */
  public static function mark_inline(){
    if(self::$marck==0) return ;
    elseif(self::$marck==2) return ' <span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '</span>';
    elseif(self::$marck==1) return ' <span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_NO_STOCK . '</span>';
  }


  /**
    Control complet
    @return bool
      false =  erreur
      true = ok
  */
  public static function check_cart(){
    global $cart;

    $any_out_of_stock = false;
    if (_cst_bool('STOCK_CHECK')) {
      $products = $cart->get_products();
      for ($i=0, $n=sizeof($products); $i<$n; $i++) {
	$any_out_of_stock = self::check_inline($products[$i]);
      }
      // Out of Stock Et achat hors stock non autorisé
      if  (!_cst_bool('STOCK_ALLOW_CHECKOUT') && ($any_out_of_stock == true) ) {
	return false;
      }
    }
    return true;
  }
}
?>