<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  28/11/10, 08:18
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\ingroup FrontClass
 *\file breadcrumb.php
 *\class breadcrumb
 *\dir includes/classes/
 *
 * \li - add NOT_RECUP_CASSE_IN_TXT_CATEGORIES  Actif par defaut @a Hors-constructeur
*/
class breadcrumb{
  /**
   * 
   * @var $_trail array
   */
  protected $_trail;

  /**
   * 
   */
  function breadcrumb() {
    $this->reset();
  }

  /**
   * 
   */
  function reset() {
    $this->_trail = array();
  }

  /**
   * 
   * @param $title
   * @param $link
   */
  function add($title, $link = '') {
    $this->_trail[] = array('title' => $title, 'link' => $link);
  }

  /**
   * 
   * @param $separator
   * @return string
   */
  function trail($separator = ' - ') {
    $trail_string = '';

    for ($i=0, $n=sizeof($this->_trail); $i<$n; $i++) {
      if (isset($this->_trail[$i]['link']) && tep_not_null($this->_trail[$i]['link'])) {
        $trail_string .= '<a href="' . $this->_trail[$i]['link'] . '" class="breadCrumb">' . ((!_cst_bool('NOT_RECUP_CASSE_IN_TXT_CATEGORIES'))?strtolower($this->_trail[$i]['title']) : $this->_trail[$i]['title']) . '</a>';
      } else {
        $trail_string .= $this->_trail[$i]['title'];
      }

      if (($i+1) < $n) $trail_string .= $separator;
    }

    return $trail_string;
  }
}
?>