<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  29/11/10, 11:33
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class messageStack
  \dir includes/classes/

  \brief

  Example usage:

  $messageStack = new messageStack();
  $messageStack->add('general', 'Error: Error 1', 'error');
  $messageStack->add('general', 'Error: Error 2', 'warning');
  if ($messageStack->size('general') > 0) echo $messageStack->output('general');

        ENCODE UTF-8
 */
class messageStack{

  /**
  */
  private $message;


  function __construct() {
    global $messageToStack;

    $this->messages = array();

    if (tep_session_is_registered('messageToStack')) {
      for ($i=0, $n=sizeof($messageToStack); $i<$n; $i++) {
        $this->add($messageToStack[$i]['class'], $messageToStack[$i]['text'], $messageToStack[$i]['type']);
      }
      tep_session_unregister('messageToStack');
    }
  }

// class methods
  function add($class, $message, $type = 'error') {
    if ($type == 'error') {
      $this->messages[] = array('params' => 'class="messageStackError"', 'class' => $class, 'text' => $message);
    } elseif ($type == 'warning') {
      $this->messages[] = array('params' => 'class="messageStackWarning"', 'class' => $class, 'text' => $message);
    } elseif ($type == 'success') {
      $this->messages[] = array('params' => 'class="messageStackSuccess"', 'class' => $class, 'text' => $message);
    } else {
      $this->messages[] = array('params' => 'class="messageStackError"', 'class' => $class, 'text' => $message);
    }
  }

  function add_session($class, $message, $type = 'error') {
    global $messageToStack;

    if (!tep_session_is_registered('messageToStack')) {
      tep_session_register('messageToStack');
      $messageToStack = array();
    }

    $messageToStack[] = array('class' => $class, 'text' => $message, 'type' => $type);
  }

  function reset() {
    $this->messages = array();
  }

  /**
    Sortie des erreur
  */
  private function output($class) {
    $output = '<ul>';
    for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
      if ($this->messages[$i]['class'] == $class) {
        $output .='<li '.$this->messages[$i]['params'].' >'. $this->messages[$i]['text'] .'</li>'."\n";
      }
    }
    $output .= '</ul>';
    return $output;
  }

  /**
    Sortie des erreur inline
  */
  private function output_inline($class, $markup) {
    for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
      if ($this->messages[$i]['class'] == $class) {
        $output ='<'.$markup.' '.$this->messages[$i]['params'].' >'. $this->messages[$i]['text'] .'</'.$markup.'>'."\n";
      }
    }
    return $output;
  }

  /**
    Calcul présence des erreurs
  */
  /*private*/ function size($class) {
    $count = 0;

    for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
      if ($this->messages[$i]['class'] == $class) {
        $count++;
      }
    }

    return $count;
  }

  /**
    Alias public
  */
  public function _add($class, $message, $type='error'){
    return $this->add($class, $message, $type);
  }

  /**
    Draw erreur
  */
  public function _draw($type){
    if ($this->size($type) > 0)
      echo '<div id="retour_erreur" class="messageStack">'. $this->output($type) . '</div>';
  }

  /**
    Draw erreur inline
  */
  public function _draw_inline($type, $markup=''){
    if (empty($markup)) {$markup = 'span';}
    if ($this->size($type) > 0)
      echo $this->output_inline($type, $markup);
  }

  /**
    Draw number error
  */
  public function _draw_nbr($type){
    print $this->size($type);
  }
}
?>