<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  29/03/11, 10:10
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  \class navigation_history
  \dir includes/classes/

  \brief
*/

class navigation_history {
  /**
    @var array
  */
  public $path;
  /**
    @var array
  */
  public $snapshot;
  /**
    @var object current instance
  */
  protected static $_instance;
  /**
    @var string current page by REQUEST_URI
  */
  private static $_Page;


  protected function __construct() {
    if (tep_session_is_registered('navigation')){
      $this->path = $_SESSION['navigation']->path;
      $this->snapshot =  $_SESSION['navigation']->snapshot;
    }
    else $this->reset();
  }

  public static function getInstance() {
    if(self::$_instance == null) {
      self::$_instance = new self();
    }
    return self::$_instance;
  }

  public static function resetInstance() {
    self::$_instance = null;
    return self::getInstance();
  }

  /**
    @fn $object->set_close();
    @brief call by close session page. save snapshot
  */
  public function set_close(){
    if (tep_session_is_registered('navigation')){
      $_SESSION['navigation']->path=$this->path ;
      $_SESSION['navigation']->snapshot= $this->snapshot  ;
    }
  }

  public function reset() {
    $this->path = array();
    $this->snapshot = array();
  }

  public function add_current_page() {
    global  $_GET, $_POST, $request_type, $cPath;

    $set = true;
    for ($i=0, $n=sizeof($this->path); $i<$n; $i++) {
      if ( ($this->path[$i]['page'] == self::cleanPage() ) ) {
        if (isset($cPath)) {
          if (!isset($this->path[$i]['get']['cPath'])) {
            continue;
          } else {
            if ($this->path[$i]['get']['cPath'] == $cPath) {
              array_splice($this->path, ($i+1));
              $set = false;
              break;
            } else {
              $old_cPath = explode('_', $this->path[$i]['get']['cPath']);
              $new_cPath = explode('_', $cPath);

              for ($j=0, $n2=sizeof($old_cPath); $j<$n2; $j++) {
                if ($old_cPath[$j] != $new_cPath[$j]) {
                  array_splice($this->path, ($i));
                  $set = true;
                  break 2;
                }
              }
            }
          }
        } else {
          array_splice($this->path, ($i));
          $set = true;
          break;
        }
      }
    }

    if ((bool)$set) {
      $this->path[] = array('page' => self::cleanPage(),
                            'mode' => $request_type,
                            'get' => $_GET,
                            'post' => $_POST);
    }
  }

  public function remove_current_page() {
    $last_entry_position = sizeof($this->path) - 1;
    if ($this->path[$last_entry_position]['page'] == self::cleanPage() ) {
      unset($this->path[$last_entry_position]);
    }
  }

  public function set_snapshot($page = '') {
    global  $_GET, $_POST, $request_type;

    if (is_array($page)) {
      $this->snapshot = array('page' => $page['page'],
                              'mode' => $page['mode'],
                              'get' => $page['get'],
                              'post' => $page['post']);
    } else {
      $this->snapshot = array('page' => self::cleanPage(),
                              'mode' => $request_type,
                              'get' => $_GET,
                              'post' => $_POST);
    }
  }

  public function clear_snapshot() {
    $this->snapshot = array();
  }

  /**
    @brief call content snapshot
  */
  public function get_snapshot(){
    return $this->snapshot;
  }

  public function set_path_as_snapshot($history = 0) {
    $pos = (sizeof($this->path)-1-$history);
    $this->snapshot = array('page' => $this->path[$pos]['page'],
                            'mode' => $this->path[$pos]['mode'],
                            'get' => $this->path[$pos]['get'],
                            'post' => $this->path[$pos]['post']);
  }

  /**
    @brief clean current page
  */
  private static function  cleanPage(){
    return (!empty(self::$_Page)? self::$_Page : self::$_Page=preg_replace('#[?].+#i','',basename($_SERVER['REQUEST_URI'])) );
  }


  function unserialize($broken) {
    for(reset($broken);$kv=each($broken);) {
      $key=$kv['key'];
      if (gettype($this->$key)!="user function")
      $this->$key=$kv['value'];
    }
  }

//   public function debug() {
//     for ($i=0, $n=sizeof($this->path); $i<$n; $i++) {
//       echo $this->path[$i]['page'] . '?';
//       while (list($key, $value) = each($this->path[$i]['get'])) {
//         echo $key . '=' . $value . '&';
//       }
//       if (sizeof($this->path[$i]['post']) > 0) {
//         echo '<br />';
//         while (list($key, $value) = each($this->path[$i]['post'])) {
//           echo '&nbsp;&nbsp;<strong>' . $key . '=' . $value . '</strong><br />';
//         }
//       }
//       echo '<br />';
//     }
//
//     if (sizeof($this->snapshot) > 0) {
//       echo '<br /><br />';
//
//       echo $this->snapshot['mode'] . ' ' . $this->snapshot['page'] . '?' . tep_array_to_string($this->snapshot['get'], array(tep_session_name())) . '<br />';
//     }
//   }


}
?>
