<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  29/11/10, 11:33
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class order_total
  \dir includes/classes/

  \brief   Prend en charge la gestion des moduel order_total actif.
  			Intervient dans les checkout, les shopping,
*/

class order_total
  extends AbstractAcaModule{
    var $modules;

  /**
    Constructor
  */
  function order_total() {
    global $language,$customer_id, $page, $cart;
    $this->modules=array();
    $this->list_mod=array();


    foreach(parent::initialise_type('MODULE_ORDER_TOTAL_INSTALLED','order_total') as $class){
      $cl[$class]=new $class ();
      $list_mod[$cl[$class]->sort_order] = $class ;
    }

    if (isset($_SESSION['sppc_customer_group_id']) && $_SESSION['sppc_customer_group_id'] != '0') $customer_group_id = $_SESSION['sppc_customer_group_id'];
    else  $customer_group_id = '0';

    $customer_ot_query = tep_db_query("select IF(c.customers_order_total_allowed <> '', c.customers_order_total_allowed, cg.group_order_total_allowed) as order_total_allowed from " . TABLE_CUSTOMERS . " c, " . TABLE_CUSTOMERS_GROUPS . " cg where c.customers_id = '" . $customer_id . "' and cg.customers_group_id =  '" . $customer_group_id . "'");
    $customer_ot = tep_db_fetch_array($customer_ot_query);
    $temp_ot_array= (tep_not_null($customer_ot['order_total_allowed']) )  ? explode(';', $customer_ot['order_total_allowed']) : array() ;

    if(!isset($list_mod) ||!is_array($list_mod) || count($list_mod)==0) return false;
    ksort($list_mod);
    foreach($list_mod as $s=>$class){
      if ( count($temp_ot_array)==0 || in_array($class.'.php', $temp_ot_array ) ) $GLOBALS[$class]=$this->modules[$class] =$cl[$class];
    }
    unset($cl);unset($list_mod);

    return $this->modules;
  }

/** ---- CHECKOUT PROCESS ------*/
  /**
  */
  public function process() {
    $order_total_array = array();
    if (is_array($this->modules) && count($this->modules)>0) {
      reset($this->modules);
      while (list($class, $value) = each($this->modules)) {
        if ($GLOBALS[$class]->enabled) {
          $GLOBALS[$class]->process();

          for ($i=0, $n=sizeof($GLOBALS[$class]->output); $i<$n; $i++) {
            if (tep_not_null($GLOBALS[$class]->output[$i]['title']) && tep_not_null($GLOBALS[$class]->output[$i]['text'])) {
              $order_total_array[] = array( 'code' => $GLOBALS[$class]->code,
                                            'title' => $GLOBALS[$class]->output[$i]['title'],
					    'text_ht' => @$GLOBALS[$class]->output[$i]['text_ht'],
                                            'text' => $GLOBALS[$class]->output[$i]['text'],
                                            'value_ht' => $GLOBALS[$class]->output[$i]['value_ht'],
					    'value' => $GLOBALS[$class]->output[$i]['value'],
                                            'sort_order' => $GLOBALS[$class]->sort_order);
            }
          }
        }
      }
    }
    return $order_total_array;
  }

  /**
  */
  public function output($f_lin="<tr>%s</tr>", $f_col='<td colspan="4" class="otTtitle">%s</td><td class="otText">%s</td><td class="otText">%s</td>') {
    global $GLOBALS;
    $output_string = '';

    if (is_array($this->modules)) {
      reset($this->modules);
      while (list($class, $value) = each($this->modules)) {
        if ($GLOBALS[$class]->enabled) {
          $size = sizeof($GLOBALS[$class]->output);

          for ($i=0; $i<$size; $i++) {
            $output_string .=sprintf($f_lin,
                                      sprintf($f_col,
                                              $GLOBALS[$class]->output[$i]['title'],
					      @$GLOBALS[$class]->output[$i]['text_ht'],
                                              $GLOBALS[$class]->output[$i]['text'])
                                    ."\n")
                            ."\n";
          }
        }
      }
    }

    return $output_string;
  }

/** ---- SHOPPING CART ACTION  CLASS------*/

  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @depend Class shopping_cart_action
    @return href de retour
    Fournis une action au panier
  */
  function shopping_cart_action($class='',$action=''){
    global  $page, $lang,$goto,$parameters;;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled){
        $funct='shopping_cart_action';
        return $this->modules[$class]->$funct($action);
      }
    } else {
      reset($this->modules);
      foreach ($this->modules as $key=>$module) {
	$funct='shopping_cart_action';
        if (($module->enabled)  and (method_exists($module, $funct ))) {
          return $this->modules[$key]->$funct($action);
        }
      }
    }
    return false;
  }


/** ---- SHOPPING CART PAGE / CLASS ------*/

  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @depend Class shopping_cart_action
    @return href de retour
    Fournis une action au panier
  */
  function draw_cart($class='',$product=''){
    global  $page, $lang,$goto,$parameters, $cart;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled && (isset($module->shopping_cart) && $module->shopping_cart) && (method_exists($module, $funct ))){
        $funct='draw_cart';
        $product= $this->modules[$class]->$funct($product);
      }
    } else {
      reset($this->modules);
      foreach ($this->modules as $key=>$module) {
	$funct='draw_cart';
        if (($module->enabled)  && (isset($module->shopping_cart) && $module->shopping_cart) && (method_exists($module, $funct )) ) {
          $product= $this->modules[$key]->$funct($product);
        }
      }
    }
    return $product;
  }

  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @depend Class shopping_cart_action
    @return href de retour
    Fournis une action au panier
  */
  function process_cart($class='',$product=''){
    global  $page, $lang,$goto,$parameters;;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled && (isset($module->shopping_cart) && $module->shopping_cart) && (method_exists($module, $funct ))){
        $funct='process_cart';
        $product= $this->modules[$class]->$funct($product);
      }
    } else {
      reset($this->modules);
      foreach ($this->modules as $key=>$module) {
	$funct='process_cart';
        if (($module->enabled)  && (isset($module->shopping_cart) && $module->shopping_cart) && (method_exists($module, $funct )) ) {
          $product= $this->modules[$key]->$funct($product);
        }
      }
    }
    return $product;
  }

  /**
    @depend shopping_cart.php
    @package oscss-2 <www http://www.oscss.org>
    @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
    @depend Class shopping_cart

    Init des modules a activer dans la page shopping_cart
  */
  function _extents($funct,$action=''){
    global  $page, $lang;
    $res=array();
    reset($this->modules);
    if(empty($funct)) return;
    foreach ($this->modules as $key=>$module) {
      if (($module->enabled)  && (isset($module->shopping_cart) && $module->shopping_cart)  && (method_exists($module, $funct ))) $res[$key]=$this->modules[$key]->$funct($action);
    }
    return $res;
  }

}


?>