<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  05/11/10, 11:24
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

/**
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \class AbstractProduct
  \brief 
  Force mise en forme via class absctarction des class de produits
*/
abstract class AbstractAccount {
  // Force la classe étendue à définir cette méthode
  abstract protected function display_view($ID='');
  abstract protected function load_db_values($ID);
  abstract protected function get_header($action='');
  // méthode commune
//     public function printOut() { }
}

/**
 * \class account
 * \brief 
  	Class de la gestion de compte des customers les page account.php
  	Prend en charge des extension de type aca
*/
class account
  extends AbstractAcaModule
    implements InterfaceAcaGene {

  protected static $_instance;

  /**
  */
  protected function __construct() {
    global $language, $page, $lang;

    $this->name='account';
    $this->products_id='';
    $this->modules=array();

    foreach(parent::initialise_type('MODULE_ACCOUNT_INSTALLED','account') as $class){
      $cl[$class]=new $class ();
      $list_mod[$class] = $cl[$class]->sort_order;
      asort($list_mod);
      foreach($list_mod as $class=>$s){
	$this->modules[$class] =$cl[$class];
      }
      unset($cl);unset($list_mod);
    }
  }

  public static function getInstance() {
    if(self::$_instance == null) self::$_instance = new self();
    return self::$_instance;
  }

  public static function resetInstance(){
    self::$_instance = null;
    return self::getInstance();
  }


  public function get_header($class='',$action=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'get_header' ))){
        return $this->modules[$class]->get_header($action);
      }
    } else {
       $c=array();
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'get_header' ))) {
          $c[]=$module->get_header($action);
        }
      }
      return $c;
    }
  }

  /**
   * \fn display_view($cID,$class='')
   * \brief Affiche module elemennt html

    cheche methode draw_html_xxx pour les sous modules et class enfants
    \li @a int  cID le Id du customers
    \li @a string class le nom de la class appelé, ou vide pour toutes les class enfants
  */
  public function display_view($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'display_view' ))){
        $this->modules[$class]->load_db_values($cID);
        return $this->modules[$class]->display_view($cID);
      }
    } else {
       $c=array();
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c[]=$this->modules[$key]->display_view($cID);
        }
      }
      return $c;
    }
  }

   /**
    * \fn display_view_min($cID,$class='')
    * \brief Affiche module display_view mini
      \li @a int  cID le Id du customers
      \li @a string class le nom de la class appelé, ou vide pour toutes les class enfants
  */
  public function display_view_min($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($module, 'display_view_min' ))){
        $this->modules[$class]->load_db_values($cID);
        return $this->modules[$class]->display_view_min($cID);
      }
    } else {
       $c='';
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view_min' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c .=$this->modules[$key]->display_view_min($cID);
        }
      }
      return $c;
    }
  }




/**
 * \section Specifique Module 
 * */


  /**
   * \fn display_view_public($cID,$class='')
   * \brief Affiche module display_view public
	    Les information membre public
   * @param $cID int le Id du customers
   * @param $class string class le nom de la class appelé, ou vide pour toutes les class enfants
   * @return string
  */
  public function display_view_public($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($module, 'display_view_public' ))){
        $this->modules[$class]->load_db_values($cID);
        return $this->modules[$class]->display_view_public($cID);
      }
    } else {
       $c='';
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view_public' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c .=$this->modules[$key]->display_view_public($cID);
        }
      }
      return $c;
    }
  }

  /**
   * \fn display_view_button_action($cID)
   * \brief Affiche Un bouton ou form d'action dans etxte ou tableau (rma in history_info)
     \li @a int  cID le Id du customers
  */
  public function display_view_button_action($cID){
    global  $page;
    $c='';
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view_button_action' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c .=$this->modules[$key]->display_view_button_action($cID);
        }
      }
      return $c;
  }

}
?>