<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/02/11, 16:11
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class contact
  @brief Class des envoi de mail vers un destinataire. envoi interne

  LE formulaire utilisé doit être contenu dans le repertoire content ET tre nommé contact_(self::$suffixe)
  @example usage : contact->the_form();

*/
class contact {

  /**
    @var $suffixe string for call form
    The form is contact_ $suffixe
  */
  protected static $suffixe;

  function __construct(){
      global $page;
      if (isset($_GET['products_id'])&& is_numeric($_GET['products_id'])) self::$suffixe='product';
      else self::$suffixe='us';

      $this->init();
    }


  public function init(){

    switch(self::$suffixe) {
      case 'product':
        $this->params_form='products_id='.$_GET['products_id'];
      break;
      default:
        $this->t_user['email']=STORE_OWNER_EMAIL_ADDRESS;
        $this->t_user['name']=STORE_OWNER;

        $this->params_form='';
    }
  }

  /**
    @fn the_form()
    @brief call form , return suffixe
  */
  public function the_form(){
    return self::$suffixe;
  }

  /**
  Retour du formulaire à chargée
  */
  public function the_params(){
    return $this->params_form;
  }

  /**
    @fn  action()
    @brief exe action form
  */
  public function action(){
    global $page;


    switch(self::$suffixe) {
      default:
        if (isset($_GET['action']) && ($_GET['action'] == 'send')) {

          $enquiry = tep_db_prepare_input($_POST['enquiry']);
	  $data='';

	    if (!tep_session_is_registered('customer_id')) {
	      $name = tep_db_prepare_input($_POST['name']);
	      $email_address = tep_db_prepare_input($_POST['email']);

	      $enquiry = $name.' '.$email_address." <br><br> ".$enquiry;

	      $data .='&user='.$name.'&user_email='.$email_address;
	    }
	    /// user connected, use detail user
	    else {
	      $cust=customer::getInstance();
	      $user=$cust->the_customer($_SESSION['customer_id']);
	      $user=new objectInfo($user);
	      $name = $user->customers_lastname.' '.$user->customers_firstname;
	      $email_address=$user->customers_email_address;
	      $data .='&customers_id='.$user->customers_id;
	    }


          if (tep_validate_email($email_address) && !empty($name) ) {

	    $myarray = array(
		'from'=>$name,
		'from_email'=>$email_address,
		'subject'=>EMAIL_SUBJECT,
		'email_use_html'=>_cst_bool('EMAIL_USE_HTML'),
		'message'=>$enquiry,
	    );

	    notification::notif('contact_us',EMAIL_SUBJECT,$myarray,$data);


            tep_redirect(tep_href_link(FILENAME_CONTACT_US, 'action=success'));
          }
	  elseif(empty($name) ) {
            $error = true;

            $page->messageStack->add('contact', ENTRY_NAME_CHECK_ERROR);
	  }
	  else {
            $error = true;

            $page->messageStack->add('contact', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
          }
        }
    }
  }
}

?>