<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  23/09/10, 21:46
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class generic
  \file page.generic.php
*/


class generic
  extends AbstractAcaModule
    implements InterfaceAcaGene{

  //! @p object
  protected static $_instance;

  /**
   * \fn __construct()
   * \brief Charge les module aca specifique au porduits
  */
  function __construct() {
    global $language, $page, $lang;
    $this-> name='generic';
    $this-> generics_id='';
    $this-> image_handler='';
    $this->modules=array();

    foreach(parent::initialise_type('MODULE_GENERIC_INSTALLED','generic') as $class){
      $cl[$class]=new $class ();
      $list_mod[$class] = $cl[$class]->sort_order;
      asort($list_mod);
      foreach($list_mod as $class=>$s){
	$this->modules[$class] =$cl[$class];
      }
      unset($cl);unset($list_mod);
    }
  }

  /**
   * \fn getInstance($full=false) 
   * @param $full
   */
  public static function getInstance($full=false) {
    if(self::$_instance == null) self::$_instance = new self($full);
    return self::$_instance;
  }

  /**
   * \fn resetInstance()
   */
  public static function resetInstance(){
    self::$_instance = null;
    return self::getInstance();
  }


 /**
  * \fn display_view($pID,$class='')
  * \brief 
    Affiche module elemennt html

    Block principal d'affichage, liste ou vue des élément. Block principal de page
   
  *  @param $pID  int le Id du produits
  *  @param $class string le nom de la class appelé, ou vide pour toutes les class enfants
  */
  public function display_view($pID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'display_view' ))){
        $this->modules[$class]->load_db_values($pID);
        return $this->modules[$class]->display_view($pID);
      }
    } else {
       $c='';
      if(isset($this->modules) && is_array($this->modules))
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view' ))) {
          $this->modules[$key]->load_db_values($pID);
          $c .=$this->modules[$key]->display_view($pID);
        }
      }
      return $c;
    }
  }



  /**
   * \fn display_view_min($cID,$class='')
   * \brief Affiche module display_view mini
   *  @param $pID  int le Id du produits
   *  @param $class string le nom de la class appelé, ou vide pour toutes les class enfants
  */
  public function display_view_min($cID,$class=''){
    global  $page;
    if (!empty($class)) {
      if (isset($this->modules[$class]) && $this->modules[$class]->enabled and (method_exists($class, 'display_view_min' ))){
        $this->modules[$class]->load_db_values($cID);
        return $this->modules[$class]->display_view_min($cID);
      }
    } else {
       $c='';
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_view_min' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c .=$this->modules[$key]->display_view_min($cID);
        }
      }
      return $c;
    }
  }


  /**
   * \fn display_titre($cID,$format='$s')
   * \brief Affiche bock titre client notifié
   * @param $cID int 
   * @param $format string for sprintf
  */
  public function display_titre($cID,$format='$s'){
      $c='';
      foreach ($this->modules as $key=>$module) {
        if (($module->enabled)  and (method_exists($module, 'display_titre' ))) {
          $this->modules[$key]->load_db_values($cID);
          $c .=$this->modules[$key]->display_titre($format);
        }
      }
      return $c;
  }


}
?>