<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  27/01/11, 14:13
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  \class javascript
  \brief
  Cette classe construit les appel js.
  Elle accepte des script en standalone

  Si un framework est déclaré, alors les script ne necessite que des info mini
*/
class javascript{

  /**
   * \brief tableau d'elment du framework utilisé
   * @var array
  */
  var $framework;

  /**
   * \brief Les script a chargée
   * @var string
  */
  var $script;

  /**
   * \fn __construct()
   */
  function __construct(){
    global $page;
//     $this->framework
    $this->script=array();
  }

  /**
    Stock l'etat des chargement de la page, pour bloquer les doublons
  */
  private function etat_charge(){

  }


  /**
   * \fn add_framework($name, $opt='')
   * \brief
    Ajout d'un framework, comme maitre des scripts

    Les script enfant doivent ere nommé prefix_script.name script.js

   * @param $name
   * @param $opt
   */
  public function add_framework($name, $opt=''){
    $dir= dirname($name);
    $file=basename($name);
    $opt=(!is_array($opt))? array() : $opt ;
    $this->framework['name']=$file;
    $this->framework['path']=$dir.'/';
    $this->framework=array_merge($this->framework, $opt);
    $this->framework['prefix_script']=(isset($option['prefix_script']))?$option['prefix_script']: '';
    /*
      @param option[mode] (ponctuel, permanent)
      Cette option charge le framework systhematiquement, ou sur demande
    */
    $this->framework['mode']=(isset($option['mode']))?$option['mode']: 'ponctuel';
  }

  /**
   * \fn add_script($script, $opt='')
   * \brief Ajout de script (lib/file) au chargeur
   * @param $script string
   * @param $opt array
   */
  public function add_script($script, $opt=''){
    $dir= dirname($script);
    $file=basename($script);
    $opt=(!is_array($opt))? array() : $opt ;

    if (!isset($this->script[$file])){
      $this->script[$file]['path']=$dir.'/';
      $this->script[$file]['file']=$file;
      $this->script[$file]=array_merge($this->script[$file], $opt);
      return true;
    }
    else return false;
  }

  /**
   * \fn add_script_src($array, $opt='')
   * \brief add src inline, but load in header
   * @param $script file or key
   * @param $opt array
   */
  public function add_script_src($array, $opt=''){
    $file=$array['file'];
    $script= $array['script'];
    $opt=(!is_array($opt))? array() : $opt ;

    if (!isset($this->script[$file])){
      $this->script[$file]['script']=$script;
      $this->script[$file]=array_merge($this->script[$file], $opt);
      return true;
    }
    else return false;
  }


  /**
   * \fn del_script($script, $opt='')
   * \brief Supp d'un script du chargeur
   * @param $script
   * @param $opt
   */
  public function del_script($script, $opt=''){
    $dir= dirname($script);
    $file=basename($script);
    $opt=(!is_array($opt))? array() : $opt ;

    if (isset($this->script[$file])) {
      unset($this->script[$file]);
      return true;
    }
    else return false;
  }

  /**
   * \fn replace_script($script, $new_script, $opt='')
   * \brief replace d'un script du chargeur
   * @param $script
   * @param $new_script
   * @param $opt
   */
  public function replace_script($script, $new_script, $opt=''){
    $dir= dirname($script);
    $file=basename($script);
    $opt=(!is_array($opt))? array() : $opt ;

    if (isset($this->script[$file])) {
      unset($this->script[$file]);
      $this->add_script($new_script, $opt);
      return true;
    }
    else return false;
  }

  /**
   * \fn add_init_header($array)
   * \brief Add pile des init
   * @param $array
   */
  private function add_init_header($array){
    $this->init[]=$array;
  }

  /**
   * \fn add_multi($def)
   * \brief Definition  via le retour des options de plugins
   * @param $def
   */
  function add_multi($def){
    global $page;
    if (!is_array($def)) return false;
    reset($def);
    while($r=each($def)) {
      $type=(isset($r['value']['type'])) ? $r['value']['type'] : 'script';
      switch($type){
        case 'framework':
           $this->add_framework($r['value']['file'], $r['value']);
        break;
        case 'function':
           $this->add_init_header($r['value']);
        break;
        case 'del_script':
           $this->del_script($r['value']['file']);
        break;
        case 'script':
        default:
          if (isset($r['value']['file']) && is_array($r['value']['file'])){
            foreach($r['value']['file'] as $key=>$value){
	      if(isset($r['value']['place']) && $r['value']['place']=='footer') $page->add_file_footer($value,array('sort'=>$r['value']['sort']));
	      elseif(!isset($r['value']['place']) || $r['value']['place']=='header')  $this->add_script($value, array('sort'=>$r['value']['sort']) );
            }
          }
      }
      unset($r);
    }

  }

  /**
   * \brief
    Appel dans la function draw_header du constructeur de page
    Fabrication des liens, et des contenu print
  */
  function cstr_header(){
    global $page;

    if (isset($this->framework['name'])) $page->add_file_header($this->framework['path'].$this->framework['name'],array('sort'=>3));

    /** Appel element ACA get_header_js */
    if( ($name=$page->the_type()) && ($page->return_object($name) !=false) ) {
      $class=$page->return_object($name);
      if(method_exists($class, 'get_header_js' )) $class->get_header_js();
    }

    while ($e=each($this->script)){
      if(isset($e['value']['file']))  {
        $s=(isset($e['value']['sort']))? $e['value']['sort'] : 5;
        if(!isset($e['value']['place']) || $e['value']['place']=='header') $page->add_file_header($e['value']['path'].$e['value']['file'],array('sort'=>$s));
	elseif(isset($e['value']['place']) && $e['value']['place']=='footer') $page->add_file_footer($e['value']['path'].$e['value']['file'],array('sort'=>$s));
      }
     else print unhtmlentities($e['value']['script']);

    }
  }



  public function init_prepa(){
    if (!isset($this->init) || !is_array( $this->init)) return false;
    $sorti='';
    while($e=each( $this->init)){
      if ($e['value']['type']=='function')eval("\$sorti .=".$e['value']['code_exe']."();");
//             elseif ($e['value']['type']=='include'){
//               ob_start();
//                 include('');
//               ob_get_contents();
//             }
    }

    return $sorti;
  }


  function cstr_inline(){
  }

  function cstr_footer(){
  }

  function call_back(){
  }

}
?>