<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/02/11, 15:06
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  \class  oscss_boxes
  \note: Gestion de l'appel des modules (rep modules, noyau them plugin ou them module)
*/
class oscss_boxes {

  /**
   *
   * @var object
   */
  protected static $_instance;
  /**
   *
   * @var int
   */
  protected static $_key;
  /**
   * \fn  __construct()
  */
  protected function __construct() {
    global $page;
    $this->ext=$page->ext;
    $page->page['boxes']['list']=array();
    $page->page['boxes']['sort']=array();
  }
  /**
   * \fn getInstance()
   */
  public static function getInstance() {
    if(self::$_instance == null) self::$_instance = new self();
    return self::$_instance;
  }
  /**
   * \fn  __construct()
   */
  public static function resetInstance(){
    self::$_instance = null;
    return self::getInstance();
  }

  /**
   * \fn in_cache($path,$cache=true)
   *
   * @param $path string
   * @param $cache boolean
   */
  private static function in_cache($path,$cache=true){
    global $page, $PHP_SELF, $request_type,$language, $lang;

    self::$_key=md5($path);
    if($cache && OSCSS_DEBUG == false){
      $cache = page::GetCacheVar();
      if(!isset($cache['boxes'][self::$_key])) {
	include($path);
	page::AddCacheVar('boxes',self::$_key,$array);
      }
      else $array=$cache['boxes'][self::$_key];
    }
    else include($path);

    if(isset($array) && is_array($array)) return $array;
    else return ;
  }

  /**
   * \fn boxes($file_to_display,$type='std',$opt)
   * \brief
   * Scan template boxes folders and display template boxes if exist, if not display default oscss boxes
   * le type permet de classer les box par groupe
   * Seul l'extentions .php est autoriser
   * cherche dans plugins theme, puis, boxes theme, puis noyau
   * @param $file_to_display string
   * @param $type string : class de boite, en pile
   * @param opt array
  */
  private function boxes($file_to_display,$type='std',$opt) {
    global $page, $PHP_SELF, $request_type,$language, $lang;
    $name_clean=(strchr($file_to_display,'.')==$page->ext)? substr($file_to_display,0,strlen($file_to_display)-4) :$file_to_display ;
    if (!is_array($opt)) $opt=array();

    /* Force une taille d'image par defaut pour les images, si aucunne n'est pr�cis� */
    if (!isset($opt['img'])) $opt['img']=array('width'=>$page->the_var('SIDEBAR_IMG_WIDTH'),'height'=>$page->the_var('SIDEBAR_IMG_HEIGHT'));
    if (!isset($opt['img']['width'])) $opt['img']['width']=$page->the_var('SIDEBAR_IMG_WIDTH');
    if (!isset($opt['img']['height'])) $opt['img']['height']=$page->the_var('SIDEBAR_IMG_HEIGHT');

    /* Mise en cache */
    $cache=(isset($opt['cache']) && !_test_bool($opt['cache'])? false : true);

    $filename = DIR_WS_TEMPLATES . $page->page['template'] .'/' . DIR_WS_INCLUDES. '%s'. $name_clean.$page->ext;

    if (page::TestFile(sprintf($filename,'plugins/'))) $path =sprintf($filename,'plugins/');
    elseif (page::TestFile(sprintf($filename,'boxes/'))) $path =sprintf($filename,'boxes/');
    elseif (page::TestFile(DIR_WS_BOXES . $name_clean.$page->ext)) $path = (DIR_WS_BOXES . $name_clean.$page->ext);
    else return false;

    if(($path_lg=$page->fix_file(DIR_WS_INCLUDES .'languages/'. $language . '/boxes/' . $name_clean.$page->ext,true)) !=false) $page->pile_file_lang($path_lg);


    $res=array_merge((array)self::in_cache($path,$cache) ,array('name'=>$file_to_display,
				  'name_clean'=>$name_clean,
				  'path'=>$path
				));

    $page->page['boxes']['sort'][$name_clean]=(isset($opt['sort']))? $opt['sort']: ((count($page->page['boxes']['sort'])>0)?(count($page->page['boxes']['sort'])+50):50);
    $page->page['boxes']['list'][$name_clean]=   new objectInfo(array_merge($res,$opt));
    $page->page['boxes'][$type][$name_clean]='true';
  }

  /**
   * \fn widget($name_clean,$type='std',$opt)
   * \brief widget, appel de function chargée a l'identique des boxes.
   * @param $name_clean
   * @param $type string
   * @param $opt array
   */
  private function widget($name_clean,$type='std',$opt) {
    global $page, $PHP_SELF, $request_type, $lang;
    if (!is_array($opt)) $opt=array();

    /** Force une taille d'image par defaut pour les images, si aucunne n'est pr�cis� */
    if (!isset($opt['img'])) $opt['img']=array('width'=>$page->the_var('SIDEBAR_IMG_WIDTH'),'height'=>$page->the_var('SIDEBAR_IMG_HEIGHT'));
    if (!isset($opt['img']['width'])) $opt['img']['width']=$page->the_var('SIDEBAR_IMG_WIDTH');
    if (!isset($opt['img']['height'])) $opt['img']['height']=$page->the_var('SIDEBAR_IMG_HEIGHT');

    $boxe=$opt;
    if(!function_exists($name_clean) || isset($page->page['boxes']['list'][$name_clean]) ) return false;
    $array=call_user_func($name_clean);

    $res=array_merge($array,array('name'=>$name_clean,
                                  'name_clean'=>str_replace('Widget_','',$name_clean),
                                  'path'=>''
                                  ));
    $page->page['boxes']['sort'][$name_clean]=(isset($opt['sort']))? $opt['sort']: ((count($page->page['boxes']['sort'])>0)?(count($page->page['boxes']['sort'])+50):50);
    $page->page['boxes']['list'][$name_clean]=   new objectInfo(array_merge($res,$opt));
    $page->page['boxes'][$type][$name_clean]='true';
  }

  /**
   * \fn tep_call_boxes($boxe='',$type='')
   * \brief Chargement de la boxes
   *
   * @param $boxe
   * @param $type
   */
  private function tep_call_boxes($boxe='',$type=''){
    global $page, $lang;

    asort($page->page['boxes']['sort']);

    if(!empty($type) && !empty($boxe)) {
      $key=(strchr($boxe,'.')==$page->ext)? substr($boxe,0,strlen($boxe)-4) :$boxe ;
      if (isset($page->page['boxes'][$type]) && isset($page->page['boxes']['list'][$key]) &&  isset($page->page['boxes'][$type][$key]) && $page->page['boxes'][$type][$key] !='false')
        return $page->page['boxes']['list'][$key]->path;
      else return false;
    }
    elseif(!empty($type) && empty($boxe)){
      if( isset($page->page['boxes'][$type]) ){
	foreach($page->page['boxes']['sort'] as $k=>$v)
	  if(isset($page->page['boxes'][$type][$k]))$s[$k]=$page->page['boxes']['list'][$k];
	return $s;
      }
      else return array();
    }
    elseif(empty($type) && !empty($boxe)) {
      $key=(strchr($boxe,'.')==$page->ext)? substr($boxe,0,strlen($boxe)-4) :$boxe ;
      if (isset($page->page['boxes']['std'][$key]) && $page->page['boxes']['std'][$key] !='false') return $page->page['boxes']['list'][$key]->path;

      foreach($page->page['boxes']['sort'] as $k=>$v)
	if (isset($page->page['boxes'][$k][$key]) && $page->page['boxes'][$k][$key] !='false') return $page->page['boxes']['list'][$key]->path;
//       while($r=each($page->page['boxes'])){
//         if (isset($page->page['boxes'][$r['key']][$key]) && $page->page['boxes'][$r['key']][$key] !='false') return $page->page['boxes']['list'][$key]->path;
//       }

      return false;
    }
    else return $page->page['boxes'];
  }

  /**
   * \fn ret_boxes($key)
   * \brief  Retrun les info de la boxe
   * @param $key
   * @return string path file or boolean false
   */
  private function ret_boxes($key){
    global $page;
    if(!empty($key) && isset($page->page['boxes']['list'][$key]))return $page->page['boxes']['list'][$key];
    return false;
  }

  /**
  */
  public function _in_obj($box,$parameter=''){
    if(isset($box->content)) return true;
    else return false;
  }

  /**
   * \fn _add($file_to_display,$type='',$opt='')
   * \brief Alias de la function boxes
   * @param $file_to_display
   * @param $type
   * @param $opt
   */
  public function _add($file_to_display,$type='',$opt=''){
    global $page;
    return $this->boxes($file_to_display,$type,$opt);
  }

  /**
   * \fn _addWidget($name,$type='',$opt='')
   * \brief Alias de la function widget
   * @param $name
   * @param $type
   * @param $opt
   */
  public function _addWidget($name,$type='',$opt=''){
    global $page;
    return $this->widget($name,$type,$opt);
  }

  /**
   * \fn _call($boxe='',$type='')
   * \brief Alias de la function tep_call_boxes
   * @param $boxe
   * @param $type
   */
  public function _call($boxe='',$type=''){
    global $page;
    return $this->tep_call_boxes($boxe,$type);
  }

  /**
   * \fn  Alias de la function return
   * \brief  Alias de la function return
   * @param $key
   */
  public function _return($key){
    global $page;
    return $this->ret_boxes($key);
  }
}
?>