<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  24/10/10, 18:40
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class  oscss_plugins
  @note: Gestion de l'appel des modules (rep modules, noyau them plugin ou them module)
*/
class oscss_plugins {

  protected static $_instance;

  /**
  */
  protected function __construct(){
  }

  public static function getInstance() {
    if(self::$_instance == null) self::$_instance = new self();
    return self::$_instance;
  }

  public static function resetInstance(){
    self::$_instance = null;
    return self::getInstance();
  }

  /**
    Construit element plugins actif
    @param string type ( $this->page['type'])
  */
  public function plugins_active($type){
    $cst='PLUGIN_'.strtoupper($type).'_INSTALLED';
    $class=array();
    if (defined($cst)) {
     $files_array=explode (';',constant($cst));
      if (is_array($files_array) && !is_numeric($files_array[0]) && count($files_array)>0 ) {
        reset ($files_array);
        while (list ($key, $file) = each ($files_array)) $class[]=substr($file,0, strlen($file)-4 );
       }
    }
    return $class;
  }

  /**
    Test cache de libraire
  */
  private static function testCache($path){
    if(_test_bool(OSCSS_DEBUG)) return false;

    $res=page::GetCacheVar();
    $key=md5($path);
    if(!isset($res['plugin'][$key])){
      page::AddCacheVar('plugin',$key,'true');
      return false;
    }
    return true;
  }

  /**
    Test etat cache global, si false descative ache plugins
  */
  private static function gocache(){
    $res=page::GetCacheVar();
    if(!isset($res['plugin'])) return false;
    return true;
  }

  /**
    Charge les plugin, specifique à la page et generaux
    /plugin/
    /plugin/type/
  */
  public function active_plugins(){
    global $template, $language, $languages_id, $page;

    //! appel cache test
    $cache=(CacheLib::read('plugins-'.page::$keyCacheName) === false && !self::gocache() /*&& page::$CacheCalcul*/)? false : true ;

    if($cache && !_test_bool(OSCSS_DEBUG))require(CacheLib::getfilecache());

    $i_sort=5;
    $sort=$recache=$array_file=array();

    if(is_array($page->page['plugins']['present']))
    while ($r = each($page->page['plugins']['present'])) {
      $res=5;
      $file=$r['value'];
      $dir_ws_here = $page->getPathTemplate().  DIR_WS_INCLUDES. 'plugins/generic/'.$file. '/';
      $path= $dir_ws_here. 'includes_header.php';
      if (page::TestFile($path)){
	$array_file[]=$path;
	if(!self::testCache($path) && !function_exists($r['value'].'_scripts')){
	  require_once($path);
	  $recache[]=true;
	}
	$fct=$r['value'].'_sort';
	if (function_exists($fct))$res=$fct();
	$i=(isset($res)? $res : $i_sort);
	$sort[$file]=$i;
      }
    }

    if(isset($page->page['plugins']['type']) && is_array($page->page['plugins']['type']))
    while ($r = each($page->page['plugins']['type'])) {
      $res=5;
      $file=$r['value'];
      $dir_ws_here = $page->getPathTemplate().  DIR_WS_INCLUDES. 'plugins/'.$page->the_type().'/'.$file. '/';
      $path= $dir_ws_here. 'includes_header.php';
      if (page::TestFile($path)){
	$array_file[]=$path;
	if(!self::testCache($path) && !function_exists($r['value'].'_scripts')){
	  require_once($path);
	  $recache[]=true;
	}
	$fct=$r['value'].'_sort';
	if (function_exists($fct))$res=$fct();
	$i=(isset($res)? $res : $i_sort);
	$sort[$file]=$i;
      }
    }

    asort($sort);
    foreach($sort as $file=>$i)
      $page->page['plugins']['actif'][]=$file;

    if ($cache === false || in_array(true,$recache) ) {
      if(! _test_bool(OSCSS_DEBUG) )CacheLib::addfiles($array_file);
    }
  }


}
?>