<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.1.0
  \date  29/11/10, 11:33
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class payment
  \file 
  \dir includes/classes/
  
  \brief appel et init des modules de paiement 
*/

class payment extends AbstractAcaModule{
  var $modules=array();
  var $selected_module;

  protected static $_instance;

  function __construct($module='') {
    self::initialise($module);
  }

  public static function getInstance($module='')
  {
      if(self::$_instance == null) {
	  self::$_instance = new self($module);
      }
      return self::$_instance;
  }

  public static function resetInstance()
  {
      self::$_instance = null;
      return self::getInstance();
  }


  /**
    \brief class constructor
    @param  $module \a string
  */
  public function initialise($module = '') {
    global $payment, $language, $PHP_SELF,$customer_id,$page,$lang;

    $include_modules = array();
    if  (tep_not_null($module))  {
      $this->selected_module = $module;
      foreach(parent::initialise_type('MODULE_PAYMENT_INSTALLED','payment') as $class){
	if($class == $module) $include_modules[] = array('class' => $class, 'file' => $class . '.php');
      }
    } else {
      foreach(parent::initialise_type('MODULE_PAYMENT_INSTALLED','payment') as $class){
	$include_modules[] = array('class' => $class, 'file' => $class . '.php');
      }
    }

    if (isset($_SESSION['sppc_customer_group_id']) && $_SESSION['sppc_customer_group_id'] != '0') $customer_group_id = $_SESSION['sppc_customer_group_id'];
    else  $customer_group_id = '0';

    $customer_payment_query = tep_db_query("select IF(c.customers_payment_allowed <> '', c.customers_payment_allowed, cg.group_payment_allowed) as payment_allowed from " . TABLE_CUSTOMERS . " c, " . TABLE_CUSTOMERS_GROUPS . " cg where c.customers_id = '" . $customer_id . "' and cg.customers_group_id =  '" . $customer_group_id . "'");
    $customer_ot = tep_db_fetch_array($customer_payment_query);
    $temp_payment_array= (tep_not_null($customer_ot['payment_allowed']) )  ? explode(';', $customer_ot['payment_allowed']) : array() ;

    foreach($include_modules as $imod){
      if( ( count($temp_payment_array)==0 || in_array($imod['file'], $temp_payment_array ) ) ){
	if(!class_exists($imod['class'])) break;
	$GLOBALS[$imod['class']] = new $imod['class'];
	$this->modules[]=$imod['class'];
      }
    }

    // if there is only one payment method, select it as default because in
    // checkout_confirmation.php the $payment variable is being assigned the
    // $_POST['payment'] value which will be empty (no radio button selection possible)
    if ( (tep_count_payment_modules() == 1) && (!isset($GLOBALS[$payment]) || (isset($GLOBALS[$payment]) && !is_object($GLOBALS[$payment]))) ) {
	/*$this->selected_module=*/$payment = $include_modules[0]['class'];
    }

    if ( (tep_not_null($module)) && (in_array($module, $this->modules)) && (isset($GLOBALS[$module]->form_action_url)) ) {
      $this->form_action_url = $GLOBALS[$module]->form_action_url;
    }

  }

  /**
    \ref catalog/checkout_confirmation.php
    \brief 
    The following method is needed in the checkout_confirmation.php page
      due to a chicken and egg problem with the payment class and order class.
      The payment modules needs the order destination data for the dynamic status
      feature, and the order class needs the payment module title.
      The following method is a work-around to implementing the method in all
      payment modules available which would break the modules in the contributions
      section. This should be looked into again post 2.2.
  */
  public function update_status() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module])) {
	if (method_exists($GLOBALS[$this->selected_module], 'update_status')) {
	$GLOBALS[$this->selected_module]->update_status();
	}
      }
    }
  }

  public function javascript_validation() {
    global $page;
    $js = '';
    if (is_array($this->modules)) {
      $js = '<script type="text/javascript"><!-- ' . "\n" .
	    'function check_form() {' . "\n" .
	    '  var error = 0;' . "\n" .
	    '  var error_message = "' . JS_ERROR . '";' . "\n" .
	    '  var payment_value = null;' . "\n" .
	    '  if (document.getElementById("checkout_payment").payment.length) {' . "\n" .
	    '    for (var i=0; i<document.getElementById("checkout_payment").payment.length; i++) {' . "\n" .
	    '      if (document.getElementById("checkout_payment").payment[i].checked) {' . "\n" .
	    '        payment_value = document.getElementById("checkout_payment").payment[i].value;' . "\n" .
	    '      }' . "\n" .
	    '    }' . "\n" .
	    '  } else if (document.getElementById("checkout_payment").payment.checked) {' . "\n" .
	    '    payment_value = document.getElementById("checkout_payment").payment.value;' . "\n" .
	    '  } else if (document.getElementById("checkout_payment").payment.value) {' . "\n" .
	    '    payment_value = document.getElementById("checkout_payment").payment.value;' . "\n" .
	    '  }' . "\n\n";

      reset($this->modules);
      foreach($this->modules as $class){
	if (isset($GLOBALS[$class]) &&$GLOBALS[$class]->enabled)  $js .= $GLOBALS[$class]->javascript_validation();
      }

      $js .= "\n" .'if (document.getElementById("conditions").checked != true) {' . "\n" .
	    '    error_message = error_message + "' . JS_ERROR_NO_CHECK_CONDITION . '\n";' . "\n" .
	    '    error = 1;' . "\n" .
	    '  }' . "\n";

      $js .= "\n" . 'if (payment_value == null) {' . "\n" .
	    '    error_message = error_message + "' . JS_ERROR_NO_PAYMENT_MODULE_SELECTED . '";' . "\n" .
	    '    error = 1;' . "\n" .
	    '  }' . "\n\n" .
	    '  if (error == 1) {' . "\n" .
	    '    alert(error_message);' . "\n" .
	    '    return false;' . "\n" .
	    '  } else {' . "\n" .
	    '    return true;' . "\n" .
	    '  }' . "\n" .
	    '}' . "\n" .
	    '//--></script>' . "\n";
    }
    /// push  js in class javascript
//     $page->javascript->add_script_src(array('file'=>'payment_javascript_validation','script'=>tep_output_string_protected($js,false,true)) );
    return $js;
  }

  /**
    \ref  catalog/checkout_payment.php
  */
  public function selection() {
    $selection_array = array();

    if (is_array($this->modules)) {
      reset($this->modules);
      foreach($this->modules as $class){
	if (isset($GLOBALS[$class]) && $GLOBALS[$class]->enabled) {
	  $selection = $GLOBALS[$class]->selection();
	  if (is_array($selection)) $selection_array[] = $selection;
	}
      }
    }
    return $selection_array;
  }

  /**
    \ref catalog/checkout_payment.php
  */
  public function pre_confirmation_check() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled) && method_exists($GLOBALS[$this->selected_module], 'pre_confirmation_check') ) {
	$GLOBALS[$this->selected_module]->pre_confirmation_check();
      }
    }

  }
  
  /**
    \ref catalog/checkout_confirmation.php
  */
  public function confirmation() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled) && method_exists($GLOBALS[$this->selected_module], 'confirmation') ) {
	return $GLOBALS[$this->selected_module]->confirmation();
      }
    }
  }
  
  /**
    \ref catalog/checkout_confirmation.php
  */
  public function process_button() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled)&& method_exists($GLOBALS[$this->selected_module], 'process_button')  ) {
	return $GLOBALS[$this->selected_module]->process_button();
      }
    }
  }
  
  /**
    \ref catalog/checkout_process.php
  */
  function before_process() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled)&& method_exists($GLOBALS[$this->selected_module], 'before_process')  ) {
	return $GLOBALS[$this->selected_module]->before_process();
      }
    }
  }
  
  /**
    \ref catalog/checkout_process.php
  */
  public function after_process() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled)&& method_exists($GLOBALS[$this->selected_module], 'after_process')  ) {
	return $GLOBALS[$this->selected_module]->after_process();
      }
    }
  }

  /**
    \ref catalog/checkout_success.php
  */
  function payment_succes() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled)&& method_exists($GLOBALS[$this->selected_module], 'payment_succes')  ) {
	return $GLOBALS[$this->selected_module]->payment_succes();
      }
    }
  }

  public function get_error() {
    if (is_array($this->modules)) {
      if (is_object($GLOBALS[$this->selected_module]) && ($GLOBALS[$this->selected_module]->enabled)&& method_exists($GLOBALS[$this->selected_module], 'pre_confirmation_check')  ) {
	return $GLOBALS[$this->selected_module]->get_error();
      }
    }
  }
}
?>